---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-Aboutダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/gui/editor_about.cpp` 行209-380 コンストラクタ
- E-02: `editor/gui/editor_about.cpp` 行53-99 _notification()
- E-03: `editor/gui/editor_about.cpp` 行102-106 _license_tree_selected()
- E-04: `editor/gui/editor_about.cpp` 行117-137 _item_activated()
- E-05: `editor/gui/editor_about.cpp` 行143-207 _create_section()
- E-06: `editor/gui/editor_about.cpp` 行108-115 _credits_visibility_changed()
- E-07: `editor/gui/editor_about.h` クラス定義
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` 行25 画面定義
- E-09: `docs/code-to-docs/画面遷移図.md` 遷移定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バージョン情報、クレジット、ライセンス情報を表示 | E-01 | ○ |
| C-02 | Help > About Godotから起動 | E-09 | ○ |
| C-03 | Authorsタブで開発者一覧表示 | E-01 行249-265 | ○ |
| C-04 | Donorsタブでスポンサー一覧表示 | E-01 行267-285 | ○ |
| C-05 | LicenseタブでMITライセンス表示 | E-01 行287-296 | ○ |
| C-06 | Third-party Licensesタブでサードパーティライセンス表示 | E-01 行298-379 | ○ |
| C-07 | ダブルクリックでウェブサイトを開く | E-04 行119-120 OS::shell_open() | ○ |
| C-08 | イースターエッグ（クレジットロール） | E-04 行129-136 CreditsRoll | ○ |
| C-09 | ゲーム実行中はイースターエッグ起動しない | E-04 行123-127 is_playing()チェック | ○ |
| C-10 | Project Founders表示 | E-01 行259 AUTHORS_FOUNDERS | ○ |
| C-11 | Lead Developer表示 | E-01 行260 AUTHORS_LEAD_DEVELOPERS | ○ |
| C-12 | Project Manager表示 | E-01 行262 AUTHORS_PROJECT_MANAGERS | ○ |
| C-13 | Developers表示 | E-01 行264 AUTHORS_DEVELOPERS | ○ |
| C-14 | Patrons表示 | E-01 行277 DONORS_PATRONS | ○ |
| C-15 | Platinum/Gold/Silver Sponsors表示 | E-01 行278-280 | ○ |
| C-16 | Diamond/Titanium/Platinum/Gold Members表示 | E-01 行281-284 | ○ |
| C-17 | ロゴ表示 | E-01 行222-224 _logo | ○ |
| C-18 | EditorVersionButton使用 | E-01 行232 | ○ |
| C-19 | 著作権表示テキスト | E-01 行234-238 _about_text_label | ○ |
| C-20 | TabContainer使用 | E-01 行242-247 | ○ |
| C-21 | ダイアログタイトル「Thanks from the Godot community!」 | E-01 行210 | ○ |
| C-22 | 「No distractions for this, close that game first.」メッセージ | E-04 行125 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] イースターエッグの起動条件を実機で確認
- [ ] 各タブの表示内容がソースコードと一致することを確認
