---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：25-ファイルダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **サンドボックス環境でのネイティブダイアログ強制**：具体的な条件を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/gui/editor_file_dialog.cpp` 行40-64 _item_menu_id_pressed()
- E-02: `editor/gui/editor_file_dialog.cpp` 行66-73 _should_use_native_popup()
- E-03: `editor/gui/editor_file_dialog.cpp` 行75-81 _should_hide_file()
- E-04: `editor/gui/editor_file_dialog.cpp` 行83-85 _get_folder_color()
- E-05: `editor/gui/editor_file_dialog.cpp` 行131-173 _notification()
- E-06: `editor/gui/editor_file_dialog.h` クラス定義
- E-07: `scene/gui/dialogs/file_dialog.h` FileMode/Access列挙
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` 行26 画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイル・フォルダを選択・保存する汎用ダイアログ | E-07 FileMode | ○ |
| C-02 | リスト表示/サムネイル表示の切り替え | E-05 display_mode | ○ |
| C-03 | 単一選択/複数選択 | E-07 FILE_MODE_OPEN_FILE/FILES | ○ |
| C-04 | お気に入りフォルダの管理 | E-05 favorites | ○ |
| C-05 | 最近使用したフォルダへのアクセス | E-05 recent_dirs | ○ |
| C-06 | 隠しファイルの表示切り替え | E-05 show_hidden_files | ○ |
| C-07 | 新規フォルダの作成 | E-01 DirectoryCreateDialog | ○ |
| C-08 | ファイルタイプフィルタリング | E-07 filters | ○ |
| C-09 | ACCESS_RESOURCES/USERDATA/FILESYSTEM | E-07 Access enum | ○ |
| C-10 | file_selected シグナル | E-07 | ○ |
| C-11 | files_selected シグナル | E-07 | ○ |
| C-12 | dir_selected シグナル | E-07 | ○ |
| C-13 | DependencyRemoveDialogで依存関係チェック | E-01 行48-60 | ○ |
| C-14 | EditorSettings favorites に保存 | E-05 行136-157 | ○ |
| C-15 | ネイティブファイルダイアログ使用オプション | E-02 use_native_file_dialogs | ○ |
| C-16 | サンドボックス環境でネイティブダイアログ強制 | E-02 is_sandboxed() | △ |
| C-17 | Android環境での制限 | E-02 行67-70 ANDROID_ENABLED | ○ |
| C-18 | フォルダ色はFileSystemDockと同期 | E-04 get_dir_icon_color() | ○ |
| C-19 | EditorFileDialogはFileDialogを継承 | E-06 class定義 | ○ |
| C-20 | EditorFileSystem::_should_skip_directory使用 | E-03 | ○ |
| C-21 | 表示モードEditorSettingsに保存 | E-05 行170 | ○ |
| C-22 | EDITOR_GET使用 | E-05 行169-170 | ○ |
| C-23 | ItemListで一覧表示 | 基底クラス file_dialog.cpp | ○ |
| C-24 | dir_access->change_dir()でフォルダ移動 | 基底クラス file_dialog.cpp | ○ |

## 4) 不足情報（Unknown / Missing）
- サンドボックス環境の具体的な判定ロジック
  - 候補：core/os/os.h OS::is_sandboxed()

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどの主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] サンドボックス環境判定の動作を確認
- [ ] Android環境でのURIベースの動作を確認
- [ ] お気に入り/最近使用フォルダの保存・復元を確認
