---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-ディレクトリ作成ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/gui/directory_create_dialog.cpp` 行41-47 _sanitize_input()
- E-02: `editor/gui/directory_create_dialog.cpp` 行49-96 _validate_path()
- E-03: `editor/gui/directory_create_dialog.cpp` 行98-115 _on_dir_path_changed()
- E-04: `editor/gui/directory_create_dialog.cpp` 行117-126 ok_pressed()
- E-05: `editor/gui/directory_create_dialog.cpp` 行133-151 config()
- E-06: `editor/gui/directory_create_dialog.cpp` 行153-185 コンストラクタ
- E-07: `editor/gui/directory_create_dialog.h` クラス定義、MODE_DIRECTORY/MODE_FILE
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` 行27 画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フォルダ作成モードとファイル作成モード | E-07 MODE_DIRECTORY/MODE_FILE | ○ |
| C-02 | 空文字チェック | E-02 行50-51 | ○ |
| C-03 | 無効文字チェック（\ : * | > .終端） | E-02 行69-70 | ○ |
| C-04 | ドット開始チェック | E-02 行77-83 | ○ |
| C-05 | 既存ファイル/フォルダチェック | E-02 行86-93 | ○ |
| C-06 | スラッシュでサブフォルダ作成通知 | E-03 行103-108 | ○ |
| C-07 | accept_callback呼び出し | E-04 行124 | ○ |
| C-08 | EditorValidationPanel使用 | E-06 行178 | ○ |
| C-09 | ダイアログ最小幅480px | E-06 行154 | ○ |
| C-10 | ConfirmationDialog継承 | E-07 class定義 | ○ |
| C-11 | base_path_label表示 | E-05 行136 | ○ |
| C-12 | 「Name cannot be empty.」メッセージ | E-02 行51 TTR | ○ |
| C-13 | 「File name can't end with /.」メッセージ | E-02 行54 TTR | ○ |
| C-14 | 「Folder name cannot be empty.」メッセージ | E-02 行66 TTR | ○ |
| C-15 | 「Folder name contains invalid characters.」メッセージ | E-02 行74 TTR | ○ |
| C-16 | 「File with that name already exists.」メッセージ | E-02 行89 TTR | ○ |
| C-17 | 「Folder with that name already exists.」メッセージ | E-02 行92 TTR | ○ |
| C-18 | DirAccess::ACCESS_RESOURCESを使用 | E-02 行86 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 各バリデーションメッセージの表示を実機で確認
- [ ] サブフォルダ作成機能の動作を確認
