---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-クイックオープンダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/gui/editor_quick_open_dialog.cpp` 行105-138 コンストラクタ
- E-02: `editor/gui/editor_quick_open_dialog.cpp` 行152-163 popup_dialog()
- E-03: `editor/gui/editor_quick_open_dialog.cpp` 行191-198 ok_pressed()
- E-04: `editor/gui/editor_quick_open_dialog.cpp` 行232-278 preview_property()/update_property()
- E-05: `editor/gui/editor_quick_open_dialog.cpp` 行304-417 QuickOpenResultContainerコンストラクタ
- E-06: `editor/gui/editor_quick_open_dialog.cpp` 行419-429 _menu_option()
- E-07: `editor/gui/editor_quick_open_dialog.cpp` 行448-536 init()
- E-08: `editor/gui/editor_quick_open_dialog.cpp` 行600-603 set_query_and_update()
- E-09: `editor/gui/editor_quick_open_dialog.cpp` 行678-697 _update_fuzzy_search_results()/_score_and_sort_candidates()
- E-10: `editor/gui/editor_quick_open_dialog.cpp` 行854-871 _toggle_*/save_selected_item()
- E-11: `editor/gui/editor_quick_open_dialog.h` クラス定義
- E-12: `docs/code-to-docs/画面一覧/画面一覧.csv` 行28 画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファジー検索で素早くリソース選択 | E-09 FuzzySearch | ○ |
| C-02 | リスト/グリッド表示の切り替え | E-05 行350-356, E-10 行873-876 | ○ |
| C-03 | 最近使用したファイルの履歴表示 | E-07 history_file, selected_history | ○ |
| C-04 | インスタントプレビュー機能 | E-04, E-05 行385-390 | ○ |
| C-05 | FileSystemDockでの表示 | E-06 FILE_SHOW_IN_FILESYSTEM | ○ |
| C-06 | ファイルマネージャーでの表示 | E-06 FILE_SHOW_IN_FILE_MANAGER | ○ |
| C-07 | addonsフォルダのトグル | E-05 行399-404 include_addons_toggle | ○ |
| C-08 | 検索バー | E-01 行119-124 search_box | ○ |
| C-09 | 選択パス表示 | E-05 行368-374 file_details_path | ○ |
| C-10 | Fuzzy Searchトグル | E-05 行392-397 fuzzy_search_toggle | ○ |
| C-11 | 表示モード切替ボタン | E-05 行411-415 display_mode_toggle | ○ |
| C-12 | selection_changedシグナル | E-11 行1044 | ○ |
| C-13 | result_clickedシグナル | E-11 行1045 | ○ |
| C-14 | quick_open_dialog_cache.cfgに履歴保存 | E-10 行863-865 _get_cache_file_path() | ○ |
| C-15 | MAX_HISTORY_SIZE件まで保存 | E-10 行992-994 | ○ |
| C-16 | No files found for this type メッセージ | E-09 行722 | ○ |
| C-17 | No results found メッセージ | E-09 行724 | ○ |
| C-18 | (recently opened) 表示 | E-10 行818-819 | ○ |
| C-19 | Recursion detected エラー | E-04 行241 | ○ |
| C-20 | リソースタイプに応じた自動表示モード選択 | E-10 行934-951 get_adaptive_display_mode() | ○ |
| C-21 | 検索ハイライト機能 | E-01 行56-103 HighlightedLabel | ○ |
| C-22 | UIDベースでの履歴保存 | E-10 行953-956 _get_uid_string() | ○ |
| C-23 | max_results設定 | E-07 行432 EDITOR_GET | ○ |
| C-24 | QuickOpenResultContainer/Item/ListItem/GridItem構成 | E-11 クラス定義 | ○ |
| C-25 | ConfirmationDialog継承 | E-11 | ○ |
| C-26 | コンテキストメニュー（右クリック） | E-05 行358-363 file_context_menu | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ファジー検索の動作を実機で確認
- [ ] インスタントプレビュー機能の動作を確認
- [ ] 履歴保存・復元の動作を確認
- [ ] 各表示モード（リスト/グリッド）の切り替えを確認
