---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-ノード作成ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/gui/create_dialog.cpp` 行41-77 popup_create()
- E-02: `editor/gui/create_dialog.cpp` 行83-132 _fill_type_list()
- E-03: `editor/gui/create_dialog.cpp` 行142-158 _script_button_clicked()
- E-04: `editor/gui/create_dialog.cpp` 行160-233 _should_hide_type()
- E-05: `editor/gui/create_dialog.cpp` 行235-293 _update_search()
- E-06: `editor/gui/create_dialog.cpp` 行295-351 _add_type()
- E-07: `editor/gui/create_dialog.cpp` 行353-444 _configure_search_option_item()
- E-08: `editor/gui/create_dialog.cpp` 行447-490 _score_type()
- E-09: `editor/gui/create_dialog.h` クラス定義
- E-10: `docs/code-to-docs/画面一覧/画面一覧.csv` 行29 画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 継承階層に基づくノードタイプツリー | E-06 _add_type() | ○ |
| C-02 | サブシーケンス検索対応 | E-08 行453 is_subsequence_ofn() | ○ |
| C-03 | お気に入りノードの管理 | E-01 行67 _load_favorites_and_history() | ○ |
| C-04 | 最近使用したノードの履歴表示 | E-09 recent ItemList* | ○ |
| C-05 | タイプの置換モード | E-01 行52-54 p_replace_mode | ○ |
| C-06 | EditorFeatureProfileによる制限 | E-04 行160-164 _is_class_disabled_by_feature_profile() | ○ |
| C-07 | お気に入りボタン | E-09 favorite Button* | ○ |
| C-08 | ヘルプビット | E-09 help_bit EditorHelpBit* | ○ |
| C-09 | 非推奨バッジ | E-07 行418-419 is_deprecated | ○ |
| C-10 | 実験的バッジ | E-07 行420-421 is_experimental | ○ |
| C-11 | スクリプトボタン | E-07 行380 add_button | ○ |
| C-12 | ClassDB::get_class_list()使用 | E-02 行85 | ○ |
| C-13 | ScriptServer::get_global_class_list()使用 | E-02 行86 | ○ |
| C-14 | カスタムタイプ対応 | E-02 行107-119 get_custom_types() | ○ |
| C-15 | create_dialog/ プレフィックスで保存 | E-09 favorites/recents path | ○ |
| C-16 | dialog_bounds/create_new_node で位置保存 | E-01 行71-76 | ○ |
| C-17 | No results for "xxx" メッセージ | E-05 行289 | ○ |
| C-18 | Matches the "xxx" keyword メッセージ | E-07 行392-393 | ○ |
| C-19 | インスタンス化不可クラスはグレーアウト | E-07 行409-411 | ○ |
| C-20 | Editor系ノードは非表示 | E-04 行171-172 | ○ |
| C-21 | preferred_search_result_type | E-08 行473 | ○ |
| C-22 | TypeInfo構造体 | E-09 struct TypeInfo | ○ |
| C-23 | _score_type()でスコア計算 | E-08 | ○ |
| C-24 | グローバルクラスのスクリプトを開く | E-03 行151-156 push_item_no_inspector() | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] サブシーケンス検索の動作を確認
- [ ] お気に入り/履歴の保存・復元を確認
- [ ] 非推奨/実験的バッジの表示を確認
- [ ] EditorFeatureProfileによる制限を確認
