---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-進捗ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/gui/progress_dialog.cpp` 行42-65 _add_task()
- E-02: `editor/gui/progress_dialog.cpp` 行79-90 _task_step()
- E-03: `editor/gui/progress_dialog.cpp` 行92-100 _end_task()
- E-04: `editor/gui/progress_dialog.cpp` 行132-145 _notification()
- E-05: `editor/gui/progress_dialog.cpp` 行155-178 _popup()
- E-06: `editor/gui/progress_dialog.cpp` 行193-227 add_task()
- E-07: `editor/gui/progress_dialog.cpp` 行229-250 task_step()
- E-08: `editor/gui/progress_dialog.cpp` 行252-271 end_task()
- E-09: `editor/gui/progress_dialog.cpp` 行281-284 _cancel_pressed()
- E-10: `editor/gui/progress_dialog.cpp` 行285-310 コンストラクタ
- E-11: `editor/gui/progress_dialog.h` クラス定義
- E-12: `docs/code-to-docs/画面一覧/画面一覧.csv` 行30 画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 時間のかかる処理の進行状況を表示 | E-06, E-07 | ○ |
| C-02 | モーダルダイアログ | E-05 行158 EditorNode::set_process_input() | ○ |
| C-03 | シングルトンパターン | E-10 行290 singleton = this | ○ |
| C-04 | タスクラベル表示 | E-06 行203 add_margin_child(p_label) | ○ |
| C-05 | プログレスバー表示 | E-06 行204-207 ProgressBar | ○ |
| C-06 | ステータスラベル表示 | E-06 行209-210 state Label | ○ |
| C-07 | Cancelボタン（キャンセル可能時） | E-06 行215-218 p_can_cancel | ○ |
| C-08 | VBoxContainer内に縦並び | E-06 行201 VBoxContainer | ○ |
| C-09 | Z-indexが最大値 | E-10 行289 RS::CANVAS_ITEM_Z_MAX | ○ |
| C-10 | 他ウィンドウPROCESS_MODE_DISABLED | E-05 行160-165 | ○ |
| C-11 | 200ms以内の連続更新無視 | E-07 行234-237 200000us | ○ |
| C-12 | p_force_redrawで強制更新 | E-07 行233 | ○ |
| C-13 | キャンセル状態を戻り値で返す | E-07 行249 return canceled | ○ |
| C-14 | canceled フラグ | E-09 行282-283 | ○ |
| C-15 | host_windowsで管理対象追跡 | E-05 行160, E-08 行262-267 | ○ |
| C-16 | BackgroundProgressクラス | E-01, E-02, E-03 | ○ |
| C-17 | メッセージキュー処理中エラー | E-06 行194-197 is_flushing() | ○ |
| C-18 | 重複タスク追加でエラー | E-06 行199 ERR_FAIL_COND_MSG | ○ |
| C-19 | PopupProgressBarバリエーション | E-06 行205 set_theme_type_variation | ○ |
| C-20 | _update_ui()でMain::iteration() | E-04 行147-153, main/main.h | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] キャンセル機能の動作を確認
- [ ] 複数タスク同時実行時の表示を確認
- [ ] 200ms制限の動作を確認
