---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：3-2Dエディタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **ルーラー機能の詳細**：ガイドライン設定の実装確認
  2. **アニメーションプレビュー機能**：2Dエディタ内での動作確認

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/scene/canvas_item_editor_plugin.cpp` 行1-300
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行4
- E-03: `docs/code-to-docs/画面遷移図.md` 行44
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行10-14

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Canvas Item編集用エディタ | E-02 | ○ |
| C-02 | F1キーでアクセス | E-03 | ○ |
| C-03 | DRAG_THRESHOLD = 8 * EDSCALE | E-01 行73 | ○ |
| C-04 | SCALE_HANDLE_DISTANCE = 25 | E-01 行74 | ○ |
| C-05 | MOVE_HANDLE_DISTANCE = 25 | E-01 行75 | ○ |
| C-06 | SnapDialogクラスの存在 | E-01 行77-268 | ○ |
| C-07 | _is_node_locked()でロック判定 | E-01 行270-272 | ○ |
| C-08 | _is_node_movable()で移動可否判定 | E-01 行274-285 | ○ |
| C-09 | コンテナ子ノードの警告メッセージ | E-01 行280-281 | ○ |
| C-10 | _snap_if_closer_float()でスナップ | E-01 行287-298 | ○ |
| C-11 | 2Dレンダリングが主機能 | E-04 行10 | ○ |
| C-12 | カメラシステムが主機能 | E-04 行11 | ○ |
| C-13 | 2D物理シミュレーションが補助機能 | E-04 行12 | ○ |
| C-14 | 衝突検出が補助機能 | E-04 行13 | ○ |
| C-15 | シーンエディタが主機能 | E-04 行14 | ○ |
| C-16 | ViewPannerでパン操作 | E-01 行66 include | ○ |
| C-17 | EditorZoomWidgetでズーム | E-01 行45 include | ○ |
| C-18 | EditorToasterで警告表示 | E-01 行44 include | ○ |
| C-19 | ルーラー表示機能 | **根拠不足** | △ |
| C-20 | アニメーションプレビュー機能 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- ルーラー・ガイドライン機能の詳細実装
  - 候補：`editor/scene/canvas_item_editor_plugin.cpp` 後半部分
- アニメーションプレビューの2Dエディタ統合
  - 候補：`editor/animation/animation_player_editor_plugin.cpp`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な選択・変形操作
- 1: 中リスク - スナップ設定、グリッド表示
- 2: 高リスク - ルーラー機能の有無

## 6) レビュアーチェックリスト（最小）
- [ ] 各編集ツール（移動・回転・スケール）の動作確認
- [ ] スナップ設定ダイアログの項目確認
- [ ] コンテナ子ノード移動時の警告確認
- [ ] ルーラー機能の存在確認
