---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：30-スクリプト作成ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **プロジェクトテンプレートディレクトリ（script_templates/）**：具体的なパスを確認

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/script/script_create_dialog.cpp` 行113-159 _notification()
- E-02: `editor/script/script_create_dialog.cpp` 行195-212 config()
- E-03: `editor/script/script_create_dialog.cpp` 行218-231 _validate_parent()
- E-04: `editor/script/script_create_dialog.cpp` 行233-309 _validate_path()
- E-05: `editor/script/script_create_dialog.cpp` 行316-347 _template_changed()
- E-06: `editor/script/script_create_dialog.cpp` 行349-363 ok_pressed()
- E-07: `editor/script/script_create_dialog.cpp` 行365-398 _create_new()
- E-08: `editor/script/script_create_dialog.cpp` 行400-411 _load_exist()
- E-09: `editor/script/script_create_dialog.cpp` 行413-431 _language_changed()
- E-10: `editor/script/script_create_dialog.cpp` 行433-442 _built_in_pressed()
- E-11: `editor/script/script_create_dialog.cpp` 行450-475 _browse_path()
- E-12: `editor/script/script_create_dialog.h` クラス定義
- E-13: `docs/code-to-docs/画面一覧/画面一覧.csv` 行31 画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新しいスクリプトファイルを作成 | E-07 | ○ |
| C-02 | 既存のスクリプトを読み込み | E-08 | ○ |
| C-03 | 言語選択（GDScript、C#など） | E-01 行136-152 | ○ |
| C-04 | 継承クラスの指定 | E-03 | ○ |
| C-05 | テンプレート選択 | E-05 | ○ |
| C-06 | ビルトインスクリプトオプション | E-10 | ○ |
| C-07 | 拡張子自動変換 | E-09 行423-424 _adjust_file_path() | ○ |
| C-08 | テンプレート使用有無の記憶 | E-01 行127 _script_setup_use_script_templates | ○ |
| C-09 | script_created シグナル | E-07 行396, E-08 行409 emit_signal | ○ |
| C-10 | ResourceSaver::save() | E-07 行388 | ○ |
| C-11 | Path is empty エラー | E-04 行240 | ○ |
| C-12 | Filename is empty エラー | E-04 行243 | ○ |
| C-13 | Filename is invalid エラー | E-04 行247 | ○ |
| C-14 | Name begins with a dot エラー | E-04 行250 | ○ |
| C-15 | Path is not local エラー | E-04 行255 | ○ |
| C-16 | Base path is invalid エラー | E-04 行261 | ○ |
| C-17 | A directory with the same name exists エラー | E-04 行269 | ○ |
| C-18 | File does not exist エラー | E-04 行271 | ○ |
| C-19 | Invalid extension エラー | E-04 行301 | ○ |
| C-20 | Extension doesn't match chosen language エラー | E-04 行304 | ○ |
| C-21 | Error - Could not create script | E-07 行390-392 | ○ |
| C-22 | Error loading script from %s | E-08 行404-406 | ○ |
| C-23 | ファイル名ケーシング自動変換 | E-09 行190 adjust_script_name_casing() | ○ |
| C-24 | プロジェクトテンプレート（script_templates/） | **根拠不足** | △ |
| C-25 | EditorValidationPanel使用 | E-12 validation_panel | ○ |
| C-26 | CreateDialogで継承クラス選択 | E-12 select_class CreateDialog* | ○ |

## 4) 不足情報（Unknown / Missing）
- プロジェクトテンプレートディレクトリの具体的な読み込みロジック
  - 候補：script_language.cpp のテンプレート読み込み処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどの主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 各言語でのスクリプト作成を確認
- [ ] テンプレート選択と履歴保存を確認
- [ ] ビルトインスクリプト作成を確認
- [ ] 各バリデーションエラーの表示を確認
