---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：31-シーン作成ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **画面へのアクセス方法**：ソースコードからは直接確認できない
  2. **機能Noと関連機能**：機能一覧との整合性を要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/scene/scene_create_dialog.cpp` 全体（317行）
- E-02: `editor/scene/scene_create_dialog.h` 全体（99行）
- E-03: `editor/scene/scene_create_dialog.cpp` 44-46行目 RootType enum定義
- E-04: `editor/scene/scene_create_dialog.cpp` 189-316行目 コンストラクタ
- E-05: `editor/scene/scene_create_dialog.cpp` 65-77行目 config()メソッド
- E-06: `editor/scene/scene_create_dialog.cpp` 101-154行目 update_dialog()メソッド
- E-07: `editor/scene/scene_create_dialog.cpp` 160-187行目 create_scene_root()メソッド
- E-08: `editor/scene/scene_create_dialog.cpp` 79-84行目 accept_create()メソッド
- E-09: `editor/scene/scene_create_dialog.cpp` 86-90行目 browse_types()メソッド
- E-10: `editor/scene/scene_create_dialog.cpp` 314行目 ダイアログタイトル設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConfirmationDialogを継承している | E-02 44-45行目 | ○ |
| C-02 | 4つのルートタイプ（2D/3D/UI/Other）がある | E-03, E-04 212-243行目 | ○ |
| C-03 | シーン名が空の場合エラーメッセージ表示 | E-06 104-106行目 | ○ |
| C-04 | 同名ファイル存在時にエラー表示 | E-06 121-127行目 | ○ |
| C-05 | ルートノード名が空の場合シーン名から自動導出 | E-06 136-147行目 | ○ |
| C-06 | Node::adjust_name_casingが呼び出される | E-06 144行目 | ○ |
| C-07 | EditorFeatureProfileで3D機能制御 | E-05 72-77行目 | ○ |
| C-08 | ダイアログ最小サイズ400*EDSCALE | E-04 315行目 | ○ |
| C-09 | User Interface選択時にフルレクト適用 | E-07 173-178行目 | ○ |
| C-10 | 拡張子がPackedSceneから動的取得される | E-04 274-285行目 | ○ |
| C-11 | CreateDialogでノードタイプ選択 | E-04 190-193行目, E-09 | ○ |
| C-12 | 検証パネルで入力値検証 | E-04 303-308行目 | ○ |
| C-13 | confirmedシグナルを発行 | E-08 82行目 | ○ |
| C-14 | OKボタン無効時はaccept_createがスキップ | E-08 80-84行目 | ○ |
| C-15 | ファイル名がドットで始まる場合エラー | E-06 117-118行目 | ○ |
| C-16 | ファイル名が無効な場合エラー | E-06 115-116行目 | ○ |
| C-17 | ダイアログタイトルが「Create New Scene」 | E-10 | ○ |
| C-18 | テーマ変更時にアイコン更新 | E-01 49-57行目 | ○ |
| C-19 | node_type_groupのボタンがnullの場合エラー | E-07 161行目 | ○ |
| C-20 | rootがnullの場合エラー | E-07 184行目 | ○ |
| C-21 | Node2D/Node3D/Control/カスタムノード生成 | E-07 164-182行目 | ○ |
| C-22 | ルートノード名がrootに設定される | E-07 185行目 | ○ |
| C-23 | 無効な文字が含まれる場合警告メッセージ | E-06 151-153行目 | ○ |
| C-24 | scene_extension_pickerで拡張子選択 | E-04 278-285行目 | ○ |
| C-25 | text_submittedでaccept_createが呼ばれる | E-04 272行目, 296行目 | ○ |
| C-26 | 画面へのアクセス方法（メニュー操作） | **根拠なし** | △ |
| C-27 | 機能No F-001/F-002/F-003 | **根拠なし** | △ |
| C-28 | MSG_ID_ROOT成功メッセージ | E-04 306行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- **画面へのアクセス方法**：SceneCreateDialogがどこから呼び出されるかは、editor_node.cppなど他のファイルを確認する必要がある
  - 候補：editor_node.cpp / scene_tree_dock.cpp / editor_file_system.cpp
- **機能一覧との整合性**：機能一覧.csvとの照合が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード根拠が明確な技術的仕様（大多数）
- 1: 中リスク - 画面アクセス方法の記述（呼び出し元の確認が必要）
- 0: 低リスク - 機能関連の記述（機能一覧との整合性確認で解決可能）

## 6) レビュアーチェックリスト（最小）
- [ ] 画面へのアクセス方法がeditor_node.cppまたは関連ファイルで確認できるか
- [ ] 機能一覧.csvに記載の機能Noと整合性があるか
- [ ] 3D機能無効時の動作がEditorFeatureProfileManagerで正しく制御されているか
- [ ] 拡張子選択肢がPackedSceneのサポート拡張子と一致するか
