---
generated_at: 2026-01-23 12:10:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：32-シグナル接続ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **画面へのアクセス方法**：ConnectionsDockからの呼び出しを要確認
  2. **機能Noと関連機能**：機能一覧との整合性を要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/scene/connections_dialog.h` 全体（288行）
- E-02: `editor/scene/connections_dialog.cpp` 1-500行目
- E-03: `editor/scene/connections_dialog.cpp` 500-899行目
- E-04: `editor/scene/connections_dialog.h` 54-110行目 ConnectionData構造体
- E-05: `editor/scene/connections_dialog.cpp` 682-717行目 init()メソッド
- E-06: `editor/scene/connections_dialog.cpp` 719-735行目 popup_dialog()メソッド
- E-07: `editor/scene/connections_dialog.cpp` 195-216行目 _tree_node_selected()
- E-08: `editor/scene/connections_dialog.cpp` 258-296行目 generate_method_callback_name()
- E-09: `editor/scene/connections_dialog.cpp` 154-182行目 ok_pressed()
- E-10: `editor/scene/connections_dialog.cpp` 369-445行目 _update_method_tree()
- E-11: `editor/scene/connections_dialog.cpp` 758-899行目 コンストラクタ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConfirmationDialogを継承している | E-01 50-51行目 | ○ |
| C-02 | ConnectionData構造体でシグナル接続情報を保持 | E-04 | ○ |
| C-03 | シグナル名が空の場合エラーメッセージ表示 | E-09 157-161行目 | ○ |
| C-04 | 無効な識別子の場合エラー表示 | E-09 163-167行目 | ○ |
| C-05 | ターゲットノード未選択時OKボタン無効 | E-02 466-472行目 | ○ |
| C-06 | generate_method_callback_nameでメソッド名自動生成 | E-08 | ○ |
| C-07 | プロジェクト設定からメソッド名フォーマット取得 | E-08 290-293行目 | ○ |
| C-08 | ダイアログ最小サイズ500*EDSCALE（高さ） | E-11 759行目 | ○ |
| C-09 | Script Methods Onlyフィルタリングオプション | E-03 844-848行目 | ○ |
| C-10 | Compatible Methods Onlyフィルタリングオプション | E-03 850-854行目 | ○ |
| C-11 | フィルタ設定がEditorSettingsに保存される | E-02 449-452行目 | ○ |
| C-12 | Advancedトグルで高度なオプション表示切替 | E-03 737-756行目 | ○ |
| C-13 | connectedシグナルを発行 | E-02 180行目, 525-527行目 | ○ |
| C-14 | CONNECT_DEFERREDフラグのサポート | E-05 699行目 | ○ |
| C-15 | CONNECT_ONE_SHOTフラグのサポート | E-05 700行目 | ○ |
| C-16 | CONNECT_APPEND_SOURCE_OBJECTフラグのサポート | E-05 701行目 | ○ |
| C-17 | スクリプト接続モードとノード接続モードの切替 | E-03 739-751行目 | ○ |
| C-18 | _add_bindでバインド引数追加 | E-02 230-239行目 | ○ |
| C-19 | _remove_bindでバインド引数削除 | E-02 244-254行目 | ○ |
| C-20 | unbind_countでアンバインド数設定 | E-05 707-708行目 | ○ |
| C-21 | メソッドツリーでスクリプトメソッドとクラスメソッド表示 | E-10 396-442行目 | ○ |
| C-22 | _filter_method_listで互換性チェック | E-02 306-367行目 | ○ |
| C-23 | スクリプトなしでメソッドなしの場合エラー | E-09 173-179行目 | ○ |
| C-24 | 警告ラベルでメソッド生成不可を通知 | E-02 482-504行目 | ○ |
| C-25 | シーンにスクリプトがない場合エラー表示 | E-06 726-727行目 | ○ |
| C-26 | SceneTreeEditorで接続先ノード選択 | E-11 774-782行目 | ○ |
| C-27 | EditorInspectorでバインド引数編集 | E-03 885-890行目 | ○ |
| C-28 | filter_nodesでノードフィルタリング | E-11 786-792行目 | ○ |
| C-29 | 高度なオプション設定がEditorSettingsに保存 | E-03 753行目 | ○ |
| C-30 | method_popupでメソッド選択ポップアップ表示 | E-03 814-817行目, E-02 456-460行目 | ○ |
| C-31 | 画面へのアクセス方法（シグナルドックから） | **根拠なし** | △ |
| C-32 | 機能No F-010/F-011/F-012/F-013 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **画面へのアクセス方法**：ConnectionsDockからConnectDialogがどのように呼び出されるかの確認が必要
  - 候補：connections_dialog.cpp内のConnectionsDock実装部分 / signals_dock.cpp
- **機能一覧との整合性**：機能一覧.csvとの照合が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード根拠が明確な技術的仕様（大多数）
- 1: 中リスク - 画面アクセス方法の記述（呼び出し元の確認が必要）
- 0: 低リスク - 機能関連の記述（機能一覧との整合性確認で解決可能）

## 6) レビュアーチェックリスト（最小）
- [ ] ConnectionsDockからConnectDialogの呼び出しパスを確認
- [ ] 機能一覧.csvに記載の機能Noと整合性があるか
- [ ] generate_method_callback_nameのフォーマット設定が正しく参照されているか
- [ ] バインド/アンバインド処理がCallableCustomBind/Unbindと整合しているか
- [ ] 高度なオプションの表示/非表示切替が正しく動作するか
