---
generated_at: 2026-01-23 12:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：33-親変更ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **画面へのアクセス方法**：scene_tree_dock.cppでの呼び出しを要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/scene/reparent_dialog.cpp` 全体（90行）
- E-02: `editor/scene/reparent_dialog.h` 全体（56行）
- E-03: `editor/scene/reparent_dialog.cpp` 71-89行目 コンストラクタ
- E-04: `editor/scene/reparent_dialog.cpp` 53-58行目 _reparent()
- E-05: `editor/scene/reparent_dialog.cpp` 60-63行目 set_current()
- E-06: `editor/scene/reparent_dialog.cpp` 65-69行目 _bind_methods()
- E-07: `editor/scene/reparent_dialog.cpp` 37-47行目 _notification()

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConfirmationDialogを継承している | E-02 38-39行目 | ○ |
| C-02 | SceneTreeEditorで親ノード選択 | E-03 77-81行目 | ○ |
| C-03 | Keep Global Transformチェックボックス | E-03 83-86行目 | ○ |
| C-04 | デフォルトでKeep Global Transformがオン | E-03 85行目 | ○ |
| C-05 | ダイアログタイトルが「Reparent Node」 | E-03 72行目 | ○ |
| C-06 | OKボタンテキストが「Reparent」 | E-03 88行目 | ○ |
| C-07 | item_activatedで_reparent()呼び出し | E-03 80行目 | ○ |
| C-08 | reparentシグナルの定義 | E-06 68行目 | ○ |
| C-09 | シグナル引数がNodePathとbool | E-06 68行目 | ○ |
| C-10 | _reparent()で選択ノード確認 | E-04 54行目 | ○ |
| C-11 | _reparent()でget_path()使用 | E-04 55行目 | ○ |
| C-12 | _reparent()でis_pressed()使用 | E-04 55行目 | ○ |
| C-13 | set_current()でset_marked()呼び出し | E-05 61行目 | ○ |
| C-14 | set_current()でset_selected(nullptr) | E-05 62行目 | ○ |
| C-15 | NOTIFICATION_ENTER_TREEでシグナル接続 | E-07 39-41行目 | ○ |
| C-16 | set_update_when_invisible(false)設定 | E-03 78行目 | ○ |
| C-17 | set_show_enabled_subscene(true)設定 | E-03 79行目 | ○ |
| C-18 | 画面へのアクセス方法（右クリックメニュー） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **画面へのアクセス方法**：ReparentDialogがどこから呼び出されるかの確認が必要
  - 候補：scene_tree_dock.cpp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード根拠が明確な技術的仕様（大多数）
- 1: 中リスク - 画面アクセス方法の記述（呼び出し元の確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] scene_tree_dock.cppからReparentDialogの呼び出しパスを確認
- [ ] Keep Global Transformの実際の動作（トランスフォーム再計算）を確認
- [ ] 選択ノード自身が親として選択不可になることを確認
- [ ] 複数ノード選択時のマーク動作を確認
