---
generated_at: 2026-01-23 12:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 34
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：34-名前変更ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：34 / 35、根拠なし：1
- 優先レビュー（高）
  1. **画面へのアクセス方法**：scene_tree_dock.cppでの呼び出しとショートカットを要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/scene/rename_dialog.cpp` 全体（668行）
- E-02: `editor/scene/rename_dialog.h` 全体（112行）
- E-03: `editor/scene/rename_dialog.cpp` 49-345行目 コンストラクタ
- E-04: `editor/scene/rename_dialog.cpp` 582-614行目 rename()
- E-05: `editor/scene/rename_dialog.cpp` 552-580行目 _iterate_scene()
- E-06: `editor/scene/rename_dialog.cpp` 417-444行目 _apply_rename()
- E-07: `editor/scene/rename_dialog.cpp` 446-476行目 _substitute()
- E-08: `editor/scene/rename_dialog.cpp` 506-550行目 _postprocess()
- E-09: `editor/scene/rename_dialog.cpp` 500-504行目 _regex()
- E-10: `editor/scene/rename_dialog.cpp` 616-639行目 reset()
- E-11: `editor/scene/rename_dialog.cpp` 478-498行目 _error_handler()

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConfirmationDialogを継承している | E-02 45-46行目 | ○ |
| C-02 | ダイアログタイトルが「Batch Rename」 | E-03 53行目 | ○ |
| C-03 | Search/Replace/Prefix/Suffixの4つのテキストフィールド | E-03 60-109行目 | ○ |
| C-04 | Use Regular Expressionsチェックボタン | E-03 113-115行目 | ○ |
| C-05 | Advanced Optionsチェックボタン | E-03 117-119行目 | ○ |
| C-06 | Substituteタブの存在 | E-03 128-206行目 | ○ |
| C-07 | 変数挿入ボタン（NAME/PARENT/TYPE/SCENE/ROOT/COUNTER） | E-03 144-200行目 | ○ |
| C-08 | Per-level Counterチェックボックス | E-03 202-205行目 | ○ |
| C-09 | カウンターオプション（Start/Step/Padding） | E-03 215-242行目 | ○ |
| C-10 | Post-Processタブの存在 | E-03 246-286行目 | ○ |
| C-11 | Styleオプション（Keep/PascalCase to snake_case/snake_case to PascalCase） | E-03 264-269行目 | ○ |
| C-12 | Caseオプション（Keep/To Lowercase/To Uppercase） | E-03 280-285行目 | ○ |
| C-13 | プレビューラベルの存在 | E-03 293-300行目 | ○ |
| C-14 | ダイアログ最小サイズ383ピクセル | E-03 304行目 | ○ |
| C-15 | OKボタンテキストが「Rename」 | E-03 305行目 | ○ |
| C-16 | Resetボタンの存在 | E-03 306行目 | ○ |
| C-17 | ok_pressed()からrename()呼び出し | E-02 48行目 | ○ |
| C-18 | EditorSelectionから選択ノード取得 | E-04 586-587行目 | ○ |
| C-19 | _iterate_scene()でシーンツリー走査 | E-04 594行目, E-05 | ○ |
| C-20 | EditorUndoRedoManagerでUndo/Redo対応 | E-04 597-598行目, 612行目 | ○ |
| C-21 | scene_tree_editor->rename_node()で名前変更 | E-04 609行目 | ○ |
| C-22 | 逆順で名前変更適用 | E-04 601行目 | ○ |
| C-23 | _apply_rename()で検索・置換処理 | E-06 | ○ |
| C-24 | cbut_substitute->is_pressed()で変数置換判定 | E-06 424行目 | ○ |
| C-25 | cbut_regex->is_pressed()で正規表現モード判定 | E-06 431行目 | ○ |
| C-26 | cbut_process->is_pressed()で後処理判定 | E-06 439行目 | ○ |
| C-27 | _substitute()で${COUNTER}等の変数展開 | E-07 447-475行目 | ○ |
| C-28 | _postprocess()でスタイル/ケース変換 | E-08 | ○ |
| C-29 | RegExクラス使用 | E-09 501行目 | ○ |
| C-30 | reset()で全フィールドリセット | E-10 | ○ |
| C-31 | 正規表現エラー時に_error_handler()でエラー表示 | E-11 | ○ |
| C-32 | _post_popup()で選択ノード取得とプレビュー更新 | E-01 371-384行目 | ○ |
| C-33 | カウンターがシーンツリー順で適用 | E-05 577-579行目 | ○ |
| C-34 | Per-level Counterでカウンターリセット | E-05 573-575行目 | ○ |
| C-35 | 画面へのアクセス方法（右クリックメニュー） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **画面へのアクセス方法**：RenameDialogがどこから呼び出されるかの確認が必要
  - 候補：scene_tree_dock.cpp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード根拠が明確な技術的仕様（大多数）
- 1: 中リスク - 画面アクセス方法の記述（呼び出し元の確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] scene_tree_dock.cppからRenameDialogの呼び出しパスを確認
- [ ] 正規表現エラーハンドリングが正しく動作するか確認
- [ ] Undo/Redo操作が正しく機能するか確認
- [ ] Per-level Counterの動作が期待通りか確認
- [ ] 変数置換がすべて正しく展開されるか確認
