---
generated_at: 2026-01-23 12:40:00
metrics:
  claims_total: 32
  claims_with_evidence: 31
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：35-シェーダー作成ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：31 / 32、根拠なし：1
- 優先レビュー（高）
  1. **画面へのアクセス方法**：呼び出し元の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/shader/shader_create_dialog.cpp` 全体（582行）
- E-02: `editor/shader/shader_create_dialog.h` 全体（110行）
- E-03: `editor/shader/shader_create_dialog.cpp` 476-581行目 コンストラクタ
- E-04: `editor/shader/shader_create_dialog.cpp` 320-381行目 config()
- E-05: `editor/shader/shader_create_dialog.cpp` 196-248行目 _type_changed()
- E-06: `editor/shader/shader_create_dialog.cpp` 132-181行目 _create_new()
- E-07: `editor/shader/shader_create_dialog.cpp` 183-194行目 _load_exist()
- E-08: `editor/shader/shader_create_dialog.cpp` 383-419行目 _validate_path()
- E-09: `editor/shader/shader_create_dialog.cpp` 421-467行目 _update_dialog()
- E-10: `editor/shader/shader_create_dialog.cpp` 469-474行目 _bind_methods()

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConfirmationDialogを継承している | E-02 44-45行目 | ○ |
| C-02 | ダイアログタイトルが「Create Shader」 | E-03 580行目 | ○ |
| C-03 | Type/Mode/Templateの3つのドロップダウン | E-03 506-534行目 | ○ |
| C-04 | Built-in Shaderチェックボックス | E-03 538-543行目 | ○ |
| C-05 | Pathテキスト入力と参照ボタン | E-03 547-561行目 | ○ |
| C-06 | ShaderInclude選択時にModeが無効化 | E-05 224-226行目 | ○ |
| C-07 | テンプレートメニュー内容がuse_templatesで制御 | E-05 231-244行目 | ○ |
| C-08 | Default/Emptyテンプレートオプション | E-05 237-238行目 | ○ |
| C-09 | 組み込み有効時にパス入力無効化 | E-09 434-445行目 | ○ |
| C-10 | EditorShaderLanguagePluginで新規シェーダー作成 | E-06 137-144行目 | ○ |
| C-11 | shader_createdシグナル定義 | E-10 472行目 | ○ |
| C-12 | shader_include_createdシグナル定義 | E-10 473行目 | ○ |
| C-13 | ResourceSaverでファイル保存 | E-06 150, 168行目 | ○ |
| C-14 | ResourceLoaderで既存シェーダー読み込み | E-07 185行目 | ○ |
| C-15 | パス検証で空チェック | E-08 387-389行目 | ○ |
| C-16 | パス検証でファイル名空チェック | E-08 390-392行目 | ○ |
| C-17 | パス検証でres://チェック | E-08 394-397行目 | ○ |
| C-18 | パス検証で基本パスチェック | E-08 399-402行目 | ○ |
| C-19 | パス検証でディレクトリ存在チェック | E-08 404-407行目 | ○ |
| C-20 | パス検証で拡張子チェック | E-08 409-418行目 | ○ |
| C-21 | OKボタンテキストがCreate/Loadで変化 | E-09 454-466行目 | ○ |
| C-22 | タイプメニュー最小サイズ250*EDSCALE | E-03 509行目 | ○ |
| C-23 | 最後に選択した言語がEditorSettingsに保存 | E-05 246行目, E-04 344-352行目 | ○ |
| C-24 | 最後に選択したモードがEditorSettingsに保存 | E-01 109行目 | ○ |
| C-25 | 最後に選択したテンプレートがEditorSettingsに保存 | E-01 114行目 | ○ |
| C-26 | 組み込み設定がEditorSettingsに保存 | E-01 122行目 | ○ |
| C-27 | 組み込みシェーダーパスがシーンパス+ユニークID | E-06 160-163行目 | ○ |
| C-28 | _path_changed()で検証とis_new_shader_created設定 | E-01 290-312行目 | ○ |
| C-29 | MSG_ID_SHADER/MSG_ID_PATH/MSG_ID_BUILT_INメッセージ | E-02 47-51行目, E-03 487-489行目 | ○ |
| C-30 | EditorFileDialogでファイル選択 | E-03 565-568行目 | ○ |
| C-31 | ShaderTypeData構造体の定義 | E-02 53-57行目 | ○ |
| C-32 | 画面へのアクセス方法 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **画面へのアクセス方法**：ShaderCreateDialogがどこから呼び出されるかの確認が必要
  - 候補：editor_node.cpp / file_system_dock.cpp / material_editor_plugin.cpp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード根拠が明確な技術的仕様（大多数）
- 1: 中リスク - 画面アクセス方法の記述（呼び出し元の確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] ShaderCreateDialogの呼び出し元を確認
- [ ] EditorShaderLanguagePluginのシェーダー生成が正しく動作するか確認
- [ ] 組み込みシェーダーのパス生成が期待通りか確認
- [ ] ResourceSaver/ResourceLoaderのエラーハンドリングを確認
- [ ] テンプレート（Default/Empty）の内容を確認
