---
generated_at: 2026-01-23 12:50:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：36-入力イベント設定ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **画面へのアクセス方法**：ActionMapEditorからの呼び出しを要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/settings/input_event_configuration_dialog.cpp` 全体（782行）
- E-02: `editor/settings/input_event_configuration_dialog.h` 全体（139行）
- E-03: `editor/settings/input_event_configuration_dialog.cpp` 643-781行目 コンストラクタ
- E-04: `editor/settings/input_event_configuration_dialog.cpp` 44-203行目 _set_event()
- E-05: `editor/settings/input_event_configuration_dialog.cpp` 205-266行目 _on_listen_input_changed()
- E-06: `editor/settings/input_event_configuration_dialog.cpp` 272-373行目 _update_input_list()
- E-07: `editor/settings/input_event_configuration_dialog.cpp` 456-551行目 _input_list_item_selected()
- E-08: `editor/settings/input_event_configuration_dialog.cpp` 599-632行目 popup_and_configure()
- E-09: `editor/settings/input_event_configuration_dialog.h` 74-102行目 ModCheckbox/KeyMode enum

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConfirmationDialogを継承している | E-02 42-43行目 | ○ |
| C-02 | EventListenerLineEditで入力リスニング | E-03 659-663行目 | ○ |
| C-03 | 4つのModCheckbox（Alt/Shift/Ctrl/Meta） | E-09 74-80行目, E-03 729-737行目 | ○ |
| C-04 | 3つのKeyMode（Keycode/Physical/Unicode） | E-09 98-102行目, E-03 752-756行目 | ○ |
| C-05 | KeyLocation（Unspecified/Left/Right） | E-03 767-773行目 | ○ |
| C-06 | autoremap_command_or_controlチェックボックス | E-03 741-745行目 | ○ |
| C-07 | ダイアログ最小サイズ800*EDSCALE | E-03 646行目 | ○ |
| C-08 | ポップアップサイズ(0,400)*EDSCALE | E-08 631行目 | ○ |
| C-09 | デフォルトでPhysical Keycode選択 | E-08 616行目 | ○ |
| C-10 | デバイス-1がAll Devices | E-03 716-721行目 | ○ |
| C-11 | 許可されていない入力タイプで早期リターン | E-05 232-234行目 | ○ |
| C-12 | キーイベントのキーモード処理 | E-05 240-255行目 | ○ |
| C-13 | _set_event()でイベントタイプ判定 | E-04 59-109行目 | ○ |
| C-14 | 入力リストツリーでの選択同期 | E-04 153-191行目 | ○ |
| C-15 | キーボードキーの追加（keycode_get_count） | E-06 280-298行目 | ○ |
| C-16 | マウスボタン9種類 | E-06 307行目 | ○ |
| C-17 | ジョイパッドボタン（JoyButton::MAX） | E-06 331行目 | ○ |
| C-18 | ジョイパッド軸（JoyAxis::MAX * 2） | E-06 354行目 | ○ |
| C-19 | _input_list_item_selected()でInputEvent生成 | E-07 471-550行目 | ○ |
| C-20 | 修飾キー状態の維持 | E-07 482-489行目, 515-522行目 | ○ |
| C-21 | プラットフォーム別の修飾キー名 | E-02 81-87行目 | ○ |
| C-22 | IconCacheでカテゴリアイコン | E-02 45-50行目, E-01 581-584行目 | ○ |
| C-23 | 検索フィルタリング | E-06 290-292行目等 | ○ |
| C-24 | popup_and_configure()でイベント設定 | E-08 599-632行目 | ○ |
| C-25 | get_event()でイベント返却 | E-01 634-636行目 | ○ |
| C-26 | set_allowed_input_types()で入力タイプ制限 | E-01 638-641行目 | ○ |
| C-27 | _mod_toggled()で修飾キー更新 | E-01 375-398行目 | ○ |
| C-28 | _key_mode_selected()でキーモード切替 | E-01 416-438行目 | ○ |
| C-29 | _device_selection_changed()でデバイス更新 | E-01 553-558行目 | ○ |
| C-30 | 画面へのアクセス方法 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **画面へのアクセス方法**：ActionMapEditorからの呼び出しパスの確認が必要
  - 候補：action_map_editor.cpp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード根拠が明確な技術的仕様（大多数）
- 1: 中リスク - 画面アクセス方法の記述（呼び出し元の確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] ActionMapEditorからの呼び出しパスを確認
- [ ] キーモード切替が正しく動作するか確認
- [ ] Command/Control自動リマップがプラットフォームごとに正しく動作するか確認
- [ ] 入力リストの検索フィルタリングが期待通りか確認
- [ ] 修飾キー状態がリスト選択時に正しく維持されるか確認
