---
generated_at: 2026-01-23 12:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-レイアウト保存ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/settings/editor_layouts_dialog.cpp` 全体（140行）
- E-02: `editor/settings/editor_layouts_dialog.h` 全体（59行）
- E-03: `editor/settings/editor_layouts_dialog.cpp` 112-135行目 コンストラクタ
- E-04: `editor/settings/editor_layouts_dialog.cpp` 86-110行目 _post_popup()
- E-05: `editor/settings/editor_layouts_dialog.cpp` 75-84行目 ok_pressed()
- E-06: `editor/settings/editor_layouts_dialog.cpp` 71-73行目 _bind_methods()

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConfirmationDialogを継承している | E-02 38-39行目 | ○ |
| C-02 | ItemListで既存レイアウト一覧表示 | E-03 116-126行目 | ○ |
| C-03 | LineEditで新規名前入力 | E-03 128-134行目 | ○ |
| C-04 | SELECT_MULTIで複数選択可 | E-03 118行目 | ○ |
| C-05 | 右クリック選択許可 | E-03 119行目 | ○ |
| C-06 | name_confirmedシグナル定義 | E-06 72行目 | ○ |
| C-07 | ConfigFileからレイアウト読み込み | E-04 91-96行目 | ○ |
| C-08 | get_sections()でセクション取得 | E-04 98行目 | ○ |
| C-09 | '/'を含まないセクションのみ追加 | E-04 101行目 | ○ |
| C-10 | _update_ok_disable_state()でOKボタン制御 | E-01 57-63行目 | ○ |
| C-11 | 選択があればOKボタン有効 | E-01 58-59行目 | ○ |
| C-12 | 名前入力があればOKボタン有効 | E-01 61行目 | ○ |
| C-13 | _deselect_layout_names()で選択解除 | E-01 65-69行目 | ○ |
| C-14 | ui_text_submitでok_pressed()呼び出し | E-01 44-49行目 | ○ |
| C-15 | 選択アイテムに対してシグナル発行 | E-05 77-80行目 | ○ |
| C-16 | 名前入力に対してシグナル発行 | E-05 81-83行目 | ○ |
| C-17 | set_name_line_enabled()で名前入力表示制御 | E-01 137-139行目 | ○ |
| C-18 | ダイアログ最小サイズ300*50*EDSCALE | E-03 124行目 | ○ |
| C-19 | プレースホルダー「Or enter new layout name.」 | E-03 130行目 | ○ |
| C-20 | 名前入力フォーカス時に既存選択解除 | E-03 133行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目にコード根拠が存在

## 6) レビュアーチェックリスト（最小）
- [ ] ConfigFile読み込みエラー時の動作を確認
- [ ] 複数選択時のname_confirmedシグナル発行順序を確認
- [ ] set_name_line_enabled(false)時のOKボタン制御が正しいか確認
