---
generated_at: 2026-01-23 13:10:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：38-プラグイン設定ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **画面へのアクセス方法**：プロジェクト設定からの呼び出しパスを要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/plugins/plugin_config_dialog.cpp` 全体（332行）
- E-02: `editor/plugins/plugin_config_dialog.h` 全体（85行）
- E-03: `editor/plugins/plugin_config_dialog.cpp` 197-331行目 コンストラクタ
- E-04: `editor/plugins/plugin_config_dialog.cpp` 162-191行目 config()
- E-05: `editor/plugins/plugin_config_dialog.cpp` 108-137行目 _on_required_text_changed()
- E-06: `editor/plugins/plugin_config_dialog.cpp` 53-77行目 _on_confirmed()
- E-07: `editor/plugins/plugin_config_dialog.cpp` 79-102行目 _create_script_for_plugin()
- E-08: `editor/plugins/plugin_config_dialog.cpp` 193-195行目 _bind_methods()

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConfirmationDialogを継承している | E-02 42-43行目 | ○ |
| C-02 | MSG_ID列挙が5つ定義されている | E-02 45-51行目 | ○ |
| C-03 | _edit_modeで作成/編集モード切り替え | E-02 65行目, E-04 175-180行目 | ○ |
| C-04 | Plugin Name入力（プレースホルダーMyPlugin） | E-03 217-218行目 | ○ |
| C-05 | Subfolder入力（hidden_controlsに追加） | E-03 229, 237行目 | ○ |
| C-06 | Description入力（400*80*EDSCALE） | E-03 248行目 | ○ |
| C-07 | Author入力（プレースホルダーGodette） | E-03 261行目 | ○ |
| C-08 | Version入力（プレースホルダー1.0） | E-03 275行目 | ○ |
| C-09 | Language選択（ScriptServer登録言語） | E-03 290-297行目 | ○ |
| C-10 | デフォルトGDScript選択 | E-03 293-295行目 | ○ |
| C-11 | Script Name入力 | E-03 306-311行目 | ○ |
| C-12 | EditorValidationPanel使用 | E-03 317-325行目 | ○ |
| C-13 | text_changed接続でvalidation更新 | E-03 328-330行目 | ○ |
| C-14 | 編集モードでConfigFile読み込み | E-04 164-166行目 | ○ |
| C-15 | 新規作成で_clear_fields()呼び出し | E-04 178行目 | ○ |
| C-16 | OKボタンテキストがUpdate/Create | E-04 190行目 | ○ |
| C-17 | プラグイン名空チェック | E-05 109-111行目 | ○ |
| C-18 | サブフォルダ有効性チェック | E-05 113行目 | ○ |
| C-19 | サブフォルダ既存チェック（新規作成時） | E-05 117行目 | ○ |
| C-20 | スクリプト拡張子検証 | E-05 131-133行目 | ○ |
| C-21 | GDScript警告メッセージ | E-05 134-136行目 | ○ |
| C-22 | DirAccess::make_dir_recursive()呼び出し | E-06 58行目 | ○ |
| C-23 | ConfigFile::set_value()で各値設定 | E-06 65-68行目 | ○ |
| C-24 | _create_script_for_plugin()呼び出し | E-06 71行目 | ○ |
| C-25 | update_plugins()とscan()呼び出し | E-06 74-75行目 | ○ |
| C-26 | EditorPluginテンプレート取得 | E-07 93-95行目 | ○ |
| C-27 | ResourceSaver::save()でスクリプト保存 | E-07 99行目 | ○ |
| C-28 | 画面へのアクセス方法 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **画面へのアクセス方法**：PluginConfigDialogがどこから呼び出されるかの確認が必要
  - 候補：project_settings_editor.cpp / editor_plugin.cpp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード根拠が明確な技術的仕様（大多数）
- 1: 中リスク - 画面アクセス方法の記述（呼び出し元の確認が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] プロジェクト設定からの呼び出しパスを確認
- [ ] DirAccess::make_dir_recursive()のエラーハンドリングを確認
- [ ] ResourceSaver::save()のエラーハンドリングを確認
- [ ] 既存プラグインの編集時にスクリプトが上書きされないことを確認
- [ ] GDScript以外の言語でのテンプレート生成を確認
