---
generated_at: 2026-01-23 13:15:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-実行インスタンスダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/run/run_instances_dialog.cpp` 全体（422行）
- E-02: `editor/run/run_instances_dialog.h` 全体（106行）
- E-03: `editor/run/run_instances_dialog.cpp` 296-405行目 コンストラクタ
- E-04: `editor/run/run_instances_dialog.cpp` 61-79行目 _refresh_argument_count()
- E-05: `editor/run/run_instances_dialog.cpp` 81-100行目 _create_instance()
- E-06: `editor/run/run_instances_dialog.cpp` 102-107行目 _save_main_args()
- E-07: `editor/run/run_instances_dialog.cpp` 109-121行目 _save_arguments()
- E-08: `editor/run/run_instances_dialog.cpp` 210-268行目 get_argument_list_for_instance()
- E-09: `editor/run/run_instances_dialog.cpp` 270-294行目 apply_custom_features()
- E-10: `editor/run/run_instances_dialog.cpp` 159-196行目 _instance_tree_rmb()

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AcceptDialogを継承している | E-02 43-44行目 | ○ |
| C-02 | Columns列挙（4列） | E-02 46-51行目 | ○ |
| C-03 | InstanceData構造体定義 | E-02 53-60行目 | ○ |
| C-04 | singletonパターン | E-02 68行目, E-03 297行目 | ○ |
| C-05 | ダイアログサイズ1200*600*EDSCALE | E-01 199行目 | ○ |
| C-06 | Timerで0.5秒遅延保存 | E-03 301-302, 307-308行目 | ○ |
| C-07 | Main Run Argsプレースホルダー | E-03 335行目 | ○ |
| C-08 | Main Feature Tagsプレースホルダー | E-03 344行目 | ○ |
| C-09 | Enable Multiple Instancesチェック | E-03 356-359行目 | ○ |
| C-10 | instance_count SpinBox（1-20） | E-03 362-365行目 | ○ |
| C-11 | Treeは4列構成 | E-03 383行目 | ○ |
| C-12 | 列タイトルが設定される | E-03 385-390行目 | ○ |
| C-13 | 右クリック選択許可 | E-03 392行目 | ○ |
| C-14 | SCROLL_HINT_MODE_BOTTOM | E-03 393行目 | ○ |
| C-15 | PopupMenuでClear/Clear All | E-10 183, 192行目 | ○ |
| C-16 | _fetch_main_args()でProjectSettings取得 | E-01 48-49行目 | ○ |
| C-17 | ProjectSettingsに接続 | E-03 339行目 | ○ |
| C-18 | text_changed→_start_main_timer() | E-03 340行目 | ○ |
| C-19 | value_changed→_refresh_argument_count() | E-03 370行目 | ○ |
| C-20 | toggled→set_editable() | E-03 371行目 | ○ |
| C-21 | ツリークリアとルート作成 | E-04 62-63行目 | ○ |
| C-22 | stored_data拡張 | E-04 65-67行目 | ○ |
| C-23 | TreeItem CELL_MODE_CHECK設定 | E-05 85-88, 93-96行目 | ○ |
| C-24 | ProjectSettings::set_setting()呼び出し | E-06 103行目 | ○ |
| C-25 | EditorSettings::set_project_metadata()呼び出し | E-06 105-106行目 | ○ |
| C-26 | インスタンスデータDictionary保存 | E-07 112-117行目 | ○ |
| C-27 | override判定ロジック | E-08 211-223行目 | ○ |
| C-28 | %command%プレースホルダー対応 | E-08 233-259行目 | ○ |
| C-29 | _split_cmdline_args()でクォート考慮 | E-01 123-157行目 | ○ |
| C-30 | OS::set_environment()呼び出し | E-09 293行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目にコード根拠が存在

## 6) レビュアーチェックリスト（最小）
- [ ] %command%プレースホルダーの動作を確認
- [ ] 引数のクォート処理が正しいか確認
- [ ] 複数インスタンス実行時のフィーチャータグ適用順序を確認
- [ ] Timer遅延保存がキャンセル時に正しく動作するか確認
- [ ] stored_dataのサイズ縮小時の動作を確認
