---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：4-3Dエディタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **4分割ビューポートの詳細実装**：実際の分割UIの確認
  2. **環境エフェクトプレビュー**：WorldEnvironmentとの連携

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/scene/3d/node_3d_editor_plugin.cpp` 行1-300
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行5
- E-03: `docs/code-to-docs/画面遷移図.md` 行45
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行15-20

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 3Dノード編集用エディタ | E-02 | ○ |
| C-02 | F2キーでアクセス | E-03 | ○ |
| C-03 | DISTANCE_DEFAULT = 4 | E-01 行108 | ○ |
| C-04 | GIZMO_ARROW_SIZE = 0.35 | E-01 行110 | ○ |
| C-05 | GIZMO_RING_HALF_WIDTH = 0.1 | E-01 行111 | ○ |
| C-06 | GIZMO_CIRCLE_SIZE = 1.1 | E-01 行114 | ○ |
| C-07 | ZOOM_FREELOOK_MIN = 0.01 | E-01 行119 | ○ |
| C-08 | ZOOM_FREELOOK_MAX = 10000 (float) | E-01 行126 | ○ |
| C-09 | ViewportNavigationControlクラス | E-01 行135-206 | ○ |
| C-10 | NavigationMode enum | E-01 行240-286 | ○ |
| C-11 | _nav_orbit()でオービット | E-01 行266 参照 | ○ |
| C-12 | _nav_pan()でパン | E-01 行272 参照 | ○ |
| C-13 | _nav_zoom()でズーム | E-01 行277 参照 | ○ |
| C-14 | ViewportRotationControlクラス | E-01 行297以降 | ○ |
| C-15 | 3Dレンダリングが主機能 | E-04 行15 | ○ |
| C-16 | カメラシステムが主機能 | E-04 行16 | ○ |
| C-17 | ライティングが補助機能 | E-04 行17 | ○ |
| C-18 | 環境設定が補助機能 | E-04 行18 | ○ |
| C-19 | 3D物理シミュレーションが補助機能 | E-04 行19 | ○ |
| C-20 | シーンエディタが主機能 | E-04 行20 | ○ |
| C-21 | 4分割ビューポート表示 | **根拠不足** | △ |
| C-22 | 環境エフェクトプレビュー詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- 4分割ビューポートの実装詳細
  - 候補：`editor/scene/3d/node_3d_editor_plugin.cpp` 後半部分
- WorldEnvironmentとの連携プレビュー
  - 候補：`scene/3d/world_environment.cpp`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なナビゲーション操作、ギズモ操作
- 1: 中リスク - フリールックモードの挙動
- 2: 高リスク - 4分割ビューポートの有無

## 6) レビュアーチェックリスト（最小）
- [ ] ナビゲーション操作（オービット、パン、ズーム）の確認
- [ ] フリールックモードの動作確認
- [ ] ギズモ定数値の実際のサイズ確認
- [ ] 4分割ビューポートの存在確認
