---
generated_at: 2026-01-23 13:20:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-アセットインストーラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：35 / 35、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/asset_library/editor_asset_installer.cpp` 全体（778行）
- E-02: `editor/asset_library/editor_asset_installer.h` 全体（107行）
- E-03: `editor/asset_library/editor_asset_installer.cpp` 669-777行目 コンストラクタ
- E-04: `editor/asset_library/editor_asset_installer.cpp` 109-167行目 open_asset()
- E-05: `editor/asset_library/editor_asset_installer.cpp` 191-241行目 _rebuild_source_tree()
- E-06: `editor/asset_library/editor_asset_installer.cpp` 293-334行目 _rebuild_destination_tree()
- E-07: `editor/asset_library/editor_asset_installer.cpp` 273-291行目 _update_source_item_status()
- E-08: `editor/asset_library/editor_asset_installer.cpp` 65-103行目 _fix_conflicted_indeterminate_state()
- E-09: `editor/asset_library/editor_asset_installer.cpp` 505-593行目 _install_asset()
- E-10: `editor/asset_library/editor_asset_installer.cpp` 431-464行目 _check_has_toplevel()
- E-11: `editor/asset_library/editor_asset_installer.cpp` 603-667行目 _notification()

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConfirmationDialogを継承している | E-02 41-42行目 | ○ |
| C-02 | source_treeとdestination_treeの2つのツリー | E-02 45-47行目 | ○ |
| C-03 | mapped_filesでパスマッピング | E-02 59行目 | ○ |
| C-04 | file_item_mapでTreeItemマッピング | E-02 60行目 | ○ |
| C-05 | target_dir_pathデフォルトres:// | E-02 70行目 | ○ |
| C-06 | ダイアログサイズ620*640*EDSCALE | E-04 166行目 | ○ |
| C-07 | unzOpen2()でZIPオープン | E-04 116行目 | ○ |
| C-08 | ZIPエラー時EditorToaster表示 | E-04 118行目 | ○ |
| C-09 | 中間ディレクトリの追加 | E-04 134-142行目 | ○ |
| C-10 | _check_has_toplevel()でプレフィックス検出 | E-04 155行目 | ○ |
| C-11 | ルートアイテムにチェックボックス | E-05 196-200行目 | ○ |
| C-12 | _create_dir_item()/_create_file_item()呼び出し | E-05 230-233行目 | ○ |
| C-13 | チェック済みのみプレビュー追加 | E-06 303-305行目 | ○ |
| C-14 | 既存ファイルで赤色表示 | E-07 279行目 | ○ |
| C-15 | 既存ファイルでチェック解除 | E-07 281行目 | ○ |
| C-16 | ツールチップに(already exists) | E-07 280行目 | ○ |
| C-17 | 競合時の不確定状態修正 | E-08 90-96行目 | ○ |
| C-18 | propagate_check()呼び出し | E-01 57行目 | ○ |
| C-19 | _update_confirm_button()でOKボタン制御 | E-01 405-408行目 | ○ |
| C-20 | ProgressDialog使用 | E-09 518行目 | ○ |
| C-21 | make_dir_recursive()呼び出し | E-09 548行目 | ○ |
| C-22 | unzReadCurrentFile()でデータ読み込み | E-09 554行目 | ○ |
| C-23 | FileAccess::store_buffer()で保存 | E-09 562行目 | ○ |
| C-24 | failed_filesに失敗ファイル追加 | E-09 564行目 | ○ |
| C-25 | 成功メッセージ表示 | E-09 588行目 | ○ |
| C-26 | EditorFileSystem::scan_changes()呼び出し | E-09 592行目 | ○ |
| C-27 | skip_toplevel_checkの有効/無効制御 | E-10 436-438, 462-463行目 | ○ |
| C-28 | 拡張子ごとのアイコンマップ | E-11 616-664行目 | ○ |
| C-29 | C#サポートなしでImportFailアイコン | E-11 646行目 | ○ |
| C-30 | show_source_files_buttonトグル | E-03 692-696行目 | ○ |
| C-31 | Change Install Folderボタン | E-03 698-702行目 | ○ |
| C-32 | 競合リンクのerror_color | E-11 611行目 | ○ |
| C-33 | set_hide_on_ok(true) | E-03 776行目 | ○ |
| C-34 | タイトル「Configure Asset Before Installing」 | E-03 774行目 | ○ |
| C-35 | OKボタンテキスト「Install」 | E-03 775行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目にコード根拠が存在

## 6) レビュアーチェックリスト（最小）
- [ ] 大きなZIPファイルのパフォーマンスを確認
- [ ] ファイル書き込み権限エラー時の動作を確認
- [ ] 深いディレクトリ構造でのパス処理を確認
- [ ] 文字エンコーディング（UTF-8以外）のファイル名処理を確認
- [ ] 既存ファイル上書き防止が確実に機能するか確認
- [ ] ProgressDialogのキャンセル処理を確認
