---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 48
  claims_with_evidence: 46
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート: 41-ロケールダイアログ

## サマリー

本レポートは「41-ロケールダイアログ」画面設計書の記載内容について、ソースコードに基づく根拠を提示する。全48件の記載事項のうち46件（95.8%）がソースコードから直接確認でき、高い信頼性を有する。未確認の2件は外部システム連携に関する一般的な記述であり、設計書の品質に大きな影響を与えない。

## Evidence一覧

| Evidence ID | ファイル | 行番号 | 内容 |
|-------------|----------|--------|------|
| E-001 | editor_locale_dialog.h | L42-43 | クラス定義: EditorLocaleDialog : ConfirmationDialog |
| E-002 | editor_locale_dialog.h | L45-48 | LocaleFilter enum定義 (SHOW_ALL_LOCALES, SHOW_ONLY_SELECTED_LOCALES) |
| E-003 | editor_locale_dialog.h | L50-61 | メンバ変数定義 (hb_locale, filter_mode, edit_filters, etc.) |
| E-004 | editor_locale_dialog.cpp | L404 | ダイアログタイトル: set_title(TTRC("Select a Locale")) |
| E-005 | editor_locale_dialog.cpp | L410-417 | filter_mode OptionButton作成とアイテム追加 |
| E-006 | editor_locale_dialog.cpp | L412 | "Show All Locales"オプション |
| E-007 | editor_locale_dialog.cpp | L414 | "Show Selected Locales Only"オプション |
| E-008 | editor_locale_dialog.cpp | L420-425 | edit_filters CheckButton作成、"Edit Filters"テキスト |
| E-009 | editor_locale_dialog.cpp | L428-433 | advanced CheckButton作成、"Advanced"テキスト |
| E-010 | editor_locale_dialog.cpp | L444-446 | "Language:"ラベル作成 |
| E-011 | editor_locale_dialog.cpp | L449-456 | lang_list Tree作成、シグナル接続 |
| E-012 | editor_locale_dialog.cpp | L464-466 | script_label1作成（スクリプトラベル） |
| E-013 | editor_locale_dialog.cpp | L469-475 | script_list Tree作成 |
| E-014 | editor_locale_dialog.cpp | L483-485 | "Country:"ラベル作成 |
| E-015 | editor_locale_dialog.cpp | L488-495 | cnt_list Tree作成 |
| E-016 | editor_locale_dialog.cpp | L509-511 | "Language"ラベル（入力エリア） |
| E-017 | editor_locale_dialog.cpp | L514-517 | lang_code LineEdit作成、max_length=3 |
| E-018 | editor_locale_dialog.cpp | L525-527 | script_label2作成 |
| E-019 | editor_locale_dialog.cpp | L530-533 | script_code LineEdit作成、max_length=4 |
| E-020 | editor_locale_dialog.cpp | L540-541 | "Country"ラベル（入力エリア） |
| E-021 | editor_locale_dialog.cpp | L545-548 | country_code LineEdit作成、max_length=2 |
| E-022 | editor_locale_dialog.cpp | L556-558 | "Variant"ラベル作成 |
| E-023 | editor_locale_dialog.cpp | L561-565 | variant_code LineEdit作成 |
| E-024 | editor_locale_dialog.cpp | L575 | OKボタンテキスト: set_ok_button_text(TTRC("Select")) |
| E-025 | editor_locale_dialog.cpp | L58-81 | ok_pressed()メソッド実装 |
| E-026 | editor_locale_dialog.cpp | L59-61 | フィルタ編集モード時のreturn処理 |
| E-027 | editor_locale_dialog.cpp | L63-67 | 言語コード必須チェック |
| E-028 | editor_locale_dialog.cpp | L69-77 | ロケール文字列連結処理 |
| E-029 | editor_locale_dialog.cpp | L79 | TranslationServer::standardize_locale()呼び出し |
| E-030 | editor_locale_dialog.cpp | L54-56 | locale_selectedシグナル定義 |
| E-031 | editor_locale_dialog.cpp | L83-106 | _item_selected()メソッド実装 |
| E-032 | editor_locale_dialog.cpp | L108-114 | _toggle_advanced()メソッド実装 |
| E-033 | editor_locale_dialog.cpp | L129-161 | _filter_lang_option_changed()メソッド実装 |
| E-034 | editor_locale_dialog.cpp | L156-160 | EditorUndoRedoManager使用 |
| E-035 | editor_locale_dialog.cpp | L157-159 | ProjectSettings書き込み（language_filter） |
| E-036 | editor_locale_dialog.cpp | L163-195 | _filter_script_option_changed()メソッド実装 |
| E-037 | editor_locale_dialog.cpp | L197-229 | _filter_cnt_option_changed()メソッド実装 |
| E-038 | editor_locale_dialog.cpp | L231-246 | _filter_mode_changed()メソッド実装 |
| E-039 | editor_locale_dialog.cpp | L240-243 | locale_filter_mode ProjectSettings書き込み |
| E-040 | editor_locale_dialog.cpp | L252-358 | _update_tree()メソッド実装 |
| E-041 | editor_locale_dialog.cpp | L276-279 | フィルタ編集モード時のUI制御 |
| E-042 | editor_locale_dialog.cpp | L286-301 | 言語リスト構築ループ |
| E-043 | editor_locale_dialog.cpp | L308-312 | "[Default]"オプション追加 |
| E-044 | editor_locale_dialog.cpp | L314-329 | スクリプトリスト構築ループ |
| E-045 | editor_locale_dialog.cpp | L342-357 | 国リスト構築ループ |
| E-046 | editor_locale_dialog.cpp | L399-401 | popup_locale_dialog()実装、サイズ1050x700 |
| E-047 | editor_locale_dialog.cpp | L361-397 | set_locale()メソッド実装 |
| E-048 | editor_locale_dialog.h | L66-67 | locale_set, updating_lists フラグ定義 |

## Claims と根拠の対応

### 概要セクション

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| EditorLocaleDialogはConfirmationDialogを継承 | E-001 | 確認済 |
| ロケール選択用モーダルダイアログである | E-001, E-004 | 確認済 |
| 言語・スクリプト・国/地域を選択可能 | E-003, E-011, E-013, E-015 | 確認済 |
| フィルタ機能によりロケールを絞り込み可能 | E-002, E-005 | 確認済 |

### 画面種別・基本情報

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| 選択ダイアログ（Modal Dialog） | E-001 | 確認済 |
| ダイアログサイズ1050x700 | E-046 | 確認済 |

### 入出力項目

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| 言語コードは最大3文字 | E-017 | 確認済 |
| スクリプトコードは最大4文字 | E-019 | 確認済 |
| 国コードは最大2文字 | E-021 | 確認済 |
| バリアントコードはLineEdit | E-023 | 確認済 |
| 出力はlocale_selectedシグナルで返却 | E-030 | 確認済 |

### 表示項目

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| filter_mode OptionButtonの存在 | E-005 | 確認済 |
| "Show All Locales"オプション | E-006 | 確認済 |
| "Show Selected Locales Only"オプション | E-007 | 確認済 |
| edit_filters CheckButtonの存在 | E-008 | 確認済 |
| advanced CheckButtonの存在 | E-009 | 確認済 |
| lang_list Treeの存在 | E-011 | 確認済 |
| script_list Treeの存在 | E-013 | 確認済 |
| cnt_list Treeの存在 | E-015 | 確認済 |

### イベント仕様

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| 言語選択時にlang_codeが更新される | E-031 | 確認済 |
| スクリプト選択時にscript_codeが更新される | E-031 | 確認済 |
| 国選択時にcountry_codeが更新される | E-031 | 確認済 |
| Selectボタン押下でロケール文字列構築 | E-025, E-028 | 確認済 |
| 言語コード必須チェック | E-027 | 確認済 |
| TranslationServer.standardize_locale()での標準化 | E-029 | 確認済 |
| locale_selectedシグナル発行 | E-030, E-025 | 確認済 |
| フィルタモード変更がUndo/Redo対応 | E-034, E-038 | 確認済 |
| 言語フィルタ変更がProjectSettings保存 | E-035 | 確認済 |
| Advancedモード切替時のコードクリア | E-032 | 確認済 |

### データベース更新仕様

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| locale_filter_mode設定の更新 | E-039 | 確認済 |
| language_filter設定の更新 | E-035 | 確認済 |
| script_filter設定の更新 | E-036 | 確認済 |
| country_filter設定の更新 | E-037 | 確認済 |

### メッセージ仕様

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| タイトル"Select a Locale" | E-004 | 確認済 |
| Selectボタンラベル | E-024 | 確認済 |
| "Language:"ラベル | E-010 | 確認済 |
| "Script:"ラベル | E-012 | 確認済 |
| "Country:"ラベル | E-014 | 確認済 |
| "[Default]"オプション | E-043 | 確認済 |

### 例外処理

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| 言語コード空時の処理中断 | E-027 | 確認済 |
| フィルタ編集モード中のSelect処理中断 | E-026 | 確認済 |

### コードリーディングガイド

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| コンストラクタでUI構築（L403-576） | E-004〜E-024 | 確認済 |
| popup_locale_dialog()で表示（L399-401） | E-046 | 確認済 |
| _update_tree()でリスト構築（L252-358） | E-040〜E-045 | 確認済 |
| ok_pressed()でロケール構築（L58-81） | E-025〜E-030 | 確認済 |

## 不足情報

| 項目 | 説明 | 影響度 |
|------|------|--------|
| TranslationServerの実装詳細 | ロケールデータの具体的なソース（ISO規格準拠の確認） | 低 |
| 呼び出し元画面の特定 | 本ダイアログを呼び出す具体的な画面・機能の網羅的リスト | 低 |

## リスクフラグ

| リスク | 該当箇所 | 対応推奨 |
|--------|----------|----------|
| なし | - | - |

本画面設計書はソースコードに密接に基づいており、重大なリスクは検出されなかった。

## レビュアーチェックリスト

- [x] 全ての主要UI要素がソースコードから確認できる
- [x] イベント処理の流れがメソッド実装と一致している
- [x] ProjectSettings更新処理が正確に記載されている
- [x] Undo/Redo対応の記載がある
- [x] 入力バリデーション（文字数制限）が正確
- [x] シグナル定義と発行箇所が一致している
- [x] コードリーディングガイドの行番号が正確
- [ ] TranslationServerとの連携詳細（外部依存）
- [ ] 呼び出し元画面の網羅的確認
