---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 52
  claims_with_evidence: 49
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート: 42-ビジュアルシェーダーエディタ

## サマリー

本レポートは「42-ビジュアルシェーダーエディタ」画面設計書の記載内容について、ソースコードに基づく根拠を提示する。全52件の記載事項のうち49件（94.2%）がソースコードから直接確認でき、高い信頼性を有する。未確認の3件は外部システム連携や詳細な内部実装に関する記述であり、設計書の品質に大きな影響を与えない。

## Evidence一覧

| Evidence ID | ファイル | 行番号 | 内容 |
|-------------|----------|--------|------|
| E-001 | visual_shader_editor_plugin.h | L197-198 | クラス定義: VisualShaderEditor : ShaderEditor |
| E-002 | visual_shader_editor_plugin.h | L219 | GraphEdit* graph メンバ |
| E-003 | visual_shader_editor_plugin.h | L220 | Button* add_node メンバ |
| E-004 | visual_shader_editor_plugin.h | L221 | MenuButton* varying_button メンバ |
| E-005 | visual_shader_editor_plugin.h | L222 | Button* code_preview_button メンバ |
| E-006 | visual_shader_editor_plugin.h | L223 | Button* shader_preview_button メンバ |
| E-007 | visual_shader_editor_plugin.h | L230-234 | edit_type OptionButton（複数タイプ対応） |
| E-008 | visual_shader_editor_plugin.h | L263 | MenuButton* tools メンバ |
| E-009 | visual_shader_editor_plugin.h | L285-288 | param_filter, parameters, parameter_props |
| E-010 | visual_shader_editor_plugin.h | L369-373 | members Tree, node_filter, node_desc |
| E-011 | visual_shader_editor_plugin.h | L99-181 | VisualShaderGraphPlugin クラス定義 |
| E-012 | visual_shader_editor_plugin.h | L114-126 | Link構造体（preview_visible, input_ports等） |
| E-013 | visual_shader_editor_plugin.h | L71-77 | VSGraphNode クラス定義 |
| E-014 | visual_shader_editor_plugin.h | L79-97 | VSRerouteNode クラス定義 |
| E-015 | visual_shader_editor_plugin.cpp | L78-93 | float_constant_defs（E, Epsilon, Phi等） |
| E-016 | visual_shader_editor_plugin.cpp | L4233-4280 | _connection_request() 接続処理 |
| E-017 | visual_shader_editor_plugin.cpp | L4282-4304 | _disconnection_request() 切断処理 |
| E-018 | visual_shader_editor_plugin.cpp | L4188-4231 | _node_dragged(), _nodes_dragged() |
| E-019 | visual_shader_editor_plugin.cpp | L4462-4559 | _delete_nodes() ノード削除処理 |
| E-020 | visual_shader_editor_plugin.cpp | L4076-4109 | _add_varying() Varying追加 |
| E-021 | visual_shader_editor_plugin.cpp | L4111-4174 | _remove_varying() Varying削除 |
| E-022 | visual_shader_editor_plugin.cpp | L6344-6362 | _show_preview_text() |
| E-023 | visual_shader_editor_plugin.cpp | L6374-6442 | _update_preview() コードプレビュー更新 |
| E-024 | visual_shader_editor_plugin.cpp | L4594-4790 | _convert_constants_to_parameters() |
| E-025 | visual_shader_editor_plugin.cpp | L4422-4460 | _handle_node_drop_on_connection() |
| E-026 | visual_shader_editor_plugin.cpp | L6514-6600 | コンストラクタ（UI構築） |
| E-027 | visual_shader_editor_plugin.cpp | L6527-6536 | GraphEdit作成とシグナル接続 |
| E-028 | visual_shader_editor_plugin.cpp | L6552-6565 | GraphEditシグナル接続（connection_request等） |
| E-029 | visual_shader_editor_plugin.cpp | L606-788 | VisualShaderGraphPlugin::add_node() |
| E-030 | visual_shader_editor_plugin.cpp | L622-648 | ポートタイプ・カテゴリカラー設定 |
| E-031 | visual_shader_editor_plugin.cpp | L677-710 | ノードタイプ別描画処理 |
| E-032 | visual_shader_editor_plugin.h | L337-356 | NodeMenuOptions enum |
| E-033 | visual_shader_editor_plugin.h | L358-362 | ConnectionMenuOptions enum |
| E-034 | visual_shader_editor_plugin.h | L327-330 | ToolsMenuOptions enum (EXPAND_ALL, COLLAPSE_ALL) |
| E-035 | visual_shader_editor_plugin.cpp | L6015-6018 | _varying_create() |
| E-036 | visual_shader_editor_plugin.cpp | L6020-6051 | _varying_validate() バリデーション |
| E-037 | visual_shader_editor_plugin.cpp | L6082-6116 | _tools_menu_option() |
| E-038 | visual_shader_editor_plugin.cpp | L6118-6165 | _node_menu_id_pressed() |
| E-039 | visual_shader_editor_plugin.cpp | L6167-6215 | _connection_menu_id_pressed() |
| E-040 | visual_shader_editor_plugin.cpp | L4202-4205 | Undo/Redoアクション名 "Move VisualShader Node(s)" |
| E-041 | visual_shader_editor_plugin.cpp | L4245 | Undo/Redoアクション名 "Nodes Connected" |
| E-042 | visual_shader_editor_plugin.cpp | L4296 | Undo/Redoアクション名 "Nodes Disconnected" |
| E-043 | visual_shader_editor_plugin.cpp | L6026-6029 | エラーメッセージ "Invalid name for varying" |
| E-044 | visual_shader_editor_plugin.cpp | L6028-6030 | エラーメッセージ "Varying with that name already exists" |
| E-045 | visual_shader_editor_plugin.cpp | L6033-6038 | Boolean型Varying制限警告 |
| E-046 | visual_shader_editor_plugin.cpp | L769 | フレームヒントメッセージ |
| E-047 | visual_shader_editor_plugin.h | L209 | MaterialEditor* material_editor |
| E-048 | visual_shader_editor_plugin.cpp | L4599-4602 | 定数→パラメータ変換アクション名 |
| E-049 | visual_shader_editor_plugin.cpp | L160-174 | VSRerouteNodeコンストラクタ |

## Claims と根拠の対応

### 概要セクション

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| VisualShaderEditorはShaderEditorを継承 | E-001 | 確認済 |
| ノードベースのグラフエディタ | E-002, E-027 | 確認済 |
| GraphEditを使用 | E-002, E-026-028 | 確認済 |

### 表示項目

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| add_node Buttonの存在 | E-003 | 確認済 |
| edit_type OptionButtonの存在 | E-007 | 確認済 |
| varying_button MenuButtonの存在 | E-004 | 確認済 |
| code_preview_button Buttonの存在 | E-005 | 確認済 |
| shader_preview_button Buttonの存在 | E-006 | 確認済 |
| tools MenuButtonの存在 | E-008 | 確認済 |
| param_filter LineEditの存在 | E-009 | 確認済 |
| parameters Treeの存在 | E-009 | 確認済 |
| node_filter LineEditの存在 | E-010 | 確認済 |
| members Treeの存在 | E-010 | 確認済 |
| node_desc RichTextLabelの存在 | E-010 | 確認済 |
| material_editor MaterialEditorの存在 | E-047 | 確認済 |

### イベント仕様

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| _connection_request()で接続処理 | E-016 | 確認済 |
| _disconnection_request()で切断処理 | E-017 | 確認済 |
| _node_dragged()/_nodes_dragged()でドラッグ処理 | E-018 | 確認済 |
| _delete_nodes()で削除処理 | E-019 | 確認済 |
| _add_varying()でVarying追加 | E-020 | 確認済 |
| _show_preview_text()でプレビュー表示 | E-022 | 確認済 |
| _update_preview()でコード更新 | E-023 | 確認済 |
| _convert_constants_to_parameters()で変換処理 | E-024 | 確認済 |
| _handle_node_drop_on_connection()で接続上ドロップ | E-025 | 確認済 |

### グラフプラグイン

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| VisualShaderGraphPluginクラスの存在 | E-011 | 確認済 |
| Link構造体でノード状態管理 | E-012 | 確認済 |
| VSGraphNodeクラスの存在 | E-013 | 確認済 |
| VSRerouteNodeクラスの存在 | E-014 | 確認済 |
| add_node()でノード描画 | E-029 | 確認済 |
| カテゴリ別カラー設定 | E-030 | 確認済 |

### メニューオプション

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| NodeMenuOptions enum | E-032 | 確認済 |
| ConnectionMenuOptions enum | E-033 | 確認済 |
| ToolsMenuOptions (EXPAND_ALL, COLLAPSE_ALL) | E-034 | 確認済 |

### メッセージ仕様

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| "Move VisualShader Node(s)" アクション名 | E-040 | 確認済 |
| "Nodes Connected" アクション名 | E-041 | 確認済 |
| "Nodes Disconnected" アクション名 | E-042 | 確認済 |
| "Invalid name for varying" エラー | E-043 | 確認済 |
| "Varying with that name already exists" エラー | E-044 | 確認済 |
| Boolean型Varying警告 | E-045 | 確認済 |
| フレームヒントメッセージ | E-046 | 確認済 |
| 定数→パラメータ変換アクション名 | E-048 | 確認済 |

### Float定数

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| E, Epsilon, Phi, Pi/4, Pi/2, Pi, Tau, Sqrt2 定数 | E-015 | 確認済 |

### コンストラクタ・初期化

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| コンストラクタでUI構築 | E-026 | 確認済 |
| GraphEditシグナル接続 | E-028 | 確認済 |

## 不足情報

| 項目 | 説明 | 影響度 |
|------|------|--------|
| 全ノードタイプの詳細 | 利用可能な全ノードタイプの網羅的リスト | 低 |
| エディタプラグイン登録 | ShaderEditorPluginとの連携詳細 | 低 |
| キーボードショートカット | 全操作のキーボードショートカット一覧 | 低 |

## リスクフラグ

| リスク | 該当箇所 | 対応推奨 |
|--------|----------|----------|
| ソースコードが8000行超 | visual_shader_editor_plugin.cpp | 部分的な読解推奨 |

ソースファイルが非常に大きいため、全行の詳細確認は行っていないが、主要機能については確認済み。

## レビュアーチェックリスト

- [x] 主要UI要素がソースコードから確認できる
- [x] イベント処理の流れがメソッド実装と一致している
- [x] Undo/Redoアクション名が正確
- [x] エラーメッセージが正確
- [x] グラフプラグインの役割が記載されている
- [x] ノードタイプ（VSGraphNode, VSRerouteNode）が確認できる
- [x] Float定数の定義が確認できる
- [ ] 全ノードタイプの詳細確認（visual_shader_nodes.cppは未読）
- [ ] 全キーボードショートカットの確認
