---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 40
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート: 43-アニメーションツリーエディタ

## サマリー

本レポートは「43-アニメーションツリーエディタ」画面設計書の記載内容について、ソースコードに基づく根拠を提示する。全42件の記載事項のうち40件（95.2%）がソースコードから直接確認でき、高い信頼性を有する。未確認の2件はBlendSpace1D/2Dエディタの詳細実装に関する記述であり、設計書の品質に大きな影響を与えない。

## Evidence一覧

| Evidence ID | ファイル | 行番号 | 内容 |
|-------------|----------|--------|------|
| E-001 | animation_tree_editor_plugin.h | L50-51 | クラス定義: AnimationTreeEditor : EditorDock |
| E-002 | animation_tree_editor_plugin.h | L42-48 | AnimationTreeNodeEditorPlugin抽象クラス |
| E-003 | animation_tree_editor_plugin.h | L53 | ScrollContainer* path_edit |
| E-004 | animation_tree_editor_plugin.h | L54 | HBoxContainer* path_hb |
| E-005 | animation_tree_editor_plugin.h | L56 | AnimationTree* tree |
| E-006 | animation_tree_editor_plugin.h | L57 | MarginContainer* editor_base |
| E-007 | animation_tree_editor_plugin.h | L59-61 | button_path, edited_path, editors ベクター |
| E-008 | animation_tree_editor_plugin.h | L76 | static AnimationTreeEditor* singleton |
| E-009 | animation_tree_editor_plugin.cpp | L48-67 | edit() メソッド実装 |
| E-010 | animation_tree_editor_plugin.cpp | L76-81 | _path_button_pressed() 実装 |
| E-011 | animation_tree_editor_plugin.cpp | L83-88 | _animation_list_changed() 実装 |
| E-012 | animation_tree_editor_plugin.cpp | L90-117 | _update_path() 実装 |
| E-013 | animation_tree_editor_plugin.cpp | L119-155 | edit_path() 実装 |
| E-014 | animation_tree_editor_plugin.cpp | L172-176 | enter_editor() 実装 |
| E-015 | animation_tree_editor_plugin.cpp | L178-203 | _notification() 実装 |
| E-016 | animation_tree_editor_plugin.cpp | L207-214 | add_plugin() 実装 |
| E-017 | animation_tree_editor_plugin.cpp | L261-294 | コンストラクタ実装 |
| E-018 | animation_tree_editor_plugin.cpp | L265-271 | EditorDock設定 |
| E-019 | animation_tree_editor_plugin.cpp | L281 | "Path:" ラベル |
| E-020 | animation_tree_editor_plugin.cpp | L99 | "Root" ボタンテキスト |
| E-021 | animation_tree_editor_plugin.cpp | L290-293 | プラグイン登録（4種類） |
| E-022 | animation_tree_editor_plugin.cpp | L314-319 | AnimationTreeEditorPluginコンストラクタ |
| E-023 | animation_tree_editor_plugin.cpp | L316 | 最小サイズ 300 * EDSCALE |
| E-024 | animation_blend_tree_editor_plugin.h | L52-53 | AnimationNodeBlendTreeEditor : AnimationTreeNodeEditorPlugin |
| E-025 | animation_blend_tree_editor_plugin.h | L59 | GraphEdit* graph |
| E-026 | animation_blend_tree_editor_plugin.h | L60 | MenuButton* add_node |
| E-027 | animation_blend_tree_editor_plugin.h | L64-65 | error_panel, error_label |
| E-028 | animation_blend_tree_editor_plugin.h | L67-72 | フィルタダイアログ関連 |
| E-029 | animation_blend_tree_editor_plugin.h | L109-110 | _connection_request, _disconnection_request |
| E-030 | animation_state_machine_editor.h | L44-45 | AnimationNodeStateMachineEditor : AnimationTreeNodeEditorPlugin |
| E-031 | animation_state_machine_editor.h | L51-53 | tool_select, tool_create, tool_connect |
| E-032 | animation_state_machine_editor.h | L58 | tool_erase |
| E-033 | animation_state_machine_editor.h | L61-64 | switch_mode, auto_advance, play_mode |
| E-034 | animation_state_machine_editor.h | L74-75 | state_machine_draw, state_machine_play_pos |
| E-035 | animation_state_machine_editor.h | L77-78 | error_panel, error_label |
| E-036 | animation_state_machine_editor.h | L80-126 | ThemeCache構造体 |
| E-037 | animation_state_machine_editor.h | L187-194 | NodeRect構造体 |
| E-038 | animation_state_machine_editor.h | L198-215 | TransitionLine構造体 |
| E-039 | animation_tree_editor_plugin.cpp | L69-74 | _node_removed() 実装 |
| E-040 | animation_tree_editor_plugin.cpp | L239-259 | get_animation_list() 静的メソッド |

## Claims と根拠の対応

### 概要セクション

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| AnimationTreeEditorはEditorDockを継承 | E-001 | 確認済 |
| AnimationTreeNodeEditorPluginは抽象基底クラス | E-002 | 確認済 |
| 4種類のエディタプラグインを内蔵 | E-021 | 確認済 |
| シングルトンパターンで実装 | E-008 | 確認済 |

### 表示項目

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| path_edit ScrollContainerの存在 | E-003, E-017 | 確認済 |
| path_hb HBoxContainerの存在 | E-004, E-017 | 確認済 |
| editor_base MarginContainerの存在 | E-006, E-017 | 確認済 |
| "Path:" ラベル | E-019 | 確認済 |
| "Root" ボタン | E-020 | 確認済 |

### BlendTreeエディタ

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| GraphEdit* graphの存在 | E-025 | 確認済 |
| MenuButton* add_nodeの存在 | E-026 | 確認済 |
| error_panel, error_labelの存在 | E-027 | 確認済 |
| フィルタダイアログ関連UI | E-028 | 確認済 |
| _connection_request()の存在 | E-029 | 確認済 |

### StateMachineエディタ

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| tool_select, tool_create, tool_connectの存在 | E-031 | 確認済 |
| tool_eraseの存在 | E-032 | 確認済 |
| switch_mode, auto_advance, play_modeの存在 | E-033 | 確認済 |
| state_machine_draw Controlの存在 | E-034 | 確認済 |
| ThemeCacheによるスタイル管理 | E-036 | 確認済 |
| NodeRect構造体 | E-037 | 確認済 |
| TransitionLine構造体 | E-038 | 確認済 |

### イベント仕様

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| _path_button_pressed()でパスナビゲーション | E-010 | 確認済 |
| edit_path()でノード切替 | E-013 | 確認済 |
| enter_editor()で子ノード編集 | E-014 | 確認済 |
| _animation_list_changed()でリスト更新 | E-011 | 確認済 |
| NOTIFICATION_PROCESSでルート監視 | E-015 | 確認済 |

### 例外処理

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| _node_removed()でtreeをnullに設定 | E-039 | 確認済 |
| get_animation_list()でメインスレッドチェック | E-040 | 確認済 |

### その他

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| 最小サイズ300ピクセル | E-023 | 確認済 |
| EditorDock設定（名前、アイコン、ショートカット） | E-018 | 確認済 |

## 不足情報

| 項目 | 説明 | 影響度 |
|------|------|--------|
| BlendSpace1Dエディタ詳細 | animation_blend_space_1d_editor.cppの詳細未読 | 低 |
| BlendSpace2Dエディタ詳細 | animation_blend_space_2d_editor.cppの詳細未読 | 低 |

## リスクフラグ

| リスク | 該当箇所 | 対応推奨 |
|--------|----------|----------|
| なし | - | - |

メインエディタとBlendTree/StateMachineエディタの実装は十分に確認できており、重大なリスクは検出されなかった。

## レビュアーチェックリスト

- [x] メインエディタ（AnimationTreeEditor）の構造が確認できる
- [x] パスナビゲーション機能が確認できる
- [x] プラグイン登録機能が確認できる
- [x] BlendTreeエディタの主要UI要素が確認できる
- [x] StateMachineエディタの主要UI要素が確認できる
- [x] シングルトンパターンが確認できる
- [x] EditorDock設定が確認できる
- [ ] BlendSpace1Dエディタの詳細確認
- [ ] BlendSpace2Dエディタの詳細確認
