---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート: 44-タイルマップエディタ

## サマリー

本レポートは「44-タイルマップエディタ」画面設計書の記載内容について、ソースコードに基づく根拠を提示する。全45件の記載事項のうち42件（93.3%）がソースコードから直接確認でき、高い信頼性を有する。未確認の3件はTileMapLayerEditorおよびTileSetEditorの詳細実装に関する記述であり、別ファイルに実装されている。

## Evidence一覧

| Evidence ID | ファイル | 行番号 | 内容 |
|-------------|----------|--------|------|
| E-001 | tiles_editor_plugin.h | L38-41 | TilesEditorUtils シングルトン定義 |
| E-002 | tiles_editor_plugin.h | L44-50 | SourceSortOption enum |
| E-003 | tiles_editor_plugin.h | L54-56 | atlas_sources_lists_current, atlas_view_zoom, atlas_view_scroll |
| E-004 | tiles_editor_plugin.h | L67-72 | QueueItem構造体（パターンプレビュー） |
| E-005 | tiles_editor_plugin.h | L72-78 | パターンプレビュースレッド関連メンバ |
| E-006 | tiles_editor_plugin.h | L88-99 | 同期API定義 |
| E-007 | tiles_editor_plugin.h | L110-119 | TileSetSourceItemList クラス |
| E-008 | tiles_editor_plugin.h | L121-154 | TileMapEditorPlugin クラス |
| E-009 | tiles_editor_plugin.h | L124 | TileMapLayerEditor* editor |
| E-010 | tiles_editor_plugin.h | L156-173 | TileSetEditorPlugin クラス |
| E-011 | tiles_editor_plugin.h | L159 | TileSetEditor* editor |
| E-012 | tiles_editor_plugin.cpp | L53-55 | シングルトンとプラグインシングルトン |
| E-013 | tiles_editor_plugin.cpp | L71-143 | _thread() パターンプレビュー生成 |
| E-014 | tiles_editor_plugin.cpp | L145-153 | queue_pattern_preview() 実装 |
| E-015 | tiles_editor_plugin.cpp | L155-185 | ソースリスト同期API実装 |
| E-016 | tiles_editor_plugin.cpp | L201-231 | set_sorting_option(), get_sorted_sources() |
| E-017 | tiles_editor_plugin.cpp | L235-280 | SourceNameComparator 実装 |
| E-018 | tiles_editor_plugin.cpp | L297-314 | TilesEditorUtilsコンストラクタ（ショートカット登録） |
| E-019 | tiles_editor_plugin.cpp | L302-313 | ショートカット定義（D,L,R,B,E,P等） |
| E-020 | tiles_editor_plugin.cpp | L316-327 | デストラクタ（スレッド終了処理） |
| E-021 | tiles_editor_plugin.cpp | L329-341 | TileSetSourceItemList::get_tooltip() |
| E-022 | tiles_editor_plugin.cpp | L343-353 | TileSetSourceItemListコンストラクタ（アイコンサイズ60x60） |
| E-023 | tiles_editor_plugin.cpp | L355-361 | _tile_map_layer_changed() |
| E-024 | tiles_editor_plugin.cpp | L371-386 | _update_tile_map() |
| E-025 | tiles_editor_plugin.cpp | L388-397 | _select_layer() |
| E-026 | tiles_editor_plugin.cpp | L399-420 | _edit_tile_map_layer() |
| E-027 | tiles_editor_plugin.cpp | L422-432 | _edit_tile_map() |
| E-028 | tiles_editor_plugin.cpp | L440-463 | edit() 実装 |
| E-029 | tiles_editor_plugin.cpp | L465-479 | handles() 実装 |
| E-030 | tiles_editor_plugin.cpp | L481-488 | make_visible() 実装 |
| E-031 | tiles_editor_plugin.cpp | L490-491 | forward_canvas_gui_input() |
| E-032 | tiles_editor_plugin.cpp | L494-496 | forward_canvas_draw_over_viewport() |
| E-033 | tiles_editor_plugin.cpp | L502-516 | TileMapEditorPluginコンストラクタ |
| E-034 | tiles_editor_plugin.cpp | L511 | 最小サイズ 200 * EDSCALE |
| E-035 | tiles_editor_plugin.cpp | L522-529 | TileSetEditorPlugin::edit() |
| E-036 | tiles_editor_plugin.cpp | L531-533 | TileSetEditorPlugin::handles() |
| E-037 | tiles_editor_plugin.cpp | L535-541 | TileSetEditorPlugin::make_visible() |
| E-038 | tiles_editor_plugin.cpp | L551-565 | TileSetEditorPluginコンストラクタ |

## Claims と根拠の対応

### 概要セクション

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| TilesEditorUtilsはシングルトン | E-001, E-012 | 確認済 |
| TileMapEditorPluginとTileSetEditorPluginの2つのプラグイン | E-008, E-010 | 確認済 |
| パターンプレビューはバックグラウンドスレッド生成 | E-004-005, E-013 | 確認済 |

### 表示項目

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| TileMapLayerEditor* editorの存在 | E-009 | 確認済 |
| TileSetEditor* editorの存在 | E-011 | 確認済 |
| TileSetSourceItemListの存在 | E-007 | 確認済 |

### イベント仕様

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| _tile_map_layer_changed()でレイヤー変更検知 | E-023 | 確認済 |
| _update_tile_map()で更新処理 | E-024 | 確認済 |
| _select_layer()でレイヤー切替 | E-025 | 確認済 |
| _edit_tile_map_layer()で編集開始 | E-026 | 確認済 |
| forward_canvas_gui_input()で入力転送 | E-031 | 確認済 |

### ソート機能

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| SourceSortOption enum（4種類） | E-002 | 確認済 |
| set_sorting_option()の存在 | E-016 | 確認済 |
| get_sorted_sources()の存在 | E-016 | 確認済 |
| SourceNameComparator実装 | E-017 | 確認済 |

### ショートカット

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| "Paint Tool" - D キー | E-019 | 確認済 |
| "Line Tool" - L キー | E-019 | 確認済 |
| "Rect Tool" - R キー | E-019 | 確認済 |
| "Bucket Tool" - B キー | E-019 | 確認済 |
| "Eraser Tool" - E キー | E-019 | 確認済 |
| "Picker Tool" - P キー | E-019 | 確認済 |
| Cut/Copy/Paste/Cancel/Delete | E-018 | 確認済 |

### パターンプレビュー

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| queue_pattern_preview() API | E-014 | 確認済 |
| _thread()でSubViewport使用 | E-013 | 確認済 |
| スレッド終了処理 | E-020 | 確認済 |

### ツールチップ

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| "Source ID: %d" | E-021 | 確認済 |
| "Source ID: %d\nTexture path: %s" | E-021 | 確認済 |

### その他

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| アイコンサイズ60x60 | E-022 | 確認済 |
| 最小サイズ200ピクセル | E-034 | 確認済 |
| EditorDockManagerへの登録 | E-033, E-038 | 確認済 |

## 不足情報

| 項目 | 説明 | 影響度 |
|------|------|--------|
| TileMapLayerEditorの詳細 | tile_map_layer_editor.cppの詳細未読 | 中 |
| TileSetEditorの詳細 | tile_set_editor.cppの詳細未読 | 中 |
| TileAtlasViewの詳細 | tile_atlas_view.cppの詳細未読 | 低 |

## リスクフラグ

| リスク | 該当箇所 | 対応推奨 |
|--------|----------|----------|
| 詳細エディタ実装未確認 | TileMapLayerEditor, TileSetEditor | 別途確認推奨 |

主要なプラグイン構造とユーティリティクラスは確認できているが、詳細なUI実装は別ファイルにある。

## レビュアーチェックリスト

- [x] プラグイン構造（TileMapEditorPlugin, TileSetEditorPlugin）が確認できる
- [x] TilesEditorUtilsのシングルトン実装が確認できる
- [x] パターンプレビューのスレッド処理が確認できる
- [x] ソートオプションと実装が確認できる
- [x] ショートカット定義が確認できる
- [x] ツールチップテキストが確認できる
- [x] キャンバス入力転送が確認できる
- [ ] TileMapLayerEditorの詳細UI確認
- [ ] TileSetEditorの詳細UI確認
