---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 58
  claims_with_evidence: 56
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート: 45-スプライトフレームエディタ

## サマリー

本レポートは「45-スプライトフレームエディタ」画面設計書の記載内容について、ソースコードに基づく根拠を提示する。全58件の記載事項のうち56件（96.6%）がソースコードから直接確認でき、高い信頼性を有する。未確認の2件はSpriteFramesリソース本体の詳細実装に関する記述であり、設計書の品質に大きな影響を与えない。

## Evidence一覧

| Evidence ID | ファイル | 行番号 | 内容 |
|-------------|----------|--------|------|
| E-001 | sprite_frames_editor_plugin.h | L72-73 | SpriteFramesEditor : EditorDock クラス定義 |
| E-002 | sprite_frames_editor_plugin.h | L315-316 | SpriteFramesEditorPlugin : EditorPlugin クラス定義 |
| E-003 | sprite_frames_editor_plugin.h | L49-57 | ClipboardSpriteFrames クラス定義 |
| E-004 | sprite_frames_editor_plugin.h | L60-70 | ClipboardAnimation クラス定義 |
| E-005 | sprite_frames_editor_plugin.h | L78-82 | PARAM_USE_CURRENT, PARAM_FRAME_COUNT, PARAM_SIZE 定義 |
| E-006 | sprite_frames_editor_plugin.h | L85-99 | FRAME_ORDER_* 定義（フレーム順序オプション） |
| E-007 | sprite_frames_editor_plugin.h | L114-119 | 再生コントロールボタン（stop, play, play_from等） |
| E-008 | sprite_frames_editor_plugin.h | L121-133 | フレーム操作ボタン（load, copy, paste等） |
| E-009 | sprite_frames_editor_plugin.h | L134 | ItemList* frame_list |
| E-010 | sprite_frames_editor_plugin.h | L138-148 | アニメーション操作ボタン（add_anim, delete_anim等） |
| E-011 | sprite_frames_editor_plugin.h | L150-151 | anim_search_box, animations Tree |
| E-012 | sprite_frames_editor_plugin.h | L166-184 | スプライトシート分割ダイアログ関連メンバ |
| E-013 | sprite_frames_editor_plugin.cpp | L2121-2128 | コンストラクタ：EditorDock設定（名前、アイコン、ショートカット） |
| E-014 | sprite_frames_editor_plugin.cpp | L2130-2139 | HSplitContainer, VBoxContainer（レイアウト構築） |
| E-015 | sprite_frames_editor_plugin.cpp | L2144-2180 | アニメーション操作ボタン作成 |
| E-016 | sprite_frames_editor_plugin.cpp | L2182-2211 | autoplay, anim_loop, anim_speed 作成 |
| E-017 | sprite_frames_editor_plugin.cpp | L2213-2229 | anim_search_box, animations Tree 作成 |
| E-018 | sprite_frames_editor_plugin.cpp | L2231-2242 | アニメーション操作ショートカット設定 |
| E-019 | sprite_frames_editor_plugin.cpp | L2244-2252 | missing_anim_label 作成 |
| E-020 | sprite_frames_editor_plugin.cpp | L2265-2297 | 再生コントロール作成 |
| E-021 | sprite_frames_editor_plugin.cpp | L2299-2351 | フレーム操作ボタン作成 |
| E-022 | sprite_frames_editor_plugin.cpp | L2355-2372 | frame_duration SpinBox 作成 |
| E-023 | sprite_frames_editor_plugin.cpp | L2383-2399 | ズームボタン作成 |
| E-024 | sprite_frames_editor_plugin.cpp | L2405-2420 | frame_list ItemList 作成 |
| E-025 | sprite_frames_editor_plugin.cpp | L2435-2464 | 再生・フレーム操作ショートカット設定 |
| E-026 | sprite_frames_editor_plugin.cpp | L2476-2509 | スプライトシート分割ダイアログ作成 |
| E-027 | sprite_frames_editor_plugin.cpp | L2537-2551 | split_sheet_preview, split_sheet_scroll 作成 |
| E-028 | sprite_frames_editor_plugin.cpp | L2562-2588 | シートズームボタン作成 |
| E-029 | sprite_frames_editor_plugin.cpp | L2590-2721 | シート設定パネル（分割数、サイズ等）作成 |
| E-030 | sprite_frames_editor_plugin.cpp | L2733-2743 | ズーム設定値（scale_ratio, max_zoom等） |
| E-031 | sprite_frames_editor_plugin.cpp | L1094-1110 | _animation_selected() 実装 |
| E-032 | sprite_frames_editor_plugin.cpp | L1163-1214 | _animation_name_edited() 実装 |
| E-033 | sprite_frames_editor_plugin.cpp | L1249-1268 | _animation_add() 実装 |
| E-034 | sprite_frames_editor_plugin.cpp | L1270-1291 | _animation_duplicate() 実装 |
| E-035 | sprite_frames_editor_plugin.cpp | L1293-1304 | _animation_cut() 実装 |
| E-036 | sprite_frames_editor_plugin.cpp | L1306-1313 | _animation_copy() 実装 |
| E-037 | sprite_frames_editor_plugin.cpp | L1315-1342 | _animation_paste() 実装 |
| E-038 | sprite_frames_editor_plugin.cpp | L1344-1359 | _animation_remove() 実装 |
| E-039 | sprite_frames_editor_plugin.cpp | L1365-1377 | _animation_loop_changed() 実装 |
| E-040 | sprite_frames_editor_plugin.cpp | L1383-1399 | _animation_speed_changed() 実装 |
| E-041 | sprite_frames_editor_plugin.cpp | L770-811 | _file_load_request() 実装 |
| E-042 | sprite_frames_editor_plugin.cpp | L844-858 | _paste_pressed() 実装 |
| E-043 | sprite_frames_editor_plugin.cpp | L903-927 | _copy_pressed() 実装 |
| E-044 | sprite_frames_editor_plugin.cpp | L929-952 | _empty_pressed() 実装 |
| E-045 | sprite_frames_editor_plugin.cpp | L979-1023 | _up_pressed() 実装 |
| E-046 | sprite_frames_editor_plugin.cpp | L1071-1092 | _delete_pressed() 実装 |
| E-047 | sprite_frames_editor_plugin.cpp | L1539-1566 | _frame_duration_changed() 実装 |
| E-048 | sprite_frames_editor_plugin.cpp | L2039-2078 | _play_pressed(), _stop_pressed() 等 |
| E-049 | sprite_frames_editor_plugin.cpp | L63-72 | _open_sprite_sheet() 実装 |
| E-050 | sprite_frames_editor_plugin.cpp | L635-685 | _prepare_sprite_sheet() 実装 |
| E-051 | sprite_frames_editor_plugin.cpp | L555-579 | _auto_slice_sprite_sheet() 実装 |
| E-052 | sprite_frames_editor_plugin.cpp | L177-255 | _sheet_preview_input() 実装 |
| E-053 | sprite_frames_editor_plugin.cpp | L284-313 | _sheet_add_frames() 実装 |
| E-054 | sprite_frames_editor_plugin.cpp | L1819-1850 | get_drag_data_fw() 実装 |
| E-055 | sprite_frames_editor_plugin.cpp | L1852-1897 | can_drop_data_fw() 実装 |
| E-056 | sprite_frames_editor_plugin.cpp | L1899-1967 | drop_data_fw() 実装 |
| E-057 | sprite_frames_editor_plugin.cpp | L687-768 | _notification() 実装（テーマ適用） |
| E-058 | sprite_frames_editor_plugin.cpp | L2791-2796 | SpriteFramesEditorPlugin コンストラクタ |

## Claims と根拠の対応

### 基本情報

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| SpriteFramesEditorはEditorDockを継承 | E-001 | 確認済 |
| SpriteFramesEditorPluginはEditorPluginを継承 | E-002 | 確認済 |
| ClipboardSpriteFrames構造体の存在 | E-003 | 確認済 |
| ClipboardAnimation構造体の存在 | E-004 | 確認済 |

### UI要素（アニメーションパネル）

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| add_anim Buttonの存在 | E-010, E-015 | 確認済 |
| duplicate_anim Buttonの存在 | E-010, E-015 | 確認済 |
| cut_anim Buttonの存在 | E-010, E-015 | 確認済 |
| copy_anim Buttonの存在 | E-010, E-015 | 確認済 |
| paste_anim Buttonの存在 | E-010, E-015 | 確認済 |
| delete_anim Buttonの存在 | E-010, E-015 | 確認済 |
| autoplay Buttonの存在 | E-010, E-016 | 確認済 |
| anim_loop Buttonの存在 | E-010, E-016 | 確認済 |
| anim_speed SpinBoxの存在 | E-010, E-016 | 確認済 |
| anim_search_box LineEditの存在 | E-011, E-017 | 確認済 |
| animations Treeの存在 | E-011, E-017 | 確認済 |

### UI要素（フレームパネル）

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| stop, play, play_from等のButtonの存在 | E-007, E-020 | 確認済 |
| load, load_sheet Buttonの存在 | E-008, E-021 | 確認済 |
| copy, paste Buttonの存在 | E-008, E-021 | 確認済 |
| empty_before, empty_after Buttonの存在 | E-008, E-021 | 確認済 |
| move_up, move_down Buttonの存在 | E-008, E-021 | 確認済 |
| delete_frame Buttonの存在 | E-008, E-021 | 確認済 |
| frame_duration SpinBoxの存在 | E-008, E-022 | 確認済 |
| zoom_out, zoom_reset, zoom_in Buttonの存在 | E-008, E-023 | 確認済 |
| frame_list ItemListの存在 | E-009, E-024 | 確認済 |

### スプライトシート分割ダイアログ

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| split_sheet_dialog ConfirmationDialogの存在 | E-012, E-026 | 確認済 |
| split_sheet_preview TextureRectの存在 | E-012, E-027 | 確認済 |
| split_sheet_h, split_sheet_v SpinBoxの存在 | E-012, E-029 | 確認済 |
| split_sheet_size_x/y SpinBoxの存在 | E-012, E-029 | 確認済 |
| split_sheet_sep_x/y SpinBoxの存在 | E-012, E-029 | 確認済 |
| split_sheet_offset_x/y SpinBoxの存在 | E-012, E-029 | 確認済 |
| split_sheet_order OptionButtonの存在 | E-012, E-026 | 確認済 |
| シートズームボタンの存在 | E-012, E-028 | 確認済 |

### フレーム順序オプション

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| FRAME_ORDER_SELECTION | E-006 | 確認済 |
| FRAME_ORDER_LEFT_RIGHT_TOP_BOTTOM | E-006 | 確認済 |
| FRAME_ORDER_LEFT_RIGHT_BOTTOM_TOP | E-006 | 確認済 |
| FRAME_ORDER_RIGHT_LEFT_TOP_BOTTOM | E-006 | 確認済 |
| FRAME_ORDER_RIGHT_LEFT_BOTTOM_TOP | E-006 | 確認済 |
| FRAME_ORDER_TOP_BOTTOM_LEFT_RIGHT | E-006 | 確認済 |
| FRAME_ORDER_TOP_BOTTOM_RIGHT_LEFT | E-006 | 確認済 |
| FRAME_ORDER_BOTTOM_TOP_LEFT_RIGHT | E-006 | 確認済 |
| FRAME_ORDER_BOTTOM_TOP_RIGHT_LEFT | E-006 | 確認済 |

### イベント処理

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| _animation_selected()の実装 | E-031 | 確認済 |
| _animation_name_edited()の実装 | E-032 | 確認済 |
| _animation_add()の実装 | E-033 | 確認済 |
| _animation_duplicate()の実装 | E-034 | 確認済 |
| _animation_cut()の実装 | E-035 | 確認済 |
| _animation_copy()の実装 | E-036 | 確認済 |
| _animation_paste()の実装 | E-037 | 確認済 |
| _animation_remove()の実装 | E-038 | 確認済 |
| _animation_loop_changed()の実装 | E-039 | 確認済 |
| _animation_speed_changed()の実装 | E-040 | 確認済 |
| _file_load_request()の実装 | E-041 | 確認済 |
| _copy_pressed()/_paste_pressed()の実装 | E-042, E-043 | 確認済 |
| _empty_pressed()の実装 | E-044 | 確認済 |
| _up_pressed()/_down_pressed()の実装 | E-045 | 確認済 |
| _delete_pressed()の実装 | E-046 | 確認済 |
| _frame_duration_changed()の実装 | E-047 | 確認済 |
| 再生操作の実装 | E-048 | 確認済 |
| _open_sprite_sheet()の実装 | E-049 | 確認済 |
| _prepare_sprite_sheet()の実装 | E-050 | 確認済 |
| _auto_slice_sprite_sheet()の実装 | E-051 | 確認済 |
| _sheet_preview_input()の実装 | E-052 | 確認済 |
| _sheet_add_frames()の実装 | E-053 | 確認済 |

### ドラッグ&ドロップ

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| get_drag_data_fw()の実装 | E-054 | 確認済 |
| can_drop_data_fw()の実装 | E-055 | 確認済 |
| drop_data_fw()の実装 | E-056 | 確認済 |

### キーボードショートカット

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| アニメーション操作ショートカット（Ctrl+N等） | E-018 | 確認済 |
| フレーム操作ショートカット（Ctrl+O等） | E-025 | 確認済 |
| 再生ショートカット（A, D, S等） | E-025 | 確認済 |

### ズーム設定

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| scale_ratio = 1.2f | E-030 | 確認済 |
| thumbnail_default_size = 96 * EDSCALE | E-030 | 確認済 |
| max_sheet_zoom = 128.0f * EDSCALE | E-030 | 確認済 |
| min_sheet_zoom = 0.01f * EDSCALE | E-030 | 確認済 |

### EditorDock設定

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| set_name("SpriteFrames") | E-013 | 確認済 |
| set_icon_name("SpriteFrames") | E-013 | 確認済 |
| set_dock_shortcut() | E-013 | 確認済 |
| set_default_slot(DOCK_SLOT_BOTTOM) | E-013 | 確認済 |

### プラグイン

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| 最小サイズ 300 * EDSCALE | E-058 | 確認済 |
| EditorDockManager登録 | E-058 | 確認済 |

## 不足情報

| 項目 | 説明 | 影響度 |
|------|------|--------|
| SpriteFramesリソース実装詳細 | scene/resources/sprite_frames.cppの詳細未読 | 低 |
| AnimatedSprite2D/3D詳細 | 再生関連の詳細実装未確認 | 低 |

## リスクフラグ

| リスク | 該当箇所 | 対応推奨 |
|--------|----------|----------|
| なし | - | - |

ソースコードは約2800行と規模が大きいが、エディタ本体の実装は十分に確認できており、主要機能についてはすべて検証済みである。

## レビュアーチェックリスト

- [x] アニメーションパネルのUI要素が確認できる
- [x] フレームパネルのUI要素が確認できる
- [x] スプライトシート分割ダイアログの構成が確認できる
- [x] アニメーション操作イベントが確認できる
- [x] フレーム操作イベントが確認できる
- [x] 再生操作イベントが確認できる
- [x] ドラッグ&ドロップ処理が確認できる
- [x] キーボードショートカットが確認できる
- [x] ズーム設定値が確認できる
- [x] EditorDock設定が確認できる
- [ ] SpriteFramesリソース側の実装確認
- [ ] AnimatedSprite2D/3D連携の詳細確認
