---
generated_at: 2026-01-23 12:30:00
metrics:
  claims_total: 48
  claims_with_evidence: 48
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 46-カーブエディタ

## サマリー

本レポートは「46-カーブエディタ」画面設計書の記載内容について、ソースコードに基づく根拠を提示する。全48件の記載事項のすべて（100%）がソースコードから直接確認でき、非常に高い信頼性を有する。ソースコードは約1100行と比較的コンパクトで、全行を確認済み。

## Evidence一覧

| Evidence ID | ファイル | 行番号 | 内容 |
|-------------|----------|--------|------|
| E-001 | curve_editor_plugin.h | L42-43 | CurveEdit : Control クラス定義 |
| E-002 | curve_editor_plugin.h | L149-150 | CurveEditor : VBoxContainer クラス定義 |
| E-003 | curve_editor_plugin.h | L175-176 | EditorInspectorPluginCurve クラス定義 |
| E-004 | curve_editor_plugin.h | L183-184 | CurveEditorPlugin : EditorPlugin クラス定義 |
| E-005 | curve_editor_plugin.h | L192-193 | CurvePreviewGenerator クラス定義 |
| E-006 | curve_editor_plugin.h | L57-64 | PresetID enum定義 |
| E-007 | curve_editor_plugin.h | L66-70 | TangentIndex enum定義 |
| E-008 | curve_editor_plugin.h | L133-137 | GrabMode enum定義 |
| E-009 | curve_editor_plugin.h | L107-109 | ASPECT_RATIO, LINE_WIDTH, STEP_SIZE定数 |
| E-010 | curve_editor_plugin.h | L121-125 | BASE_POINT_RADIUS等の定数 |
| E-011 | curve_editor_plugin.h | L113 | Ref<Curve> curve メンバ |
| E-012 | curve_editor_plugin.h | L115-118 | selected_index, hovered_index等 |
| E-013 | curve_editor_plugin.h | L156-159 | snap_button, snap_count_edit, presets_button, curve_editor_rect |
| E-014 | curve_editor_plugin.cpp | L994-1033 | CurveEditorコンストラクタ |
| E-015 | curve_editor_plugin.cpp | L998-1002 | snap_button作成とシグナル接続 |
| E-016 | curve_editor_plugin.cpp | L1006-1013 | snap_count_edit作成とシグナル接続 |
| E-017 | curve_editor_plugin.cpp | L1015-1020 | presets_button作成とシグナル接続 |
| E-018 | curve_editor_plugin.cpp | L967-991 | _notification (THEME_CHANGED, READY, RESIZED) |
| E-019 | curve_editor_plugin.cpp | L971 | SnapGridアイコン設定 |
| E-020 | curve_editor_plugin.cpp | L974-978 | プリセットアイコン設定 |
| E-021 | curve_editor_plugin.cpp | L363-416 | use_preset() プリセット適用 |
| E-022 | curve_editor_plugin.cpp | L376-381 | PRESET_CONSTANT実装 |
| E-023 | curve_editor_plugin.cpp | L383-388 | PRESET_LINEAR実装 |
| E-024 | curve_editor_plugin.cpp | L390-393 | PRESET_EASE_IN実装 |
| E-025 | curve_editor_plugin.cpp | L395-398 | PRESET_EASE_OUT実装 |
| E-026 | curve_editor_plugin.cpp | L400-403 | PRESET_SMOOTHSTEP実装 |
| E-027 | curve_editor_plugin.cpp | L150-361 | gui_input() マウス/キーボード処理 |
| E-028 | curve_editor_plugin.cpp | L159-174 | Deleteキー処理 |
| E-029 | curve_editor_plugin.cpp | L217-253 | 左クリック処理（選択/追加） |
| E-030 | curve_editor_plugin.cpp | L185-213 | 右/中クリック処理（削除/リニア切替） |
| E-031 | curve_editor_plugin.cpp | L256-278 | 左ボタン解放処理（編集確定） |
| E-032 | curve_editor_plugin.cpp | L281-360 | マウス移動処理（ドラッグ） |
| E-033 | curve_editor_plugin.cpp | L297-304 | Shift押下時の軸制約 |
| E-034 | curve_editor_plugin.cpp | L307-311 | Alt押下時の隣接ポイント制約 |
| E-035 | curve_editor_plugin.cpp | L240-243 | Ctrl/Cmd+スナップ切替 |
| E-036 | curve_editor_plugin.cpp | L506-520 | add_point() Undo/Redo |
| E-037 | curve_editor_plugin.cpp | L522-544 | remove_point() Undo/Redo |
| E-038 | curve_editor_plugin.cpp | L546-567 | set_point_position() Undo/Redo |
| E-039 | curve_editor_plugin.cpp | L569-592 | set_point_tangents() Undo/Redo |
| E-040 | curve_editor_plugin.cpp | L594-610 | set_point_left_tangent() Undo/Redo |
| E-041 | curve_editor_plugin.cpp | L612-628 | set_point_right_tangent() Undo/Redo |
| E-042 | curve_editor_plugin.cpp | L630-657 | toggle_linear() Undo/Redo |
| E-043 | curve_editor_plugin.cpp | L775-944 | _redraw() 描画処理 |
| E-044 | curve_editor_plugin.cpp | L908-927 | ヘルプテキスト描画 |
| E-045 | curve_editor_plugin.cpp | L86-108 | set_snap_enabled(), set_snap_count() |
| E-046 | curve_editor_plugin.cpp | L666-690 | update_view_transform() |
| E-047 | curve_editor_plugin.cpp | L724-730 | get_view_pos(), get_world_pos() |
| E-048 | curve_editor_plugin.cpp | L1061-1098 | CurvePreviewGenerator実装 |

## Claims と根拠の対応

### 基本情報

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| CurveEditはControlを継承 | E-001 | 確認済 |
| CurveEditorはVBoxContainerを継承 | E-002 | 確認済 |
| EditorInspectorPluginCurveクラスの存在 | E-003 | 確認済 |
| CurveEditorPluginはEditorPluginを継承 | E-004 | 確認済 |
| CurvePreviewGeneratorクラスの存在 | E-005 | 確認済 |

### Enum定義

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| PresetID enum（5種類） | E-006 | 確認済 |
| TangentIndex enum（NONE, LEFT, RIGHT） | E-007 | 確認済 |
| GrabMode enum（NONE, ADD, MOVE） | E-008 | 確認済 |

### 描画パラメータ

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| ASPECT_RATIO = 6.0/13.0 | E-009 | 確認済 |
| LINE_WIDTH = 0.5 | E-009 | 確認済 |
| STEP_SIZE = 2 | E-009 | 確認済 |
| BASE_POINT_RADIUS = 4 | E-010 | 確認済 |
| BASE_HOVER_RADIUS = 10 | E-010 | 確認済 |
| BASE_TANGENT_RADIUS = 3 | E-010 | 確認済 |
| BASE_TANGENT_HOVER_RADIUS = 8 | E-010 | 確認済 |
| BASE_TANGENT_LENGTH = 36 | E-010 | 確認済 |

### UI要素

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| snap_button Buttonの存在 | E-013, E-015 | 確認済 |
| snap_count_edit EditorSpinSliderの存在 | E-013, E-016 | 確認済 |
| presets_button MenuButtonの存在 | E-013, E-017 | 確認済 |
| curve_editor_rect CurveEditの存在 | E-013, E-014 | 確認済 |

### プリセット

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| PRESET_CONSTANT実装 | E-022 | 確認済 |
| PRESET_LINEAR実装 | E-023 | 確認済 |
| PRESET_EASE_IN実装 | E-024 | 確認済 |
| PRESET_EASE_OUT実装 | E-025 | 確認済 |
| PRESET_SMOOTHSTEP実装 | E-026 | 確認済 |

### 入力処理

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| 左クリックでポイント選択/追加 | E-029 | 確認済 |
| 右クリックでポイント削除 | E-030 | 確認済 |
| Deleteキーで削除/リニア切替 | E-028 | 確認済 |
| Shiftで軸制約 | E-033 | 確認済 |
| Altで隣接ポイント制約 | E-034 | 確認済 |
| Ctrl/Cmdでスナップ切替 | E-035 | 確認済 |
| マウスドラッグで移動 | E-032 | 確認済 |

### Undo/Redo

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| "Load Curve Preset"アクション | E-021 | 確認済 |
| "Add Curve Point"アクション | E-036 | 確認済 |
| "Remove Curve Point"アクション | E-037 | 確認済 |
| "Modify Curve Point"アクション | E-038 | 確認済 |
| "Modify Curve Point's Tangents"アクション | E-039 | 確認済 |
| "Modify Curve Point's Left Tangent"アクション | E-040 | 確認済 |
| "Modify Curve Point's Right Tangent"アクション | E-041 | 確認済 |
| "Toggle Linear Curve Point's Tangent"アクション | E-042 | 確認済 |

### 描画処理

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| _redraw()メソッド実装 | E-043 | 確認済 |
| ヘルプテキスト描画 | E-044 | 確認済 |

### スナップ設定

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| set_snap_enabled()実装 | E-045 | 確認済 |
| set_snap_count()実装 | E-045 | 確認済 |
| メタデータへの保存 | E-045 | 確認済 |

### 座標変換

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| update_view_transform()実装 | E-046 | 確認済 |
| get_view_pos()実装 | E-047 | 確認済 |
| get_world_pos()実装 | E-047 | 確認済 |

### プレビュー生成

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| handles()で"Curve"タイプ判定 | E-048 | 確認済 |
| generate()でサムネイル生成 | E-048 | 確認済 |

### アイコン

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| SnapGridアイコン | E-019 | 確認済 |
| CurveConstant, CurveLinear等アイコン | E-020 | 確認済 |

## 不足情報

| 項目 | 説明 | 影響度 |
|------|------|--------|
| なし | - | - |

すべての記載事項がソースコードから確認できました。

## リスクフラグ

| リスク | 該当箇所 | 対応推奨 |
|--------|----------|----------|
| なし | - | - |

ソースコードは約1100行とコンパクトで、全体を確認済み。すべての機能が正確に文書化されています。

## レビュアーチェックリスト

- [x] クラス継承関係が確認できる
- [x] UI要素（ツールバー、カーブ編集領域）が確認できる
- [x] プリセット定義が確認できる
- [x] タンジェントタイプが確認できる
- [x] グラブモードが確認できる
- [x] マウス操作処理が確認できる
- [x] キーボード操作処理が確認できる
- [x] Undo/Redoアクションが確認できる
- [x] 描画処理が確認できる
- [x] スナップ設定が確認できる
- [x] 座標変換処理が確認できる
- [x] プレビュー生成処理が確認できる
- [x] アイコン設定が確認できる
