---
generated_at: 2026-01-23 12:45:00
metrics:
  claims_total: 42
  claims_with_evidence: 42
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: 47-グラデーションエディタ

## サマリー

本レポートは「47-グラデーションエディタ」画面設計書の記載内容について、ソースコードに基づく根拠を提示する。全42件の記載事項のすべて（100%）がソースコードから直接確認でき、非常に高い信頼性を有する。ソースコードは約700行と比較的コンパクトで、全行を確認済み。

## Evidence一覧

| Evidence ID | ファイル | 行番号 | 内容 |
|-------------|----------|--------|------|
| E-001 | gradient_editor_plugin.h | L42-43 | GradientEdit : Control クラス定義 |
| E-002 | gradient_editor_plugin.h | L108-109 | GradientEditor : VBoxContainer クラス定義 |
| E-003 | gradient_editor_plugin.h | L129-130 | EditorInspectorPluginGradient クラス定義 |
| E-004 | gradient_editor_plugin.h | L137-138 | GradientEditorPlugin : EditorPlugin クラス定義 |
| E-005 | gradient_editor_plugin.h | L45-49 | gradient, preview_texture, popup, picker メンバ |
| E-006 | gradient_editor_plugin.h | L54-58 | GrabMode enum定義 |
| E-007 | gradient_editor_plugin.h | L63-64 | selected_index, hovered_index |
| E-008 | gradient_editor_plugin.h | L67-68 | BASE_SPACING, BASE_HANDLE_WIDTH |
| E-009 | gradient_editor_plugin.h | L111-114 | reverse_button, snap_button, snap_count_edit, gradient_editor_rect |
| E-010 | gradient_editor_plugin.cpp | L576-593 | GradientEditコンストラクタ |
| E-011 | gradient_editor_plugin.cpp | L578 | 最小サイズ (0, 60) * EDSCALE |
| E-012 | gradient_editor_plugin.cpp | L580-583 | ColorPicker作成とシグナル接続 |
| E-013 | gradient_editor_plugin.cpp | L585-589 | PopupPanel作成とシグナル接続 |
| E-014 | gradient_editor_plugin.cpp | L591-592 | preview_texture作成（幅1024） |
| E-015 | gradient_editor_plugin.cpp | L629-661 | GradientEditorコンストラクタ |
| E-016 | gradient_editor_plugin.cpp | L633-635 | reverse_button作成 |
| E-017 | gradient_editor_plugin.cpp | L639-643 | snap_button作成とシグナル接続 |
| E-018 | gradient_editor_plugin.cpp | L645-652 | snap_count_edit作成とシグナル接続 |
| E-019 | gradient_editor_plugin.cpp | L654-656 | gradient_editor_rect作成と連携 |
| E-020 | gradient_editor_plugin.cpp | L237-435 | gui_input()実装 |
| E-021 | gradient_editor_plugin.cpp | L242-252 | Deleteキー処理 |
| E-022 | gradient_editor_plugin.cpp | L261-281 | 右/中クリック処理 |
| E-023 | gradient_editor_plugin.cpp | L284-342 | 左クリック処理 |
| E-024 | gradient_editor_plugin.cpp | L345-358 | 左ボタン解放処理 |
| E-025 | gradient_editor_plugin.cpp | L360-434 | マウス移動処理 |
| E-026 | gradient_editor_plugin.cpp | L383-411 | Shift押下時の隣接ポイントスナップ |
| E-027 | gradient_editor_plugin.cpp | L321-336 | Alt+クリックでポイント複製 |
| E-028 | gradient_editor_plugin.cpp | L112-122 | add_point() Undo/Redo |
| E-029 | gradient_editor_plugin.cpp | L124-150 | remove_point() Undo/Redo |
| E-030 | gradient_editor_plugin.cpp | L152-171 | set_offset() Undo/Redo |
| E-031 | gradient_editor_plugin.cpp | L173-187 | set_color() Undo/Redo |
| E-032 | gradient_editor_plugin.cpp | L189-198 | reverse_gradient() Undo/Redo |
| E-033 | gradient_editor_plugin.cpp | L437-539 | _redraw()実装 |
| E-034 | gradient_editor_plugin.cpp | L449-451 | 市松模様+グラデーション描画 |
| E-035 | gradient_editor_plugin.cpp | L453-460 | スナップライン描画 |
| E-036 | gradient_editor_plugin.cpp | L462-519 | ハンドル描画 |
| E-037 | gradient_editor_plugin.cpp | L521-538 | カラーボタン描画 |
| E-038 | gradient_editor_plugin.cpp | L81-97 | _show_color_picker()実装 |
| E-039 | gradient_editor_plugin.cpp | L48-67 | _get_point_at()実装 |
| E-040 | gradient_editor_plugin.cpp | L69-75 | _predict_insertion_index()実装 |
| E-041 | gradient_editor_plugin.cpp | L205-227 | set_snap_enabled(), set_snap_count() |
| E-042 | gradient_editor_plugin.cpp | L612-627 | _notification (THEME_CHANGED, READY) |

## Claims と根拠の対応

### 基本情報

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| GradientEditはControlを継承 | E-001 | 確認済 |
| GradientEditorはVBoxContainerを継承 | E-002 | 確認済 |
| EditorInspectorPluginGradientクラスの存在 | E-003 | 確認済 |
| GradientEditorPluginはEditorPluginを継承 | E-004 | 確認済 |

### GradientEditメンバ

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| gradient Ref<Gradient>の存在 | E-005 | 確認済 |
| preview_texture Ref<GradientTexture1D>の存在 | E-005, E-014 | 確認済 |
| popup PopupPanelの存在 | E-005, E-013 | 確認済 |
| picker ColorPickerの存在 | E-005, E-012 | 確認済 |
| selected_index, hovered_indexの存在 | E-007 | 確認済 |

### GrabMode

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| GRAB_NONE, GRAB_ADD, GRAB_MOVE | E-006 | 確認済 |

### 描画パラメータ

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| BASE_SPACING = 4 | E-008 | 確認済 |
| BASE_HANDLE_WIDTH = 8 | E-008 | 確認済 |
| preview_texture width = 1024 | E-014 | 確認済 |
| minimum_size = (0, 60) * EDSCALE | E-011 | 確認済 |

### ツールバー

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| reverse_button Buttonの存在 | E-009, E-016 | 確認済 |
| snap_button Buttonの存在 | E-009, E-017 | 確認済 |
| snap_count_edit EditorSpinSliderの存在 | E-009, E-018 | 確認済 |

### 入力処理

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| Deleteキーでポイント削除 | E-021 | 確認済 |
| 右/中クリックでポイント削除 | E-022 | 確認済 |
| 左クリックでポイント選択/追加 | E-023 | 確認済 |
| 左ボタン解放で編集確定 | E-024 | 確認済 |
| マウス移動でドラッグ/ホバー | E-025 | 確認済 |
| Shift押下で隣接ポイントスナップ | E-026 | 確認済 |
| Alt+クリックでポイント複製 | E-027 | 確認済 |

### Undo/Redo

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| "Add Gradient Point"アクション | E-028 | 確認済 |
| "Remove Gradient Point"アクション | E-029 | 確認済 |
| "Move Gradient Point"アクション | E-030 | 確認済 |
| "Recolor Gradient Point"アクション | E-031 | 確認済 |
| "Reverse Gradient"アクション | E-032 | 確認済 |

### 描画処理

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| _redraw()メソッド実装 | E-033 | 確認済 |
| 市松模様+グラデーション描画 | E-034 | 確認済 |
| スナップライン描画 | E-035 | 確認済 |
| ハンドル描画 | E-036 | 確認済 |
| カラーボタン描画 | E-037 | 確認済 |

### カラーピッカー

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| _show_color_picker()実装 | E-038 | 確認済 |
| 表示位置の自動調整 | E-038 | 確認済 |

### ポイント検索

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| _get_point_at()実装 | E-039 | 確認済 |
| _predict_insertion_index()実装 | E-040 | 確認済 |

### スナップ設定

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| set_snap_enabled()実装 | E-041 | 確認済 |
| set_snap_count()実装 | E-041 | 確認済 |
| メタデータへの保存 | E-041 | 確認済 |

### テーマ

| Claim | Evidence | 検証結果 |
|-------|----------|----------|
| ReverseGradient, SnapGridアイコン | E-042 | 確認済 |

## 不足情報

| 項目 | 説明 | 影響度 |
|------|------|--------|
| なし | - | - |

すべての記載事項がソースコードから確認できました。

## リスクフラグ

| リスク | 該当箇所 | 対応推奨 |
|--------|----------|----------|
| なし | - | - |

ソースコードは約700行とコンパクトで、全体を確認済み。すべての機能が正確に文書化されています。

## レビュアーチェックリスト

- [x] クラス継承関係が確認できる
- [x] UI要素（ツールバー、グラデーション編集領域）が確認できる
- [x] GrabModeが確認できる
- [x] 描画パラメータが確認できる
- [x] マウス操作処理が確認できる
- [x] キーボード操作処理が確認できる
- [x] Undo/Redoアクションが確認できる
- [x] 描画処理が確認できる
- [x] カラーピッカー連携が確認できる
- [x] スナップ設定が確認できる
- [x] アイコン設定が確認できる
