---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：5-スクリプトエディタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **外部エディタ連携の詳細**：設定方法と連携フロー
  2. **ブレークポイント永続化**：保存先と形式

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/script/script_editor_plugin.cpp` 行1-300
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行6
- E-03: `docs/code-to-docs/画面遷移図.md` 行46
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行21-24

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GDScript/C#編集画面 | E-02 | ○ |
| C-02 | F3キーでアクセス | E-03 | ○ |
| C-03 | EditorSyntaxHighlighter基底クラス | E-01 行81-113 | ○ |
| C-04 | EditorStandardSyntaxHighlighter実装 | E-01 行116-230 | ○ |
| C-05 | EditorJSONSyntaxHighlighter実装 | E-01 行248-265 | ○ |
| C-06 | EditorMarkdownSyntaxHighlighter実装 | E-01 行269-300 | ○ |
| C-07 | キーワードカラー設定機能 | E-01 行122-181 | ○ |
| C-08 | ユーザー型カラー設定 | E-01 行136-141 | ○ |
| C-09 | オートロードのハイライト | E-01 行144-150 | ○ |
| C-10 | コメントカラー設定 | E-01 行207-212 | ○ |
| C-11 | 文字列カラー設定 | E-01 行223-228 | ○ |
| C-12 | GDScriptが主機能 | E-04 行21 | ○ |
| C-13 | C#サポートが主機能 | E-04 行22 | ○ |
| C-14 | スクリプトエディタが主機能 | E-04 行23 | ○ |
| C-15 | シグナルシステムが補助機能 | E-04 行24 | ○ |
| C-16 | 複数タブ管理 | E-01 include文 | ○ |
| C-17 | FindInFiles連携 | E-01 行63 include | ○ |
| C-18 | EditorHelp連携 | E-01 行45 include | ○ |
| C-19 | 外部エディタ連携の詳細 | **根拠不足** | △ |
| C-20 | ブレークポイント永続化形式 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- 外部エディタ連携の設定と呼び出しフロー
  - 候補：`editor/settings/editor_settings.cpp` / 外部エディタ設定
- ブレークポイントの永続化先と形式
  - 候補：`editor/debugger/` / `editor_layout.cfg`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンタックスハイライト、基本的な編集操作
- 1: 中リスク - コード補完、定義ジャンプ
- 2: 高リスク - 外部エディタ連携

## 6) レビュアーチェックリスト（最小）
- [ ] 各シンタックスハイライターの動作確認
- [ ] コード補完の候補生成確認
- [ ] ブレークポイント設定・永続化確認
- [ ] Find in Filesの動作確認
