---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：51-パス3Dエディタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **3Dナビゲーション機能との連携**：画面機能マッピングには記載あるが、コード上での直接的な連携実装は限定的
  2. **ツールチップ文言の完全性**：一部のツールチップ文言はコードから抽出したが、ローカライズ後の最終表示は未確認
  3. **エディター設定項目の網羅性**：path3d_tilt_disk_size以外の関連設定項目の存在を要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/scene/3d/path_3d_editor_plugin.cpp`（1197行）
- E-02: `editor/scene/3d/path_3d_editor_plugin.h`（186行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（51行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（115-116行）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`（エディタープラグイン画面遷移セクション）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Path3Dノード選択時にツールバーが表示される | E-01: 744-751行 make_visible() | ○ |
| C-02 | curve_editボタンでポイント選択モードになる | E-01: 912-919行 curve_edit初期化 | ○ |
| C-03 | curve_edit_curveボタンでコントロールポイント選択モードになる | E-01: 921-928行 curve_edit_curve初期化 | ○ |
| C-04 | curve_edit_tiltボタンでチルト選択モードになる | E-01: 930-936行 curve_edit_tilt初期化 | ○ |
| C-05 | curve_createボタンでポイント追加モードになる | E-01: 938-945行 curve_create初期化 | ○ |
| C-06 | curve_delボタンでポイント削除モードになる | E-01: 947-953行 curve_del初期化 | ○ |
| C-07 | curve_closedボタンでカーブの開閉を切り替える | E-01: 955-960行, 763-776行 _toggle_closed_curve() | ○ |
| C-08 | curve_clear_pointsボタンで全ポイントクリア | E-01: 962-973行, 812-837行 関連メソッド | ○ |
| C-09 | Mirror Handle Anglesオプションが存在する | E-01: 988-991行 ポップアップメニュー設定 | ○ |
| C-10 | Mirror Handle Lengthsオプションが存在する | E-01: 988-991行 ポップアップメニュー設定 | ○ |
| C-11 | Curve3D未設定時にCreate Curveボタンが表示される | E-01: 981-985行, 865-872行 _update_toolbar() | ○ |
| C-12 | セグメント分割機能（Split Path）が実装されている | E-01: 656-663行 ur->create_action(TTR("Split Path")) | ○ |
| C-13 | ポイント追加機能が実装されている | E-01: 678-681行 add_point() | ○ |
| C-14 | ポイント削除機能が実装されている | E-01: 699-704行 remove_point() | ○ |
| C-15 | イン/アウトハンドルのリセット機能がある | E-01: 705-718行 reset in/out control point | ○ |
| C-16 | チルトのリセット機能がある | E-01: 719-726行 reset point tilt | ○ |
| C-17 | ハンドル位置のset_handle()が実装されている | E-01: 100-214行 | ○ |
| C-18 | commit_handle()でUndo/Redo登録される | E-01: 216-297行 EditorUndoRedoManager使用 | ○ |
| C-19 | redraw()でパスとハンドルが描画される | E-01: 299-538行 | ○ |
| C-20 | 開始点は緑、終了点は赤で表示される | E-01: 311-312行 first/last_pt_handle_material色設定 | ○ |
| C-21 | 閉ループ時は黄色で表示される | E-01: 313行 closed_pt_handle_material色設定 | ○ |
| C-22 | スナップ機能対応している | E-01: 118-121行, 147-150行 is_snap_enabled()チェック | ○ |
| C-23 | path3d_tilt_disk_sizeエディター設定が使用される | E-01: 412行 EDITOR_GET("editors/3d_gizmos/gizmo_settings/path3d_tilt_disk_size") | ○ |
| C-24 | 3Dレンダリング機能（7番）と関連している | E-04: 115行 | ○ |
| C-25 | 3Dナビゲーション機能（37番）と関連している | E-04: 116行 | △ |

## 4) 不足情報（Unknown / Missing）
- C-25に関して：画面機能マッピングには「3Dパスフォロー設定のプレビュー」との関連が記載されているが、path_3d_editor_plugin.cpp内にナビゲーション関連の直接的なコードは確認できない。これはPath3D自体の機能であり、エディタープラグインの直接的な責務ではない可能性がある
  - 候補：scene/3d/path_3d.cpp / scene/3d/path_follow_3d.cpp / scene/navigation_3d.cpp

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**：機能実装は安定しており、コードとドキュメントの整合性が高い
- UIテキスト（ツールチップ等）は TTR() マクロ経由のため、実際のローカライズ表示は翻訳ファイル依存

## 6) レビュアーチェックリスト（最小）
- [ ] Path3Dノード選択時にツールバーが正しく表示されることを確認
- [ ] 各編集モード（選択/コントロールポイント/チルト/追加/削除）が期待通り動作することを確認
- [ ] ポイント追加・削除・移動後にUndo/Redoが正しく機能することを確認
- [ ] Mirror Handle Angles/Lengthsオプションが期待通り動作することを確認
- [ ] カーブのクローズ/オープン切り替えが正しく機能することを確認
