---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：52-スケルトン3Dエディタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **IK機能との連携**：画面機能マッピングには記載あるが、skeleton_3d_editor_plugin.cpp内での直接的なIK実装は限定的
  2. **ボーンハンドル3D表示の詳細**：Skeleton3DGizmoPluginの実装詳細（別ファイルの可能性）
  3. **キーフレーム挿入のModifier対応**：key_mod_insert_button関連の詳細動作

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/scene/3d/skeleton_3d_editor_plugin.cpp`（1199行以上）
- E-02: `editor/scene/3d/skeleton_3d_editor_plugin.h`（311行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（52行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（117-118行）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`（エディタープラグイン画面遷移セクション）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Skeleton3Dノード選択時にインスペクターにUIが表示される | E-02: 264-266行 EditorInspectorPluginSkeleton::can_handle()/parse_begin() | ○ |
| C-02 | ボーンツリーでボーン階層が表示される | E-01: 949-1019行 update_joint_tree() | ○ |
| C-03 | ボーン選択時にポーズエディターが表示される | E-01: 812-835行 _joint_tree_selection_changed() | ○ |
| C-04 | Position/Rotation/Scaleプロパティが編集可能 | E-01: 53-96行 BonePropertiesEditor::create_editors() | ○ |
| C-05 | Restトランスフォームが表示される | E-01: 97-107行 rest_section/rest_matrix | ○ |
| C-06 | Reset All Bone Posesメニューが存在する | E-01: 1052行 SKELETON_OPTION_RESET_ALL_POSES | ○ |
| C-07 | Reset Selected Posesメニューが存在する | E-01: 1053行 SKELETON_OPTION_RESET_SELECTED_POSES | ○ |
| C-08 | Apply All Poses to Restsメニューが存在する | E-01: 1054行 SKELETON_OPTION_ALL_POSES_TO_RESTS | ○ |
| C-09 | Apply Selected Poses to Restsメニューが存在する | E-01: 1055行 SKELETON_OPTION_SELECTED_POSES_TO_RESTS | ○ |
| C-10 | Create Physical Skeletonメニューが存在する | E-01: 1056行 SKELETON_OPTION_CREATE_PHYSICAL_SKELETON | ○ |
| C-11 | Export Skeleton Profileメニューが存在する | E-01: 1057行 SKELETON_OPTION_EXPORT_SKELETON_PROFILE | ○ |
| C-12 | reset_pose()メソッドでポーズリセットが実装されている | E-01: 417-450行 | ○ |
| C-13 | pose_to_rest()メソッドでRest適用が実装されている | E-01: 511-540行 | ○ |
| C-14 | create_physical_skeleton()でPhysicalBoneSimulator3Dが作成される | E-01: 559行 memnew(PhysicalBoneSimulator3D) | ○ |
| C-15 | 各ボーンにPhysicalBone3DとCollisionShape3D（カプセル）が生成される | E-01: 605-644行 create_physical_bone() | ○ |
| C-16 | export_skeleton_profile()でSkeletonProfileが出力される | E-01: 646-714行 | ○ |
| C-17 | Edit Modeボタンが存在する | E-01: 1065-1073行 edit_mode_button | ○ |
| C-18 | キーイングボタン群（loc/rot/scale/insert）が存在する | E-01: 1081-1149行 | ○ |
| C-19 | insert_keys()でアニメーションキーが挿入される | E-01: 452-509行 | ○ |
| C-20 | ドラッグ＆ドロップでボーン親子関係変更が可能 | E-01: 716-810行 get_drag_data_fw()/can_drop_data_fw()/drop_data_fw() | ○ |
| C-21 | Revertボタンでボーンプロパティをリセットできる | E-01: 841-939行 _joint_tree_button_clicked() | ○ |
| C-22 | ボーンメタデータ追加機能がある | E-01: 109-117行 add_metadata_button, 200-223行 _add_meta_confirm() | ○ |
| C-23 | ボーンなし時に物理スケルトン作成で警告が表示される | E-01: 550-551行 show_warning() | ○ |
| C-24 | ボーンなし時にプロファイルエクスポートで警告が表示される | E-01: 647-650行 show_warning() | ○ |
| C-25 | プロファイル保存エラー時にエラーメッセージが表示される | E-01: 710-713行 show_warning() | ○ |
| C-26 | Undo/Redo対応している | E-01: 多数箇所でEditorUndoRedoManager使用 | ○ |
| C-27 | スケルトン/ボーン機能（34番）と関連している | E-04: 117行 | ○ |
| C-28 | IK機能（35番）と関連している | E-04: 118行 | △ |

## 4) 不足情報（Unknown / Missing）
- C-28に関して：画面機能マッピングには「IK設定・プレビュー」との関連が記載されているが、skeleton_3d_editor_plugin.cpp内にIK関連の直接的なコードは確認できない。IK設定は別のプラグインまたはSkeleton3Dノード自体の機能として実装されている可能性がある
  - 候補：editor/plugins/skeleton_ik_3d_editor_plugin.cpp / scene/3d/skeleton_ik_3d.cpp

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**：主要機能の実装は安定しており、コードとドキュメントの整合性が高い
- 物理スケルトン生成はボーン構造に依存するため、複雑なスケルトンでは期待通りに動作しない可能性がある
- キーフレーム挿入はAnimationPlayerEditorとの連携が必要であり、エディター状態に依存する

## 6) レビュアーチェックリスト（最小）
- [ ] Skeleton3Dノード選択時にインスペクターにボーンツリーが表示されることを確認
- [ ] ボーン選択時にポーズエディター（Position/Rotation/Scale）が正しく表示されることを確認
- [ ] Reset All Bone Poses / Reset Selected Posesが期待通り動作することを確認
- [ ] Apply All Poses to Rests / Apply Selected Poses to Restsが期待通り動作することを確認
- [ ] Create Physical Skeletonで物理ボーンが正しく生成されることを確認
- [ ] Export Skeleton ProfileでSkeletonProfileリソースが正しく出力されることを確認
- [ ] ドラッグ＆ドロップでボーン親子関係が変更できることを確認
- [ ] 全操作でUndo/Redoが正しく機能することを確認
