---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-メッシュエディタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠が確認できました
- 備考
  - メッシュエディタは比較的シンプルな機能のため、実装コードと仕様の整合性が高い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/scene/3d/mesh_editor_plugin.cpp`（191行）
- E-02: `editor/scene/3d/mesh_editor_plugin.h`（98行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（53行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（119行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Meshリソース選択時にプレビューが表示される | E-01: 170-172行 can_handle(), 174-184行 parse_begin() | ○ |
| C-02 | SubViewportContainerベースのプレビュー | E-02: 44行 GDCLASS(MeshEditor, SubViewportContainer) | ○ |
| C-03 | SubViewportが作成される | E-01: 105行 memnew(SubViewport) | ○ |
| C-04 | Camera3Dが設定される | E-01: 113-116行 memnew(Camera3D)、パースペクティブ設定 | ○ |
| C-05 | 2つのDirectionalLight3Dが設置される | E-01: 123-130行 light1, light2 | ○ |
| C-06 | light1は斜め上からの白色光 | E-01: 124行 looking_at(Vector3(-1, -1, -1)) | ○ |
| C-07 | light2は上からの灰色光（0.7, 0.7, 0.7） | E-01: 128-129行 looking_at(Vector3(0, 1, 0)), set_color(Color(0.7, 0.7, 0.7)) | ○ |
| C-08 | MeshInstance3Dでメッシュが表示される | E-01: 134行 memnew(MeshInstance3D), E-02: 51行 メンバ変数 | ○ |
| C-09 | edit()でメッシュが設定される | E-01: 74-77行 mesh_instance->set_mesh(mesh) | ○ |
| C-10 | 初期回転は-15度、30度 | E-01: 78-79行 rot_x = deg_to_rad(-15.0), rot_y = deg_to_rad(30.0) | ○ |
| C-11 | AABBからスケール・オフセットが計算される | E-01: 82-93行 get_aabb(), get_center(), get_longest_axis_size() | ○ |
| C-12 | マウスドラッグで回転可能 | E-01: 38-48行 gui_input() | ○ |
| C-13 | 回転量は相対移動×0.01 | E-01: 43-44行 mm->get_relative() * 0.01 | ○ |
| C-14 | X軸回転は-π/2からπ/2にクランプ | E-01: 46行 CLAMP(rot_x, -Math::PI / 2, Math::PI / 2) | ○ |
| C-15 | ライト1ボタンでlight1の表示/非表示切り替え | E-01: 96-98行 _on_light_1_switch_pressed() | ○ |
| C-16 | ライト2ボタンでlight2の表示/非表示切り替え | E-01: 100-102行 _on_light_2_switch_pressed() | ○ |
| C-17 | MSAA 4X設定 | E-01: 111行 set_msaa_3d(Viewport::MSAA_4X) | ○ |
| C-18 | 最小サイズは1×150ピクセル（EDSCALE適用） | E-01: 137行 set_custom_minimum_size(Size2(1, 150) * EDSCALE) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主要機能についてソースコードで確認できました

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**：シンプルなプレビュー機能であり、実装とドキュメントの整合性が高い
- 物理ライトユニット使用時のCameraAttributes設定は条件付きで適用される（E-01: 118-121行）

## 6) レビュアーチェックリスト（最小）
- [ ] Meshリソース選択時にインスペクター上部に3Dプレビューが表示されることを確認
- [ ] マウスドラッグでメッシュを回転できることを確認
- [ ] ライト1/ライト2ボタンで照明の切り替えができることを確認
- [ ] 様々なサイズのメッシュが適切にスケーリングされて表示されることを確認
