---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-マテリアルエディタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠が確認できました
- 備考
  - マテリアルエディタは2D/3D両対応の複合機能を持つが、コードの整理が良好で仕様との整合性が高い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/scene/material_editor_plugin.cpp`（502行）
- E-02: `editor/scene/material_editor_plugin.h`（156行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（54行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（120-121行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Materialリソース選択時にプレビューが表示される | E-01: 403-410行 can_handle(), 412-422行 parse_begin() | ○ |
| C-02 | シェーダーモードで2D/3Dが切り替わる | E-01: 160-186行 edit()内のモード判定 | ○ |
| C-03 | SPATIAL時は3Dプレビューが表示される | E-01: 171-178行 layout_3d->show() | ○ |
| C-04 | CANVAS_ITEM時は2Dプレビューが表示される | E-01: 163-170行 layout_2d->show(), rect_instance->set_material() | ○ |
| C-05 | その他のモードではエラーメッセージが表示される | E-01: 179-185行 layout_error->show() | ○ |
| C-06 | エラーメッセージ「Preview is not available for this shader mode.」 | E-01: 265行 set_text(TTR("Preview is not available...")) | ○ |
| C-07 | 球体/ボックス/クワッドの3種類のプレビューメッシュ | E-01: 313-331行 sphere_instance, box_instance, quad_instance | ○ |
| C-08 | 球体選択時にSphereMeshが使用される | E-01: 326-327行 sphere_mesh.instantiate(), sphere_instance->set_mesh() | ○ |
| C-09 | ボックス選択時にBoxMeshが使用される | E-01: 328-329行 box_mesh.instantiate(), box_instance->set_mesh() | ○ |
| C-10 | クワッド選択時にQuadMeshが使用される | E-01: 330-331行 quad_mesh.instantiate(), quad_instance->set_mesh() | ○ |
| C-11 | マウスドラッグで回転可能 | E-01: 82-99行 gui_input() | ○ |
| C-12 | クワッド時は回転が±80度にクランプされる | E-01: 90-92行 CLAMP(-limit, limit) where limit=80度 | ○ |
| C-13 | 回転設定がプロジェクトメタデータに保存される | E-01: 143-146行 set_project_metadata("material_preview_rotation") | ○ |
| C-14 | メッシュ設定がプロジェクトメタデータに保存される | E-01: 208, 219, 230行 set_project_metadata("material_preview_mesh") | ○ |
| C-15 | ライト1は斜め上からの白色光 | E-01: 301-302行 looking_at(Vector3(-1, -1, -1)) | ○ |
| C-16 | ライト2は上からの灰色光（0.7, 0.7, 0.7） | E-01: 305-307行 looking_at(Vector3(0, 1, 0)), set_color(Color(0.7, 0.7, 0.7)) | ○ |
| C-17 | ライト切り替えボタンが存在する | E-01: 366-380行 light_1_switch, light_2_switch | ○ |
| C-18 | 球体/ボックス/クワッド切り替えボタンが存在する | E-01: 340-359行 sphere_switch, box_switch, quad_switch | ○ |
| C-19 | MSAA 4X設定 | E-01: 287行 set_msaa_3d(Viewport::MSAA_4X) | ○ |
| C-20 | 透明背景 | E-01: 286行 set_transparent_background(true) | ○ |
| C-21 | 最小サイズは1×150ピクセル（EDSCALE適用） | E-01: 234行 set_custom_minimum_size(Size2(1, 150) * EDSCALE) | ○ |
| C-22 | カメラは20度の低FOV | E-01: 293行 set_perspective(20, 0.1, 10) | ○ |
| C-23 | チェッカーボード背景が描画される | E-01: 127-132行 NOTIFICATION_DRAW、draw_texture_rect(checkerboard) | ○ |
| C-24 | Environment設定にSkyが含まれる | E-01: 460-465行 env->set_sky(), set_ambient_source(SKY), set_reflection_source(SKY) | ○ |
| C-25 | テクスチャ設定時にroughness/metallicが1.0に自動設定される | E-01: 424-456行 _undo_redo_inspector_callback() | ○ |
| C-26 | ParticleProcessMaterialの変換プラグインが存在する | E-01: 476-487行 ParticleProcessMaterialConversionPlugin | ○ |
| C-27 | CanvasItemMaterialの変換プラグインが存在する | E-01: 489-501行 CanvasItemMaterialConversionPlugin | ○ |
| C-28 | make_shader_material()でShaderMaterial変換 | E-01: 53-80行 | ○ |
| C-29 | シェーダー機能（11番）と関連している | E-04: 120行 | ○ |
| C-30 | 3Dレンダリング機能（7番）と関連している | E-04: 121行 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主要機能についてソースコードで確認できました

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**：2D/3D両対応のプレビュー機能だが、コードの分岐が明確で整理されている
- テクスチャ自動調整（roughness/metallic=1.0）はUndoに統合されているため、意図しない変更でも取り消し可能
- CanvasItemMaterial変換は`_is_initialized()`チェックが必要（E-01: 499行）

## 6) レビュアーチェックリスト（最小）
- [ ] 3Dマテリアル（StandardMaterial3D等）選択時に3Dプレビューが表示されることを確認
- [ ] 2Dマテリアル（CanvasItemMaterial）選択時に2Dプレビューが表示されることを確認
- [ ] マウスドラッグでプレビューが回転することを確認
- [ ] 球体/ボックス/クワッドの切り替えが正しく動作することを確認
- [ ] ライト1/ライト2の切り替えが正しく動作することを確認
- [ ] クワッド選択時に回転範囲が制限されることを確認
- [ ] マテリアル切り替え後も回転設定が保持されることを確認
- [ ] roughness/metallic_texture設定時に対応プロパティが1.0になることを確認（BaseMaterial3D）
