---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：6-アセットライブラリ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **API URLの正確性**：実際のエンドポイント確認
  2. **オフラインモード時の挙動**：完全な機能制限範囲

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/asset_library/asset_library_editor_plugin.cpp` 行1-300
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行7
- E-03: `docs/code-to-docs/画面遷移図.md` 行47, 74, 80
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行25-26

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | オンラインアセットライブラリ | E-02 | ○ |
| C-02 | AssetLibタブでアクセス | E-03 行47 | ○ |
| C-03 | setup_http_request()関数 | E-01 行50-57 | ○ |
| C-04 | HTTPリクエストスレッド設定 | E-01 行51 | ○ |
| C-05 | プロキシ設定対応 | E-01 行53-56 | ○ |
| C-06 | EditorAssetLibraryItem::configure() | E-01 行59-71 | ○ |
| C-07 | set_image()でサムネイル設定 | E-01 行73-78 | ○ |
| C-08 | IMAGE_QUEUE_ICON定数 | E-01 行74 | ○ |
| C-09 | リンクボタンUI | E-01 行163-245 | ○ |
| C-10 | カスタム最小サイズ250x80 | E-01 行243 | ○ |
| C-11 | EditorAssetLibraryItemDescription | E-01 行249-290 | ○ |
| C-12 | IMAGE_QUEUE_THUMBNAIL | E-01 行256 | ○ |
| C-13 | IMAGE_QUEUE_SCREENSHOT | E-01 行278 | ○ |
| C-14 | リソース管理が主機能 | E-04 行25 | ○ |
| C-15 | HTTPリクエストがAPI連携 | E-04 行26 | ○ |
| C-16 | プロジェクトマネージャーからアクセス | E-03 行74, 80 | ○ |
| C-17 | API URLの詳細 | **根拠不足** | △ |
| C-18 | オフラインモード完全仕様 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Asset Library APIの詳細エンドポイント仕様
  - 候補：Godot公式ドキュメント / APIソースコード
- オフラインモード時の完全な動作仕様
  - 候補：`editor/settings/editor_settings.cpp`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI構成、アセット表示
- 1: 中リスク - HTTP通信、エラー処理
- 2: 高リスク - API URL、オフラインモード

## 6) レビュアーチェックリスト（最小）
- [ ] アセット検索・一覧表示の動作確認
- [ ] ダウンロード・インストールフローの確認
- [ ] プロキシ設定の動作確認
- [ ] オフラインモード時の表示確認
