---
generated_at: 2026-01-23 11:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：7-ファイルシステムドック

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **お気に入り機能の詳細**：永続化方法
  2. **ゴミ箱機能の実装**：OS依存の動作

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/docks/filesystem_dock.cpp` 行1-300
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行8
- E-03: `docs/code-to-docs/画面遷移図.md` 行49
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行27-29

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクトファイル一覧表示 | E-02 | ○ |
| C-02 | res://配下のファイル管理 | E-02 | ○ |
| C-03 | FileSystemTree::make_custom_tooltip() | E-01 行71-77 | ○ |
| C-04 | FileSystemList::make_custom_tooltip() | E-01 行79-85 | ○ |
| C-05 | FileSystemList::edit_selected() | E-01 行103-166 | ○ |
| C-06 | popup_editorで名前編集 | E-01 行154-165 | ○ |
| C-07 | _get_tree_item_icon() | E-01 行206-221 | ○ |
| C-08 | _create_tree()再帰処理 | E-01 行223-286 | ○ |
| C-09 | カスタムフォルダカラー | E-01 行235-254 | ○ |
| C-10 | シンボリックリンク対応 | E-01 行259-261 | ○ |
| C-11 | リンクオーバーレイアイコン | E-01 行260 | ○ |
| C-12 | リソース管理が主機能 | E-04 行27 | ○ |
| C-13 | ファイルシステムドックが主機能 | E-04 行28 | ○ |
| C-14 | 画像インポート連携 | E-04 行29 | ○ |
| C-15 | DirectoryCreateDialog連携 | E-01 行48 include | ○ |
| C-16 | SceneCreateDialog連携 | E-01 行56 include | ○ |
| C-17 | お気に入り機能の永続化 | **根拠不足** | △ |
| C-18 | ゴミ箱機能の詳細動作 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- お気に入りの永続化先と形式
  - 候補：`editor_layout.cfg` / `editor_settings.tres`
- ゴミ箱機能のOS別動作
  - 候補：`core/os/os.cpp`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ツリー表示、ファイル一覧
- 1: 中リスク - ドラッグ&ドロップ、名前変更
- 2: 高リスク - ファイル削除（ゴミ箱動作）

## 6) レビュアーチェックリスト（最小）
- [ ] ディレクトリツリーの展開/折りたたみ確認
- [ ] ファイル検索のフィルタリング動作確認
- [ ] ドラッグ&ドロップの移動/コピー確認
- [ ] シンボリックリンクの表示確認
