---
generated_at: 2026-01-23 11:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：8-シーンツリードック

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Editable Children設定の詳細**：インスタンス内ノードの編集制限

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/docks/scene_tree_dock.cpp` 行1-300
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 行9
- E-03: `docs/code-to-docs/画面遷移図.md` 行148-167
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行30-32

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ノード階層表示ドック | E-02 | ○ |
| C-02 | ノードの追加・削除・並べ替え | E-02 | ○ |
| C-03 | _quick_open()でインスタンス化 | E-01 行77-79 | ○ |
| C-04 | _inspect_hovered_node()ホバープレビュー | E-01 行93-116 | ○ |
| C-05 | input()マウス処理 | E-01 行141-170 | ○ |
| C-06 | shortcut_input()ショートカット | E-01 行172-251 | ○ |
| C-07 | TOOL_RENAME | E-01 行193 | ○ |
| C-08 | TOOL_BATCH_RENAME | E-01 行195 | ○ |
| C-09 | TOOL_NEW | E-01 行197 | ○ |
| C-10 | TOOL_INSTANTIATE | E-01 行199 | ○ |
| C-11 | TOOL_CUT/COPY/PASTE | E-01 行202-209 | ○ |
| C-12 | instantiate_scenes() | E-01 行267-295 | ○ |
| C-13 | シーンツリー管理が主機能 | E-04 行30 | ○ |
| C-14 | ノードシステムが主機能 | E-04 行31 | ○ |
| C-15 | シグナルシステムが遷移先機能 | E-04 行32 | ○ |
| C-16 | 画面遷移図との整合 | E-03 | ○ |
| C-17 | InspectorDock連携 | E-01 行112-115 | ○ |
| C-18 | Editable Children詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Editable Childrenの詳細な編集制限仕様
  - 候補：`editor/scene/scene_tree_dock.cpp` 後半 / `scene/main/scene_tree.cpp`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ノード表示、選択、名前変更
- 1: 中リスク - ドラッグ&ドロップ、インスタンス化
- 2: 高リスク - Editable Children制御

## 6) レビュアーチェックリスト（最小）
- [ ] ノード追加/削除の動作確認
- [ ] ドラッグ&ドロップでの親変更確認
- [ ] ショートカットキーの動作確認
- [ ] インスタンス内ノードの編集制限確認
