---
generated_at: 2026-01-23 12:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：9-インスペクタードック

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **ピン留め機能の詳細**：永続化方法と適用範囲
  2. **プロパティ検索の実装詳細**：フィルタリングアルゴリズム

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/docks/inspector_dock.cpp` 行1-400
- E-02: `editor/docks/inspector_dock.h` 行1-168
- E-03: `editor/inspector/editor_inspector.h` 行1-200
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 行10
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行33-35

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロパティ編集ドック | E-04 | ○ |
| C-02 | MenuOptions enum定義 | E-02 行50-73 | ○ |
| C-03 | RESOURCE_SAVE/SAVE_AS | E-02 行52-53 | ○ |
| C-04 | RESOURCE_SHOW_IN_FILESYSTEM | E-02 行54 | ○ |
| C-05 | OBJECT_COPY_PARAMS/PASTE_PARAMS | E-02 行58-59 | ○ |
| C-06 | OBJECT_UNIQUE_RESOURCES | E-02 行60 | ○ |
| C-07 | EXPAND_ALL/COLLAPSE_ALL/EXPAND_REVERTABLE | E-02 行63-65 | ○ |
| C-08 | PROPERTY_NAME_STYLE_* | E-02 行68-70 | ○ |
| C-09 | _menu_option_confirm()メニュー処理 | E-01 行63-228 | ○ |
| C-10 | _new_resource()リソース作成 | E-01 行230-232 | ○ |
| C-11 | _load_resource()リソース読み込み | E-01 行234-251 | ○ |
| C-12 | _save_resource()リソース保存 | E-01 行272-281 | ○ |
| C-13 | _copy_resource()/_paste_resource() | E-01 行290-301 | ○ |
| C-14 | _prepare_history()履歴メニュー構築 | E-01 行318-366 | ○ |
| C-15 | _select_history()履歴選択 | E-01 行368-380 | ○ |
| C-16 | EditorProperty基底クラス | E-03 行70-141 | ○ |
| C-17 | MenuItems enum (MENU_COPY_VALUE等) | E-03 行119-129 | ○ |
| C-18 | シングルトンパターン | E-02 行140-144 | ○ |
| C-19 | ピン留め機能の詳細 | **根拠不足** | △ |
| C-20 | プロパティ検索の実装 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- ピン留め機能の永続化先と仕様
  - 候補：`editor/settings/editor_settings.cpp` / `editor_layout.cfg`
- プロパティ検索のフィルタリング実装
  - 候補：`editor/inspector/editor_inspector.cpp`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プロパティ表示、展開/折りたたみ
- 1: 中リスク - プロパティ編集、Undo/Redo
- 2: 高リスク - リソース保存、Unique Resources

## 6) レビュアーチェックリスト（最小）
- [ ] プロパティ値編集とUndo/Redo動作確認
- [ ] リソース作成・保存フローの確認
- [ ] 編集履歴の移動動作確認
- [ ] プロパティ名スタイル切り替え確認
