---
generated_at: 2026-01-23 17:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 50
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：50 / 50、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tests/core/io/test_tcp_server.h` - TCPサーバー結合テスト
- E-02: `tests/core/io/test_udp_server.h` - UDPサーバー結合テスト
- E-03: `tests/core/io/test_http_client.h` - HTTPクライアントテスト
- E-04: `tests/core/io/test_stream_peer_tcp.h` - TCPストリームピアテスト
- E-05: `tests/servers/test_navigation_server_3d.h` - ナビゲーションサーバー3Dテスト
- E-06: `tests/servers/test_text_server.h` - テキストサーバーテスト
- E-07: `tests/scene/test_packed_scene.h` - PackedSceneテスト
- E-08: `tests/core/io/test_resource.h` - リソース保存・読込テスト
- E-09: `tests/scene/test_animation_player.h` - AnimationPlayerテスト
- E-10: `tests/core/input/test_shortcut.h` - ショートカット入力テスト
- E-11: `tests/test_main.cpp` - テストメインエントリポイント（PhysicsServer/RenderingServer/AudioServer初期化）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: TCPサーバー接続受入とデータ送受信 | E-01 | ○ |
| C-02 | IT-002: 複数クライアント同時接続ハンドリング | E-01 | ○ |
| C-03 | IT-003: サーバー停止後の新規接続拒否 | E-01 | ○ |
| C-04 | IT-004: サーバー側からのクライアント切断 | E-01 | ○ |
| C-05 | IT-005: UDP接続受入とデータ送受信 | E-02 | ○ |
| C-06 | IT-006: UDP複数クライアント同時処理 | E-02 | ○ |
| C-07 | IT-007: UDPサーバー停止後の接続拒否 | E-02 | ○ |
| C-08 | IT-008: HTTPクライアントインスタンス化 | E-03 | ○ |
| C-09 | IT-009: クエリ文字列生成 | E-03 | ○ |
| C-10 | IT-010: ヘッダー検証 | E-03 | ○ |
| C-11 | IT-011: HTTPSホストへの接続 | E-03 | ○ |
| C-12 | IT-012: TCPストリームピア基本操作 | E-04 | ○ |
| C-13 | IT-013: 無効ポート番号でのバインドエラー | E-04 | ○ |
| C-14 | IT-014: 有効ポート番号でのバインド成功 | E-04 | ○ |
| C-15 | IT-015: ASCII文字列データ送受信 | E-04 | ○ |
| C-16 | IT-016: ナビゲーションサーバー初期化状態 | E-05 | ○ |
| C-17 | IT-017: エージェント管理 | E-05 | ○ |
| C-18 | IT-018: マップ管理 | E-05 | ○ |
| C-19 | IT-019: リンク管理 | E-05 | ○ |
| C-20 | IT-020: リージョン管理 | E-05 | ○ |
| C-21 | IT-021: エージェント移動と回避コールバック | E-05 | ○ |
| C-22 | IT-022: 複数エージェント間の回避 | E-05 | ○ |
| C-23 | IT-023: 動的障害物の回避 | E-05 | ○ |
| C-24 | IT-024: 静的障害物の回避 | E-05 | ○ |
| C-25 | IT-025: ナビゲーションメッシュベイク | E-05 | ○ |
| C-26 | IT-026: パスクエリ（CORRIDORFUNNEL） | E-05 | ○ |
| C-27 | IT-027: パスクエリ（EDGECENTERED） | E-05 | ○ |
| C-28 | IT-028: レイヤーマスク不一致でのパスクエリ | E-05 | ○ |
| C-29 | IT-029: パス簡略化 | E-05 | ○ |
| C-30 | IT-030: フォント読み込み | E-06 | ○ |
| C-31 | IT-031: フォントフォールバック | E-06 | ○ |
| C-32 | IT-032: BiDiテキストレイアウト | E-06 | ○ |
| C-33 | IT-033: 改行・整列ポイント検出 | E-06 | ○ |
| C-34 | IT-034: 行分割 | E-06 | ○ |
| C-35 | IT-035: テキスト正当化 | E-06 | ○ |
| C-36 | IT-036: カシーダ正当化 | E-06 | ○ |
| C-37 | IT-037: シーンパック・状態取得 | E-07 | ○ |
| C-38 | IT-038: シグナル保持 | E-07 | ○ |
| C-39 | IT-039: シーンインスタンス化 | E-07 | ○ |
| C-40 | IT-040: 子ノード付きインスタンス化 | E-07 | ○ |
| C-41 | IT-041: リソース保存・読込（バイナリ） | E-08 | ○ |
| C-42 | IT-042: リソース保存・読込（テキスト） | E-08 | ○ |
| C-43 | IT-043: 循環参照の処理 | E-08 | ○ |
| C-44 | IT-044: リソース複製（シャロー） | E-08 | ○ |
| C-45 | IT-045: リソース複製（ディープ） | E-08 | ○ |
| C-46 | IT-046: ブレンドタイム設定 | E-09 | ○ |
| C-47 | IT-047: ショートカットイベントマッチ | E-10 | ○ |
| C-48 | IT-048: 物理サーバー初期化 | E-11 | ○ |
| C-49 | IT-049: レンダリングサーバー初期化 | E-11 | ○ |
| C-50 | IT-050: オーディオサーバー初期化 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 全テストケースがソースコード内の実際のテスト実装に基づいています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコードの根拠あり
- テストケースは実際のdoctestフレームワークを使用したC++テストコードから抽出
- テスト手順・期待結果はソースコード内のCHECK/REQUIRE マクロから導出

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースID（IT-001〜IT-050）の連番に欠番がないか
- [ ] 各テストケースのテスト種別が適切に分類されているか（ネットワーク連携/サーバー連携/シーン連携/リソース連携等）
- [ ] 優先度（高/中/低）の設定が妥当か
- [ ] 前提条件が実行環境要件として妥当か
- [ ] テスト手順の粒度が実行可能なレベルか
- [ ] 期待結果が検証可能な形式で記載されているか
- [ ] 備考欄のソースファイルパスが正確か
