---
generated_at: 2026-01-23 11:12:00
metrics:
  claims_total: 81
  claims_with_evidence: 81
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：81 / 81、根拠なし：0
- 優先レビュー（高）
  1. 特になし：全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `doc/classes/EditorToaster.xml` - EditorToaster通知機能のAPI定義
- E-02: `editor/gui/editor_toaster.h` - EditorToasterクラス定義とSeverity enum
- E-03: `editor/gui/editor_toaster.cpp` - EditorToaster実装コード
- E-04: `doc/classes/@GlobalScope.xml` - push_error/push_warning関数の定義
- E-05: `doc/classes/Logger.xml` - Loggerクラスとエラータイプの定義
- E-06: `doc/classes/OS.xml` - OS.alert等のシステム通知機能
- E-07: `doc/classes/StatusIndicator.xml` - システムトレイ通知機能
- E-08: `doc/classes/DisplayServer.xml` - window_request_attention等
- E-09: `doc/classes/AcceptDialog.xml` - ダイアログ通知シグナル
- E-10: `doc/classes/Node.xml` - Nodeライフサイクル通知定数
- E-11: `core/object/object.h` - Object通知定数（NOTIFICATION_POSTINITIALIZE等）
- E-12: `doc/classes/CanvasItem.xml` - CanvasItem通知定数
- E-13: `doc/classes/Control.xml` - Control通知定数
- E-14: `doc/classes/Node3D.xml` - Node3D通知定数
- E-15: `doc/classes/MainLoop.xml` - MainLoop/Window通知定数
- E-16: `doc/classes/MultiplayerPeer.xml` - マルチプレイヤー通知シグナル
- E-17: `doc/classes/Container.xml` - Container通知定数
- E-18: `doc/classes/Skeleton3D.xml` - Skeleton3D通知定数
- E-19: `core/error/error_macros.h` - エラーハンドラータイプ定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EditorToaster INFO通知 | E-01, E-02 | ○ |
| C-02 | EditorToaster WARNING通知 | E-01, E-02 | ○ |
| C-03 | EditorToaster ERROR通知 | E-01, E-02 | ○ |
| C-04 | push_error関数 | E-04 | ○ |
| C-05 | push_warning関数 | E-04 | ○ |
| C-06 | Logger ERROR | E-05 | ○ |
| C-07 | Logger WARNING | E-05 | ○ |
| C-08 | Logger SCRIPT | E-05 | ○ |
| C-09 | Logger SHADER | E-05 | ○ |
| C-10 | OS.alert | E-06 | ○ |
| C-11 | StatusIndicator | E-07 | ○ |
| C-12 | window_request_attention | E-08 | ○ |
| C-13 | AcceptDialog confirmed | E-09 | ○ |
| C-14 | AcceptDialog canceled | E-09 | ○ |
| C-15 | AcceptDialog custom_action | E-09 | ○ |
| C-16 | NOTIFICATION_ENTER_TREE | E-10 | ○ |
| C-17 | NOTIFICATION_EXIT_TREE | E-10 | ○ |
| C-18 | NOTIFICATION_READY | E-10 | ○ |
| C-19 | NOTIFICATION_PROCESS | E-10 | ○ |
| C-20 | NOTIFICATION_PHYSICS_PROCESS | E-10 | ○ |
| C-21 | NOTIFICATION_PAUSED | E-10 | ○ |
| C-22 | NOTIFICATION_UNPAUSED | E-10 | ○ |
| C-23 | NOTIFICATION_PARENTED | E-10 | ○ |
| C-24 | NOTIFICATION_UNPARENTED | E-10 | ○ |
| C-25 | NOTIFICATION_POSTINITIALIZE | E-11 | ○ |
| C-26 | NOTIFICATION_PREDELETE | E-11 | ○ |
| C-27 | NOTIFICATION_EXTENSION_RELOADED | E-11 | ○ |
| C-28 | NOTIFICATION_DRAW | E-12 | ○ |
| C-29 | NOTIFICATION_VISIBILITY_CHANGED (CanvasItem) | E-12 | ○ |
| C-30 | NOTIFICATION_ENTER_CANVAS | E-12 | ○ |
| C-31 | NOTIFICATION_EXIT_CANVAS | E-12 | ○ |
| C-32 | NOTIFICATION_TRANSFORM_CHANGED (CanvasItem) | E-12 | ○ |
| C-33 | NOTIFICATION_LOCAL_TRANSFORM_CHANGED (CanvasItem) | E-12 | ○ |
| C-34 | NOTIFICATION_RESIZED | E-13 | ○ |
| C-35 | NOTIFICATION_MOUSE_ENTER | E-13 | ○ |
| C-36 | NOTIFICATION_MOUSE_EXIT | E-13 | ○ |
| C-37 | NOTIFICATION_FOCUS_ENTER | E-13 | ○ |
| C-38 | NOTIFICATION_FOCUS_EXIT | E-13 | ○ |
| C-39 | NOTIFICATION_THEME_CHANGED | E-13 | ○ |
| C-40 | NOTIFICATION_SCROLL_BEGIN | E-13 | ○ |
| C-41 | NOTIFICATION_SCROLL_END | E-13 | ○ |
| C-42 | NOTIFICATION_ENTER_WORLD | E-14 | ○ |
| C-43 | NOTIFICATION_EXIT_WORLD | E-14 | ○ |
| C-44 | NOTIFICATION_VISIBILITY_CHANGED (Node3D) | E-14 | ○ |
| C-45 | NOTIFICATION_WM_MOUSE_ENTER | E-10, E-15 | ○ |
| C-46 | NOTIFICATION_WM_MOUSE_EXIT | E-10, E-15 | ○ |
| C-47 | NOTIFICATION_WM_WINDOW_FOCUS_IN | E-10, E-15 | ○ |
| C-48 | NOTIFICATION_WM_WINDOW_FOCUS_OUT | E-10, E-15 | ○ |
| C-49 | NOTIFICATION_WM_CLOSE_REQUEST | E-10, E-15 | ○ |
| C-50 | NOTIFICATION_WM_GO_BACK_REQUEST | E-10, E-15 | ○ |
| C-51 | NOTIFICATION_WM_SIZE_CHANGED | E-10, E-15 | ○ |
| C-52 | NOTIFICATION_WM_DPI_CHANGE | E-10, E-15 | ○ |
| C-53 | NOTIFICATION_OS_MEMORY_WARNING | E-10, E-15 | ○ |
| C-54 | NOTIFICATION_TRANSLATION_CHANGED | E-10, E-15 | ○ |
| C-55 | NOTIFICATION_WM_ABOUT | E-10, E-15 | ○ |
| C-56 | NOTIFICATION_CRASH | E-10, E-15 | ○ |
| C-57 | NOTIFICATION_OS_IME_UPDATE | E-10, E-15 | ○ |
| C-58 | NOTIFICATION_APPLICATION_RESUMED | E-10, E-15 | ○ |
| C-59 | NOTIFICATION_APPLICATION_PAUSED | E-10, E-15 | ○ |
| C-60 | NOTIFICATION_APPLICATION_FOCUS_IN | E-10, E-15 | ○ |
| C-61 | NOTIFICATION_APPLICATION_FOCUS_OUT | E-10, E-15 | ○ |
| C-62 | NOTIFICATION_TEXT_SERVER_CHANGED | E-10, E-15 | ○ |
| C-63 | peer_connected | E-16 | ○ |
| C-64 | peer_disconnected | E-16 | ○ |
| C-65 | NOTIFICATION_PRE_SORT_CHILDREN | E-17 | ○ |
| C-66 | NOTIFICATION_SORT_CHILDREN | E-17 | ○ |
| C-67 | NOTIFICATION_UPDATE_SKELETON | E-18 | ○ |
| C-68 | NOTIFICATION_EDITOR_PRE_SAVE | E-10 | ○ |
| C-69 | NOTIFICATION_EDITOR_POST_SAVE | E-10 | ○ |
| C-70 | NOTIFICATION_RESET_PHYSICS_INTERPOLATION | E-10 | ○ |
| C-71 | NOTIFICATION_ACCESSIBILITY_UPDATE | E-10 | ○ |
| C-72 | NOTIFICATION_ACCESSIBILITY_INVALIDATE | E-10 | ○ |
| C-73 | script_changed シグナル | E-11 | ○ |
| C-74 | property_list_changed シグナル | E-11 | ○ |
| C-75 | tree_entered シグナル | E-10 | ○ |
| C-76 | tree_exiting シグナル | E-10 | ○ |
| C-77 | tree_exited シグナル | E-10 | ○ |
| C-78 | child_entered_tree シグナル | E-10 | ○ |
| C-79 | child_exiting_tree シグナル | E-10 | ○ |
| C-80 | NOTIFICATION_DRAG_BEGIN | E-10 | ○ |
| C-81 | NOTIFICATION_DRAG_END | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての通知機能はAPIドキュメント(XML)およびソースコード(C++/H)から根拠を確認済み。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張はGodotエンジンの公式APIドキュメントおよびソースコードから直接確認
- 通知定数の値（value属性）はXMLドキュメントから抽出しており、ソースコードと一致
- Godotはゲームエンジンであり、従来の業務システムの「通知」（メール、SMS、プッシュ通知サービス等）とは異なるアーキテクチャを採用

## 6) レビュアーチェックリスト（最小）
- [x] 通知のカテゴリ分類が適切か
- [x] 各通知の説明がAPIドキュメントと一致しているか
- [x] 通知定数の値（value）が正確か
- [x] シグナルと通知定数の区別が明確か
- [ ] プロジェクト固有のカスタム通知が存在しないか確認（本プロジェクトはGodotエンジン本体のため該当なし）
