# 通知設計書 1-EditorToaster INFO

## 概要

本ドキュメントは、Godotエンジンのエディタ内で表示されるINFOレベルのトースト通知（EditorToaster INFO）の設計仕様を記述する。

### 本通知の処理概要

EditorToaster INFOは、Godotエディタ内でユーザーに情報レベルのメッセージを視覚的に通知するためのトースト通知機能である。エディタUI右下に一時的に表示されるポップアップ形式の通知で、5秒後に自動的にフェードアウトする。

**業務上の目的・背景**：ゲーム開発者がエディタを使用する際、操作の成功や状態変化などの情報をリアルタイムで把握する必要がある。INFOレベルの通知は、致命的なエラーではないが、ユーザーが知っておくべき情報（例：リソースの読み込み完了、設定の適用成功など）を非侵入的な方法で伝達する。これにより、開発フローを中断することなく重要な情報をユーザーに提供できる。

**通知の送信タイミング**：EditorToasterのpush_toastメソッドがSEVERITY_INFO引数で呼び出されたとき、またはEditorInterfaceを通じてget_editor_toaster().push_toast()が実行されたときに通知が送信される。内部エラーハンドラからも、エディタ通知フラグがtrueの場合に通知される。

**通知の受信者**：Godotエディタを使用している開発者。通知はエディタウィンドウ内のUI要素として表示されるため、エディタを操作中のユーザーのみが受信者となる。

**通知内容の概要**：メッセージ文字列（最大でビューポート幅の半分に収まるよう省略表示）、オプションのツールチップ（ファイルパスや行番号などの詳細情報）、コピーボタン、閉じるボタンが含まれる。

**期待されるアクション**：ユーザーは通知内容を確認し、必要に応じてコピーボタンでメッセージをクリップボードにコピーするか、閉じるボタンで即座に通知を閉じることができる。通知にマウスオーバーすると自動消去タイマーがリセットされる。

## 通知種別

アプリ内通知（エディタUI内トースト通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（MessageQueue経由で遅延呼び出し） |
| 優先度 | 低（INFO severity = 0） |
| リトライ | 無 |

### 送信先決定ロジック

EditorToasterはシングルトンパターンで実装されており、常にエディタの単一インスタンスに対して通知が送信される。送信先はエディタUIのHBoxContainer内に動的に追加されるVBoxContainerである。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | エディタウィンドウ右下 |
| 背景色 | エディタテーマのbase_colorとmono_colorの補間色 |
| 境界線 | なし（INFOの場合） |
| 表示時間 | 5秒（default_message_duration） |

### 本文テンプレート

```
[メッセージテキスト] [コピーボタン] [閉じるボタン]
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | 通知メッセージ | push_toast引数 | Yes |
| tooltip | ツールチップテキスト | push_toast引数 | No |
| severity | 重要度レベル | SEVERITY_INFO定数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | push_toast(message, SEVERITY_INFO) | 常時 | GDScriptまたはC++からの直接呼び出し |
| エラーハンドラ | _error_handler | p_editor_notify=true かつ show_all_setting条件を満たす場合 | エラーマクロからの通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| is_processing_error | エラー処理中の再帰呼び出し防止 |
| vbox_container非表示 | 通知が無効化されている場合 |
| max_temporary_count超過 | 一時通知が5件を超える場合は古いものから非表示 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[push_toast呼び出し] --> B{is_processing_error?}
    B -->|Yes| Z[処理スキップ]
    B -->|No| C[MessageQueue経由で_popup_str呼び出し]
    C --> D{同一メッセージ存在?}
    D -->|Yes| E[既存トーストのカウント増加]
    D -->|No| F[新規PanelContainer作成]
    F --> G[info_panel_style_background適用]
    G --> H[HBoxContainer内にLabel追加]
    H --> I[コピー/閉じるボタン追加]
    I --> J[VBoxContainerに追加]
    J --> K[_auto_hide_or_free_toasts実行]
    K --> L[位置更新・描画]
    E --> K
    L --> M[5秒後自動フェードアウト]
    M --> N[終了]
    Z --> N
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし（データベースは使用しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 再帰呼び出し | is_processing_errorがtrue | 処理をスキップ |
| シングルトン未初期化 | EditorToaster::get_singleton()がnull | 処理をスキップ |
| ツリー外 | is_inside_tree()がfalse | 処理をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 同時表示上限 | 5件（max_temporary_count） |
| 保持上限 | 10件（max_temporary_count * 2） |

### 配信時間帯

制限なし（エディタ動作中は常時）

## セキュリティ考慮事項

- 通知内容はエディタ内でのみ表示され、外部に送信されない
- メッセージ内容のサニタイズは呼び出し元の責任
- クリップボードへのコピー機能はユーザー操作が必要

## 備考

- EditorToasterはEditorInterface経由でGDScriptからアクセス可能
- 同一メッセージが連続する場合はカウント表示される（例：「(3)」）
- マウスホバー中は自動消去タイマーが一時停止される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

EditorToasterの内部データ構造であるToast構造体を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | editor_toaster.h | `editor/gui/editor_toaster.h` | Toast構造体（68-86行目）の定義、Severity列挙型（43-47行目） |

**読解のコツ**: Toast構造体にはseverity、duration、remaining_time、message、tooltip、countなどのメンバが含まれる。これらがトースト通知の状態管理に使用される。

#### Step 2: エントリーポイントを理解する

処理の起点となるpush_toast/popup_str関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | popup_str関数（439-448行目）がパブリックAPI |
| 2-2 | editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | _popup_str関数（451-527行目）が実際の処理実装 |

**主要処理フロー**:
1. **439行目**: popup_str - is_processing_errorチェック
2. **447行目**: MessageQueue経由で_popup_strを遅延呼び出し
3. **451行目**: _popup_str - 同一メッセージの検索
4. **463行目**: 新規メッセージの場合HBoxContainer作成
5. **476行目**: popup関数呼び出しでPanelContainer作成

#### Step 3: UI構築処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | popup関数（371-437行目）でパネル作成とスタイル適用 |

**主要処理フロー**:
- **373行目**: PanelContainer作成
- **376-388行目**: severity別のスタイル適用（INFOはinfo_panel_style_background）
- **396-402行目**: HBoxContainerとコンテンツ追加
- **405-420行目**: コピー/閉じるボタン追加

#### Step 4: スタイルとテーマを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | コンストラクタ（570-644行目）でスタイル初期化 |
| 4-2 | editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | NOTIFICATION_THEME_CHANGED処理（111-141行目） |

**主要処理フロー**:
- **582-583行目**: info_panel_style_backgroundのインスタンス化と角丸設定
- **120-123行目**: テーマ変更時の背景色設定

### プログラム呼び出し階層図

```
EditorInterface::get_editor_toaster()
    │
    └─ EditorToaster::popup_str(message, SEVERITY_INFO, tooltip)
           │
           └─ MessageQueue::push_callable()
                  │
                  └─ EditorToaster::_popup_str(message, severity, tooltip)
                         │
                         ├─ 既存トースト検索
                         │      └─ Toast::count++（重複時）
                         │
                         └─ EditorToaster::popup(control, severity, time, tooltip)
                                │
                                ├─ PanelContainer作成
                                │      └─ スタイル適用（info_panel_style_background）
                                │
                                ├─ HBoxContainer作成
                                │      ├─ Label追加
                                │      ├─ copy_button追加
                                │      └─ close_button追加
                                │
                                └─ _auto_hide_or_free_toasts()
                                       └─ _update_vbox_position()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

message(String)  ───▶  popup_str()  ───▶  Toast構造体
                              │
tooltip(String)  ───▶        │      ───▶  PanelContainer
                              │                  │
SEVERITY_INFO    ───▶  _popup_str()              │
                              │                  ▼
                              │           VBoxContainer
                              │                  │
                       popup()                   ▼
                              │           エディタUI表示
                              ▼
                    StyleBoxFlat適用
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| editor_toaster.h | `editor/gui/editor_toaster.h` | ソース | EditorToasterクラス定義、Toast構造体定義 |
| editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | ソース | EditorToaster実装、通知表示ロジック |
| editor_interface.h | `editor/editor_interface.h` | ソース | EditorInterface定義（get_editor_toaster提供） |
| editor_interface.cpp | `editor/editor_interface.cpp` | ソース | EditorInterface実装 |
| EditorToaster.xml | `doc/classes/EditorToaster.xml` | ドキュメント | APIドキュメント定義 |
| style_box_flat.h | `scene/resources/style_box_flat.h` | ソース | 背景スタイル定義 |
