# 通知設計書 10-OS.alert

## 概要

本ドキュメントは、Godotエンジンの@GlobalScope OSクラスにおけるalert()メソッドの設計仕様を記述する。

### 本通知の処理概要

OS.alert()は、ホストプラットフォームのネイティブダイアログボックスを使用してモーダルアラートメッセージを表示するための関数である。ユーザーがダイアログを閉じるまでアプリケーションの実行がブロックされる。

**業務上の目的・背景**：ゲームやアプリケーションにおいて、ユーザーに対して重要なメッセージを確実に伝達し、確認を得る必要がある場合がある。例えば、致命的なエラーの発生、ライセンス違反の警告、データ消失の確認など、ユーザーが必ず認識すべき情報をネイティブUIで表示する。OS.alertはプラットフォームのネイティブダイアログを使用するため、OSレベルでの確実な表示が保証される。

**通知の送信タイミング**：GDScriptまたはC++コードからOS.alert()メソッドが明示的に呼び出されたとき。アラートメッセージとタイトル（オプション）を引数として受け取る。

**通知の受信者**：アプリケーションを使用しているエンドユーザー。ネイティブダイアログはOSによって管理され、ウィンドウの最前面に表示される。

**通知内容の概要**：アラートメッセージ（本文）、ダイアログタイトル（デフォルト: "ALERT!"）、OKボタン（プラットフォーム依存）が含まれる。

**期待されるアクション**：ユーザーはアラートメッセージを読み、理解した上でOKボタンをクリックしてダイアログを閉じる。ダイアログが閉じられるまでアプリケーションは待機状態となる。

## 通知種別

OS/システム通知（ネイティブモーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ブロッキング） |
| 優先度 | 最高（モーダルダイアログ） |
| リトライ | 無 |

### 送信先決定ロジック

- プラットフォーム固有のネイティブダイアログAPI経由で表示される
- macOS: NSAlert
- Windows: MessageBox
- Linux: GTK/Qt/Zenityなど（利用可能なもの）
- 非GUI環境: stderr出力へのフォールバック

## 通知テンプレート

### ネイティブダイアログの場合

| 項目 | 内容 |
|-----|------|
| タイトル | p_title引数（デフォルト: "ALERT!"） |
| メッセージ | p_alert引数 |
| ボタン | OK（プラットフォーム依存） |
| モダリティ | モーダル（アプリケーションブロック） |

### フォールバック出力

```
{title}: {alert}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| alert | アラートメッセージ | alert()第1引数 | Yes |
| title | ダイアログタイトル | alert()第2引数（デフォルト: "ALERT!"） | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | OS.alert(message, title) | 常時 | GDScriptからの直接呼び出し |
| C++呼び出し | OS::get_singleton()->alert() | 常時 | C++からの直接呼び出し |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ヘッドレスモード | DisplayServerが無効な場合はstderr出力のみ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[OS.alert呼び出し] --> B{プラットフォームは?}
    B -->|macOS| C[NSAlert表示]
    B -->|Windows| D[MessageBox表示]
    B -->|Linux| E[GTK/Qt Dialog表示]
    B -->|その他/非GUI| F[stderr出力]
    C --> G[ユーザーがOKクリック]
    D --> G
    E --> G
    G --> H[ダイアログ閉じる]
    H --> I[処理再開]
    F --> I
    I --> J[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし（データベースは使用しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ネイティブダイアログ不可 | GUIなし環境 | stderr出力にフォールバック |
| 空メッセージ | p_alertが空 | 空ダイアログ表示（有効） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| レート制限 | なし（モーダルなので実質的に連続表示不可） |
| キュー | なし（即時表示） |

### 配信時間帯

制限なし（常時）

## セキュリティ考慮事項

- アラートメッセージはユーザーに直接表示されるため、機密情報を含めないよう注意
- ユーザー入力をそのままアラートに表示する場合、悪意のある文字列に注意
- モーダルダイアログはUI詐称に悪用される可能性があるため、信頼できる文脈でのみ使用

## 備考

- OS.alertは同期的であり、ダイアログが閉じるまでGDScriptの実行がブロックされる
- ゲームループ中の使用は推奨されない（フレームレート低下の原因）
- 起動時のエラー通知や終了前の確認に適している
- プラットフォームによってダイアログの見た目が異なる
- デフォルトタイトルは"ALERT!"

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: APIインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | core_bind.h | `core/core_bind.h` | CoreBind::OS::alert宣言（204行目） |
| 1-2 | core_bind.cpp | `core/core_bind.cpp` | CoreBind::OS::alert実装（335-337行目） |

**読解のコツ**: CoreBind::OS::alertはGDScriptにバインドされるクラス。内部でOS::get_singleton()->alert()を呼び出す。

#### Step 2: 基底実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | os.h | `core/os/os.h` | OS::alert宣言（169行目） |
| 2-2 | os.cpp | `core/os/os.cpp` | OS::alert基底実装（152-154行目） |

**主要処理フロー**:
1. **152行目**: OS::alert関数定義
2. **153行目**: fprintf(stderr, "%s: %s\n", ...) でフォールバック出力

#### Step 3: プラットフォーム固有実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | os_macos.mm | `platform/macos/os_macos.mm` | macOS固有のalert実装 |

**主要処理フロー**:
- NSAlertを使用したネイティブダイアログ表示
- アプリケーションのフォーカス取得
- モーダル表示

#### Step 4: GDScriptバインディングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | core_bind.cpp | `core/core_bind.cpp` | _bind_methodsでのalertバインド |

### プログラム呼び出し階層図

```
OS.alert(message, title)  [GDScript]
    │
    └─ CoreBind::OS::alert(p_alert, p_title)
           │
           └─ ::OS::get_singleton()->alert(p_alert, p_title)
                  │
                  ├─ [基底実装] fprintf(stderr, "%s: %s\n", ...)
                  │
                  └─ [プラットフォーム固有オーバーライド]
                         │
                         ├─ [macOS] NSAlert
                         │      │
                         │      ├─ setMessageText
                         │      ├─ setInformativeText
                         │      └─ runModal
                         │
                         ├─ [Windows] MessageBoxW
                         │      │
                         │      └─ MB_OK | MB_ICONEXCLAMATION
                         │
                         └─ [Linux] GTK/Qt Dialog
```

### データフロー図

```
[入力]                    [処理]                           [出力]

p_alert(String)  ───▶  CoreBind::OS::alert()
                              │
p_title(String)  ───▶        │
                              │
                       ::OS::alert()
                              │
                    ┌─────────┼─────────┐
                    ▼         ▼         ▼
              [macOS]    [Windows]   [Linux]
                 │           │          │
            NSAlert    MessageBox  GTK Dialog
                 │           │          │
                 ▼           ▼          ▼
            ネイティブ  ネイティブ  ネイティブ
            ダイアログ  ダイアログ  ダイアログ
                 │           │          │
                 └─────┬─────┴──────────┘
                       ▼
                [ユーザーがOKクリック]
                       │
                       ▼
                  処理再開
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| core_bind.h | `core/core_bind.h` | ソース | CoreBind::OS::alert宣言 |
| core_bind.cpp | `core/core_bind.cpp` | ソース | CoreBind::OS::alert実装、GDScriptバインディング |
| os.h | `core/os/os.h` | ソース | OS::alert基底クラス宣言 |
| os.cpp | `core/os/os.cpp` | ソース | OS::alert基底実装（stderrフォールバック） |
| os_macos.mm | `platform/macos/os_macos.mm` | ソース | macOS固有のNSAlert実装 |
| os_windows.cpp | `platform/windows/os_windows.cpp` | ソース | Windows固有のMessageBox実装 |
| os_linuxbsd.cpp | `platform/linuxbsd/os_linuxbsd.cpp` | ソース | Linux/BSD固有の実装 |
