# 通知設計書 12-window_request_attention

## 概要

本ドキュメントは、Godotエンジンにおける `window_request_attention` メソッドの設計と実装について記述する。このメソッドは、ウィンドウのタイトルバーとタスクバーを点滅させて、ユーザーの注意を引くためのOS/システム通知機構である。

### 本通知の処理概要

`window_request_attention` は、DisplayServerが提供するウィンドウ管理APIの一部で、アプリケーションがバックグラウンドにある際にユーザーの注意を引くための視覚的なフィードバックを提供する。タスクバーやタイトルバーを点滅させることで、重要なイベントや処理完了をユーザーに通知する。

**業務上の目的・背景**：アプリケーションがフォーカスを持っていない状態で、ユーザーに重要なイベント（ダウンロード完了、エラー発生、メッセージ受信など）を通知する必要がある場合に使用される。ウィンドウを強制的にフォアグラウンドに持ってくるのではなく、ユーザーの作業を妨げずに通知を行うことで、より良いユーザー体験を提供する。

**通知の送信タイミング**：開発者がスクリプトから `DisplayServer.window_request_attention()` を明示的に呼び出した時に発動する。典型的な使用例は、長時間のバックグラウンド処理が完了した時、エラーや警告が発生した時、リアルタイム通信でメッセージを受信した時などである。

**通知の受信者**：通知の受信者は、物理的にコンピュータの前にいるエンドユーザーである。OSのウィンドウマネージャーを通じて視覚的なフィードバック（タスクバーの点滅、ウィンドウ枠のハイライトなど）が表示される。

**通知内容の概要**：視覚的な点滅効果のみで、テキストやその他のメッセージは含まれない。通知の具体的な表現（点滅回数、持続時間、色など）はOSとウィンドウマネージャーによって異なる。

**期待されるアクション**：ユーザーは点滅に気づき、該当するウィンドウをクリックしてアプリケーションをフォアグラウンドに持ってくることが期待される。

## 通知種別

OS/システム通知（ウィンドウ注意要求）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

対象ウィンドウはWindowIDパラメータで指定される。デフォルトはMAIN_WINDOW_ID（0）でメインウィンドウが対象となる。サブウィンドウを指定する場合は、該当するWindowIDを渡す。

## 通知テンプレート

### API定義

```cpp
virtual void window_request_attention(WindowID p_window = MAIN_WINDOW_ID) = 0;
```

### GDScript使用例

```gdscript
# メインウィンドウの注意を要求
DisplayServer.window_request_attention()

# 特定のウィンドウの注意を要求
DisplayServer.window_request_attention(sub_window_id)

# 長時間処理後の通知例
func _on_download_completed():
    if not get_window().has_focus():
        DisplayServer.window_request_attention()
    # ダウンロード完了の処理...
```

### パラメータ

| パラメータ名 | 型 | デフォルト値 | 説明 |
|------------|-----|------------|------|
| p_window | WindowID (int) | MAIN_WINDOW_ID (0) | 対象ウィンドウのID |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| p_window | 対象ウィンドウID | 呼び出し元パラメータ | No（デフォルト: MAIN_WINDOW_ID） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スクリプト呼び出し | DisplayServer.window_request_attention() | なし | 開発者が明示的に呼び出し |
| 長時間処理完了 | バックグラウンドタスク終了 | ウィンドウがフォーカスを持っていない | ユーザーへの処理完了通知 |
| エラー/警告発生 | アプリケーションエラー | 重要度が高い場合 | ユーザーへの緊急通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ウィンドウが既にフォーカスを持っている | 点滅の必要がない（一部OSでは無視される） |
| ヘッドレスモード | DisplayServerが存在しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[window_request_attention呼び出し] --> B{WindowID有効?}
    B -->|Yes| C[プラットフォーム固有実装呼び出し]
    B -->|No| D[エラー/無視]
    C --> E{OS種別}
    E -->|Windows| F[FlashWindowEx API]
    E -->|macOS| G[requestUserAttention]
    E -->|Linux/X11| H[_NET_WM_STATE_DEMANDS_ATTENTION]
    E -->|Linux/Wayland| I[xdg_activation_v1]
    F --> J[タスクバー点滅]
    G --> K[Dockアイコンバウンス]
    H --> L[タスクバー点滅]
    I --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（window_request_attentionはデータベースを使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 無効なWindowID | 存在しないウィンドウIDが指定された | 何も起こらない（静かに失敗） |
| ヘッドレスモード | DisplayServerが利用不可 | 何も起こらない |
| プラットフォーム未サポート | 特定のウィンドウマネージャーで未対応 | 何も起こらない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | OS依存（頻繁な呼び出しは推奨されない） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ただしOS側でDo Not Disturbモードが有効な場合は抑制される可能性あり）

## セキュリティ考慮事項

- 悪意のある使用を防ぐため、頻繁な呼び出しは避けるべき
- ユーザー体験を損なわないよう、本当に必要な場面でのみ使用すること
- 一部のOSでは、フォーカスを持たないアプリケーションの注意要求を制限している

## 備考

- 各OSで点滅の動作が異なる：
  - Windows: タスクバーボタンがオレンジ色に点滅
  - macOS: Dockアイコンがバウンス
  - Linux (X11): _NET_WM_STATE_DEMANDS_ATTENTIONヒント設定
  - Linux (Wayland): xdg_activation_v1プロトコル使用
- window_is_focused()と組み合わせて、フォーカス状態を確認してから呼び出すことを推奨

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: インターフェース定義を理解する

DisplayServerの抽象インターフェースを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | display_server.h | `servers/display/display_server.h` | window_request_attention の純粋仮想関数宣言 |

**読解のコツ**: `= 0` で純粋仮想関数として宣言されており、各プラットフォームで必ず実装が必要。

#### Step 2: プラットフォーム固有実装を理解する

各プラットフォームの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | display_server_windows.cpp | `platform/windows/display_server_windows.cpp` | Windows実装（FlashWindowEx） |
| 2-2 | display_server_macos.mm | `platform/macos/display_server_macos.mm` | macOS実装（requestUserAttention） |
| 2-3 | display_server_x11.cpp | `platform/linuxbsd/x11/display_server_x11.cpp` | X11実装 |
| 2-4 | display_server_wayland.cpp | `platform/linuxbsd/wayland/display_server_wayland.cpp` | Wayland実装 |

**主要処理フロー**:
- **display_server.h 512行目**: `virtual void window_request_attention(WindowID p_window = MAIN_WINDOW_ID) = 0;`

#### Step 3: Windowクラスでのラッパーを理解する

高レベルAPIとしてのWindowクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | window.cpp | `scene/main/window.cpp` | request_attention()ラッパーメソッド |

### プログラム呼び出し階層図

```
スクリプト呼び出し
    │
    ├─ Window::request_attention() [オプション]
    │      └─ DisplayServer::window_request_attention()
    │
    └─ DisplayServer::window_request_attention() [直接呼び出し]
           │
           ├─ [Windows] DisplayServerWindows::window_request_attention()
           │      └─ FlashWindowEx()
           │
           ├─ [macOS] DisplayServerMacOS::window_request_attention()
           │      └─ [NSApp requestUserAttention:]
           │
           ├─ [X11] DisplayServerX11::window_request_attention()
           │      └─ XChangeProperty(_NET_WM_STATE_DEMANDS_ATTENTION)
           │
           └─ [Wayland] DisplayServerWayland::window_request_attention()
                  └─ xdg_activation_v1_get_activation_token()
```

### データフロー図

```
[入力]                         [処理]                              [出力]

GDScript/C++呼び出し
(DisplayServer.            ───▶ DisplayServer                  ───▶ OS API呼び出し
window_request_attention())     抽象インターフェース
                                    │
                                    ├─▶ Windows: FlashWindowEx ───▶ タスクバー点滅
                                    │
                                    ├─▶ macOS: requestUserAttention ───▶ Dockバウンス
                                    │
                                    └─▶ Linux: X11/Wayland API ───▶ タスクバー点滅
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| display_server.h | `servers/display/display_server.h` | ヘッダ | 抽象インターフェース定義 |
| display_server.cpp | `servers/display/display_server.cpp` | ソース | デフォルト実装 |
| display_server_windows.h | `platform/windows/display_server_windows.h` | ヘッダ | Windows固有宣言 |
| display_server_windows.cpp | `platform/windows/display_server_windows.cpp` | ソース | Windows固有実装 |
| display_server_macos.h | `platform/macos/display_server_macos.h` | ヘッダ | macOS固有宣言 |
| display_server_macos.mm | `platform/macos/display_server_macos.mm` | ソース | macOS固有実装 |
| display_server_x11.h | `platform/linuxbsd/x11/display_server_x11.h` | ヘッダ | X11固有宣言 |
| display_server_x11.cpp | `platform/linuxbsd/x11/display_server_x11.cpp` | ソース | X11固有実装 |
| display_server_wayland.h | `platform/linuxbsd/wayland/display_server_wayland.h` | ヘッダ | Wayland固有宣言 |
| display_server_wayland.cpp | `platform/linuxbsd/wayland/display_server_wayland.cpp` | ソース | Wayland固有実装 |
| window.cpp | `scene/main/window.cpp` | ソース | Windowクラスラッパー |
| DisplayServer.xml | `doc/classes/DisplayServer.xml` | ドキュメント | APIリファレンス |
