# 通知設計書 13-AcceptDialog confirmed

## 概要

本ドキュメントは、Godotエンジンにおける `AcceptDialog` クラスの `confirmed` シグナルの設計と実装について記述する。このシグナルは、ダイアログでOKボタンが押された時に発火し、ユーザーの確認アクションを通知する基本的なダイアログ通知機構である。

### 本通知の処理概要

`confirmed` シグナルは、AcceptDialogおよびその派生クラス（ConfirmationDialogなど）において、ユーザーがOKボタンを押したことを通知するために使用される。これはGUI上でのユーザー操作に対するフィードバックの一環として、アプリケーションロジックとUIの疎結合を実現する。

**業務上の目的・背景**：ゲームやアプリケーション開発において、ユーザーに情報を提示し、その確認を得る必要がある場面は非常に多い。例えば、ゲームの設定変更確認、ファイル操作の確認、重要な通知の受諾など。confirmedシグナルは、これらの場面でユーザーの「OK」という意思表示を受け取り、適切な後続処理を実行するための仕組みである。

**通知の送信タイミング**：confirmedシグナルは、以下の状況で発火する。(1) ユーザーがOKボタンをクリックした時、(2) register_text_enter()で登録されたLineEditでEnterキーが押された時（OKボタンが無効でない場合）、(3) _ok_pressed()メソッドが呼び出された時。

**通知の受信者**：confirmedシグナルに `connect()` メソッドで接続されたすべてのCallable（関数、メソッド、ラムダ）が受信者となる。通常はダイアログを表示したスクリプトや、親ノードがシグナルを購読する。

**通知内容の概要**：confirmedシグナルはパラメータを持たない単純なシグナルである。ユーザーがOKを押したという事実のみを伝達し、追加のデータは含まない。必要に応じて、シグナル発火後にダイアログの状態や入力値を取得する。

**期待されるアクション**：受信者は、ユーザーが確認したアクションを実行する。例えば、設定の保存、ファイルの削除、ゲームの開始など、ダイアログで確認を求めていた操作を実際に行う。

## 通知種別

ダイアログ通知（UIシグナル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

シグナル接続による。AcceptDialogの `confirmed` シグナルに `connect()` メソッドで接続されたすべてのCallableが受信者となる。

## 通知テンプレート

### シグナル定義

```cpp
ADD_SIGNAL(MethodInfo("confirmed"));
```

| 項目 | 内容 |
|-----|------|
| シグナル名 | confirmed |
| パラメータ | なし |
| 戻り値 | なし |

### GDScript使用例

```gdscript
extends Control

func _ready():
    var dialog = AcceptDialog.new()
    dialog.dialog_text = "処理を続行しますか？"
    add_child(dialog)
    dialog.confirmed.connect(_on_dialog_confirmed)
    dialog.popup_centered()

func _on_dialog_confirmed():
    print("ユーザーがOKを押しました")
    # 確認後の処理を実行
    _execute_confirmed_action()

func _execute_confirmed_action():
    # 実際のビジネスロジック
    pass
```

### カスタムダイアログでの使用例

```gdscript
extends ConfirmationDialog

func _ready():
    dialog_text = "本当に削除しますか？"
    confirmed.connect(_on_confirmed)
    canceled.connect(_on_canceled)

func _on_confirmed():
    # 削除処理を実行
    delete_item()

func _on_canceled():
    # キャンセル時の処理
    pass
```

## テンプレート変数

confirmedシグナルはパラメータを持たないため、テンプレート変数は存在しない。

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | OKボタンクリック | なし | ユーザーがOKボタンを押した時 |
| ユーザー操作 | LineEditでEnter | OKボタンが有効 | register_text_enter()で登録されたLineEditでEnter |
| プログラム | _ok_pressed()呼び出し | なし | 内部または派生クラスからの呼び出し |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| OKボタンが無効 | is_disabled()がtrueの場合、_text_submittedでの発火が抑止される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[OKボタンクリック] --> B[_ok_pressed呼び出し]
    C[LineEditでEnter] --> D{OKボタン有効?}
    D -->|Yes| B
    D -->|No| E[処理なし]
    B --> F{hide_on_ok?}
    F -->|Yes| G[ダイアログ非表示]
    F -->|No| H[表示継続]
    G --> I[ok_pressed仮想関数]
    H --> I
    I --> J[emit_signal confirmed]
    J --> K[set_input_as_handled]
    K --> L[接続されたハンドラ実行]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（AcceptDialogはデータベースを使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| シグナル未接続 | confirmedシグナルにハンドラが接続されていない | シグナルは発火するが何も起こらない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- confirmedシグナルは、ユーザーの明示的なアクション（OKボタンクリック）に基づいて発火する
- 重要な操作の前には、ConfirmationDialogを使用してユーザーの確認を得ることを推奨
- シグナルハンドラ内で長時間のブロッキング処理を行わないこと

## 備考

- AcceptDialogはWindowを継承しており、モーダルダイアログとして動作する
- hide_on_okプロパティでOK時の自動非表示を制御可能
- ok_button_textプロパティでOKボタンのテキストをカスタマイズ可能
- 派生クラスでok_pressed()仮想関数をオーバーライドすることで、確認時の追加処理を実装可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: クラス構造を理解する

AcceptDialogのクラス定義と継承関係を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | dialogs.h | `scene/gui/dialogs.h` | AcceptDialogクラス定義、Windowからの継承を確認 |

**読解のコツ**: AcceptDialogはWindowを継承しており、ダイアログとしての基本機能を提供する。

#### Step 2: シグナル発火ロジックを理解する

confirmedシグナルがどのように発火されるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dialogs.cpp | `scene/gui/dialogs.cpp` | _ok_pressed()関数、emit_signal呼び出しを確認 |

**主要処理フロー**:
1. **134-142行目**: _ok_pressed関数全体
2. **135-138行目**: hide_on_okによる非表示制御
3. **139行目**: ok_pressed()仮想関数呼び出し
4. **140行目**: `emit_signal(SceneStringName(confirmed))`
5. **141行目**: set_input_as_handled()

#### Step 3: シグナル登録を理解する

シグナルがどのように登録されるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | dialogs.cpp | `scene/gui/dialogs.cpp` | _bind_methods()内のADD_SIGNAL |

**主要処理フロー**:
- **430行目**: `ADD_SIGNAL(MethodInfo("confirmed"))`

#### Step 4: OKボタンの接続を理解する

OKボタンとシグナル発火の関係を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | dialogs.cpp | `scene/gui/dialogs.cpp` | コンストラクタでのOKボタン接続 |

**主要処理フロー**:
- **497行目**: `ok_button->connect(SceneStringName(pressed), callable_mp(this, &AcceptDialog::_ok_pressed))`

### プログラム呼び出し階層図

```
ユーザーアクション
    │
    ├─ OKボタンクリック
    │      └─ Button::pressed シグナル
    │             └─ AcceptDialog::_ok_pressed()
    │
    └─ LineEditでEnter
           └─ AcceptDialog::_text_submitted()
                  └─ AcceptDialog::_ok_pressed()
                         │
                         ├─ hide_on_ok判定
                         │      └─ set_visible(false)
                         │
                         ├─ ok_pressed() [仮想関数]
                         │
                         ├─ emit_signal("confirmed")
                         │      └─ 接続されたハンドラ実行
                         │
                         └─ set_input_as_handled()
```

### データフロー図

```
[入力]                         [処理]                              [出力]

OKボタンクリック      ───▶ Button::pressed            ───▶ _ok_pressed()
                                                            │
LineEditでEnter       ───▶ _text_submitted()         ───▶ _ok_pressed()
                                                            │
                                                            ├─▶ ダイアログ非表示（hide_on_ok時）
                                                            │
                                                            ├─▶ ok_pressed()仮想関数
                                                            │
                                                            └─▶ confirmedシグナル発火
                                                                   │
                                                                   └─▶ シグナルハンドラ実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dialogs.h | `scene/gui/dialogs.h` | ヘッダ | AcceptDialogクラス定義 |
| dialogs.cpp | `scene/gui/dialogs.cpp` | ソース | AcceptDialogクラス実装 |
| window.h | `scene/main/window.h` | ヘッダ | 基底クラスWindow定義 |
| window.cpp | `scene/main/window.cpp` | ソース | 基底クラスWindow実装 |
| button.h | `scene/gui/button.h` | ヘッダ | OKボタンのButton定義 |
| AcceptDialog.xml | `doc/classes/AcceptDialog.xml` | ドキュメント | APIリファレンス |
