# 通知設計書 2-EditorToaster WARNING

## 概要

本ドキュメントは、Godotエンジンのエディタ内で表示されるWARNINGレベルのトースト通知（EditorToaster WARNING）の設計仕様を記述する。

### 本通知の処理概要

EditorToaster WARNINGは、Godotエディタ内でユーザーに警告レベルのメッセージを視覚的に通知するためのトースト通知機能である。エディタUI右下に一時的に表示されるポップアップ形式の通知で、左側に警告色の境界線が表示され、5秒後に自動的にフェードアウトする。

**業務上の目的・背景**：ゲーム開発中に発生する非致命的だが注意が必要な問題（非推奨APIの使用、パフォーマンス上の懸念、設定の不整合など）を開発者に即座に通知する必要がある。WARNING通知はINFOよりも目立つ黄色/オレンジ系の境界線で表示され、開発者の注意を引きつつも作業を中断しない形で問題を伝達する。

**通知の送信タイミング**：EditorToasterのpush_toastメソッドがSEVERITY_WARNING引数で呼び出されたとき、またはエラーハンドラからERR_HANDLER_WARNING型でp_editor_notify=trueが設定された場合に通知が送信される。WARN_PRINT_EDマクロ経由でも通知される。

**通知の受信者**：Godotエディタを使用している開発者。通知はエディタウィンドウ内のUI要素として表示されるため、エディタを操作中のユーザーのみが受信者となる。

**通知内容の概要**：警告メッセージ文字列、警告色（warning_color）の左境界線、オプションのツールチップ（ファイルパスや行番号などの詳細情報）、コピーボタン、閉じるボタンが含まれる。

**期待されるアクション**：ユーザーは警告内容を確認し、必要に応じて原因となるコードや設定を修正する。問題が軽微な場合は通知を無視するか閉じることができる。

## 通知種別

アプリ内通知（エディタUI内トースト通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（MessageQueue経由で遅延呼び出し） |
| 優先度 | 中（WARNING severity = 1） |
| リトライ | 無 |

### 送信先決定ロジック

EditorToasterはシングルトンパターンで実装されており、常にエディタの単一インスタンスに対して通知が送信される。送信先はエディタUIのHBoxContainer内に動的に追加されるVBoxContainerである。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | エディタウィンドウ右下 |
| 背景色 | エディタテーマのbase_colorとmono_colorの補間色 |
| 境界線 | 左側に警告色（warning_color）のボーダー |
| 表示時間 | 5秒（default_message_duration） |

### 本文テンプレート

```
[警告メッセージテキスト] [コピーボタン] [閉じるボタン]
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | 警告メッセージ | push_toast引数 | Yes |
| tooltip | ツールチップテキスト | push_toast引数 | No |
| severity | 重要度レベル | SEVERITY_WARNING定数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | push_toast(message, SEVERITY_WARNING) | 常時 | GDScriptまたはC++からの直接呼び出し |
| エラーハンドラ | _error_handler | p_type=ERR_HANDLER_WARNING かつ p_editor_notify=true | エラーマクロからの警告通知 |
| マクロ | WARN_PRINT_ED | 常時 | エディタ通知付き警告マクロ |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| is_processing_error | エラー処理中の再帰呼び出し防止 |
| vbox_container非表示 | 通知が無効化されている場合 |
| max_temporary_count超過 | 一時通知が5件を超える場合は古いものから非表示 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[push_toast呼び出し] --> B{is_processing_error?}
    B -->|Yes| Z[処理スキップ]
    B -->|No| C[MessageQueue経由で_popup_str呼び出し]
    C --> D{同一メッセージ存在?}
    D -->|Yes| E[既存トーストのカウント増加]
    D -->|No| F[新規PanelContainer作成]
    F --> G[warning_panel_style_background適用]
    G --> H[左ボーダーにwarning_color設定]
    H --> I[HBoxContainer内にLabel追加]
    I --> J[コピー/閉じるボタン追加]
    J --> K[VBoxContainerに追加]
    K --> L[_auto_hide_or_free_toasts実行]
    L --> M[位置更新・描画]
    E --> L
    M --> N[5秒後自動フェードアウト]
    N --> O[終了]
    Z --> O
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし（データベースは使用しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 再帰呼び出し | is_processing_errorがtrue | 処理をスキップ |
| シングルトン未初期化 | EditorToaster::get_singleton()がnull | 処理をスキップ |
| ツリー外 | is_inside_tree()がfalse | 処理をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 同時表示上限 | 5件（max_temporary_count） |
| 保持上限 | 10件（max_temporary_count * 2） |

### 配信時間帯

制限なし（エディタ動作中は常時）

## セキュリティ考慮事項

- 通知内容はエディタ内でのみ表示され、外部に送信されない
- メッセージ内容のサニタイズは呼び出し元の責任
- クリップボードへのコピー機能はユーザー操作が必要

## 備考

- WARNINGはSEVERITY値1で、INFOより優先度が高い
- 同一メッセージが連続する場合はカウント表示される
- マウスホバー中は自動消去タイマーが一時停止される
- メインボタンの通知インジケーターは最高severity（WARNING > INFO）の色で表示される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

EditorToasterの内部データ構造であるToast構造体とSeverity列挙型を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | editor_toaster.h | `editor/gui/editor_toaster.h` | Severity列挙型（43-47行目）でSEVERITY_WARNING=1を確認 |
| 1-2 | editor_toaster.h | `editor/gui/editor_toaster.h` | warning_panel_style_background（55行目）の定義 |

**読解のコツ**: SEVERITY_WARNINGは値1であり、SEVERITY_INFO（0）より優先度が高く、SEVERITY_ERROR（2）より低い。

#### Step 2: スタイル設定を理解する

WARNINGレベル固有のスタイル設定を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | コンストラクタ（585-587行目）でwarning_panel_style_background初期化 |
| 2-2 | editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | NOTIFICATION_THEME_CHANGED（125-127行目）で警告色設定 |

**主要処理フロー**:
1. **585行目**: warning_panel_style_background.instantiate()
2. **586行目**: set_border_width(border_side, stylebox_radius * EDSCALE) で左ボーダー設定
3. **126行目**: set_border_color(warning_color)で警告色適用

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | popup関数（380-381行目）でSEVERITY_WARNINGのスタイル適用 |
| 3-2 | editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | _draw_button（297-298行目）で警告色インジケーター描画 |

**主要処理フロー**:
- **380行目**: case SEVERITY_WARNING分岐
- **381行目**: panel->add_theme_style_override(warning_panel_style_background)
- **297行目**: highest_severityに基づく色選択でwarning_color使用

#### Step 4: エラーハンドラ連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | _error_handler_impl（174, 181行目）でERR_HANDLER_WARNING判定 |
| 4-2 | error_macros.h | `core/error/error_macros.h` | WARN_PRINT_ED（719-720行目）マクロ定義 |

**主要処理フロー**:
- **174行目**: p_type == ERR_HANDLER_WARNINGの場合の処理
- **181行目**: severityをSEVERITY_WARNINGに設定

### プログラム呼び出し階層図

```
WARN_PRINT_ED(message)
    │
    └─ _err_print_error(..., true, ERR_HANDLER_WARNING)
           │
           └─ ErrorHandlerList::errfunc (EditorToaster::_error_handler)
                  │
                  └─ _error_handler_impl(file, line, error, errorexp, true, WARNING)
                         │
                         └─ EditorToaster::popup_str(err_str, SEVERITY_WARNING, tooltip_str)
                                │
                                └─ _popup_str(message, SEVERITY_WARNING, tooltip)
                                       │
                                       └─ popup(control, SEVERITY_WARNING, time, tooltip)
                                              │
                                              └─ warning_panel_style_background適用
```

### データフロー図

```
[入力]                    [処理]                           [出力]

message(String)  ───▶  popup_str()  ───▶  Toast構造体
                              │                  │
tooltip(String)  ───▶        │                  │
                              │                  ▼
SEVERITY_WARNING ───▶  _popup_str()      PanelContainer
                              │                  │
                              │          warning_panel_style適用
                              │                  │
                       popup()                   ▼
                              │           左ボーダー(warning_color)
                              │                  │
                              ▼                  ▼
                    StyleBoxFlat        エディタUI表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| editor_toaster.h | `editor/gui/editor_toaster.h` | ソース | EditorToasterクラス定義、SEVERITY_WARNING定義 |
| editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | ソース | WARNING固有のスタイル設定、通知表示ロジック |
| error_macros.h | `core/error/error_macros.h` | ソース | WARN_PRINT_EDマクロ定義 |
| error_macros.cpp | `core/error/error_macros.cpp` | ソース | _err_print_error実装 |
| EditorToaster.xml | `doc/classes/EditorToaster.xml` | ドキュメント | SEVERITY_WARNING定数のドキュメント |
