# 通知設計書 25-NOTIFICATION_POSTINITIALIZE

## 概要

本ドキュメントは、Godot EngineのObjectクラスにおける`NOTIFICATION_POSTINITIALIZE`通知の設計仕様を記載する。この通知はオブジェクトの初期化が完了した直後に発火し、オブジェクトのライフサイクルにおいて最初に発行される通知である。

### 本通知の処理概要

NOTIFICATION_POSTINITIALIZEは、Objectおよびそのすべての派生クラスのインスタンス生成時に、コンストラクタの実行完了後に発行されるシステム通知である。この通知はNodeやResourceを含むすべてのObjectの共通初期化ポイントとして機能する。

**業務上の目的・背景**：オブジェクト指向プログラミングにおいて、コンストラクタ内では仮想関数が正しく動作しない場合がある。NOTIFICATION_POSTINITIALIZEは、すべての継承階層のコンストラクタ完了後に呼ばれるため、派生クラスの仮想関数が正しく解決された状態で初期化処理を実行できる。スクリプトやGDExtensionの初期化、シグナル用Mutexの初期化など、オブジェクト構築の最終段階で必要な処理に使用される。

**通知の送信タイミング**：postinitialize_handler()から_postinitialize()が呼ばれた時。具体的にはObject::_postinitialize()内でsignal_mutex（必要な場合）を初期化した後にnotification(NOTIFICATION_POSTINITIALIZE)が呼ばれる。

**通知の受信者**：新しく作成されたすべてのObjectインスタンス（Node、Resource、その他すべての派生クラスを含む）。

**通知内容の概要**：通知IDは整数値0（NOTIFICATION_POSTINITIALIZE = 0）。追加のパラメータは含まない。

**期待されるアクション**：
- スクリプトインスタンスの初期化処理
- GDExtensionインスタンスの追加初期化
- アクセシビリティ要素の作成
- オブジェクト固有の初期設定

## 通知種別

エンジン内部通知（Engine Internal Notification）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 最高（オブジェクト初期化時に必ず発行） |
| リトライ | 無し |

### 送信先決定ロジック

1. Object派生クラスのインスタンスが生成される
2. すべてのコンストラクタ（基底→派生）が実行される
3. postinitialize_handler(obj)が呼ばれる
4. Object::_postinitialize()が実行される
5. signal_mutexが初期化される（_uses_signal_mutex()がtrueの場合）
6. notification(NOTIFICATION_POSTINITIALIZE)が送信される

## 通知テンプレート

### システム通知の場合

| 項目 | 内容 |
|-----|------|
| 通知ID | 0 |
| 通知名 | NOTIFICATION_POSTINITIALIZE |
| 定義箇所 | core/object/object.h |

### 通知ハンドリング例

```cpp
void MyObject::_notification(int p_notification) {
    switch (p_notification) {
        case NOTIFICATION_POSTINITIALIZE: {
            // オブジェクト初期化完了後の処理
            _initialize_custom_data();
        } break;
    }
}
```

```gdscript
func _notification(what):
    if what == NOTIFICATION_POSTINITIALIZE:
        # オブジェクト初期化完了後の処理
        _initialize_custom_data()
```

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| p_notification | 通知ID（0） | エンジン内部 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | Object::_postinitialize() | 常に | オブジェクト構築完了時 |
| 内部処理 | postinitialize_handler(obj) | 常に | ObjectDBへの登録後 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | すべてのObjectインスタンスに常に送信される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Object派生クラスのnew/instantiate] --> B[コンストラクタ実行\n基底クラス→派生クラス]
    B --> C[postinitialize_handler呼び出し]
    C --> D[Object::_postinitialize]
    D --> E{_uses_signal_mutex?}
    E -->|Yes| F[signal_mutex = memnew\Mutex\]
    E -->|No| G[スキップ]
    F --> H[notification\nNOTIFICATION_POSTINITIALIZE\]
    G --> H
    H --> I[派生クラスの_notification処理]
    I --> J[スクリプトの_notification処理]
    J --> K[オブジェクト使用可能]
```

## データベース参照・更新仕様

### 参照データ一覧

| データ | 用途 | 備考 |
|--------|------|------|
| _uses_signal_mutex() | signal_mutex初期化判定 | 仮想関数、デフォルトfalse |

### 更新データ一覧

| データ | 操作 | 概要 |
|--------|------|------|
| Object::signal_mutex | 初期化 | Mutexポインタの割り当て（必要な場合） |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| メモリ不足 | signal_mutex割り当て失敗 | クラッシュ（致命的エラー） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（オブジェクト生成時にいつでも発生）

## セキュリティ考慮事項

- この通知はエンジン内部でのみ使用され、外部からの直接呼び出しは想定されていない
- スクリプトからnotification()を直接呼び出すことは可能だが、通常は不要

## 備考

- 通知ID = 0 であり、すべての通知の中で最も基本的な通知
- Nodeの場合、NOTIFICATION_ENTER_TREEよりも前に発火する
- すべてのコンストラクタ完了後に呼ばれるため、仮想関数が正しく動作する
- GDScriptでも直接ハンドリング可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Object基底クラスの定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | object.h | `core/object/object.h` | NOTIFICATION_POSTINITIALIZE定数の定義（855行目） |
| 1-2 | object.h | `core/object/object.h` | _postinitialize()宣言（651行目） |
| 1-3 | object.h | `core/object/object.h` | signal_mutexメンバ変数（642行目） |

**読解のコツ**: NOTIFICATION_POSTINITIALIZE = 0であり、最も小さいID値を持つ通知であることを確認。

#### Step 2: エントリーポイントを理解する

処理の起点となる関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | object.cpp | `core/object/object.cpp` | _postinitialize関数（328-333行目） |
| 2-2 | object_db.h | `core/object/object_db.h` | postinitialize_handler関数の呼び出し |

**主要処理フロー**:
1. **329-331行目**: _uses_signal_mutex()がtrueならsignal_mutexを初期化
2. **332行目**: notification(NOTIFICATION_POSTINITIALIZE)を送信

#### Step 3: 通知ハンドラを理解する

派生クラスでの通知処理例を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | node.cpp | `scene/main/node.cpp` | NodeでのPOSTINITIALIZE処理（アクセシビリティ要素作成） |
| 3-2 | control.cpp | `scene/gui/control.cpp` | ControlでのPOSTINITIALIZE処理 |

### プログラム呼び出し階層図

```
memnew(MyObject) または Object::new(p_class)
    │
    ├─ MyObject::MyObject() [コンストラクタチェーン]
    │      ├─ Object::Object()
    │      ├─ Node::Node()
    │      └─ MyObject固有の初期化
    │
    └─ postinitialize_handler(obj)
           │
           └─ Object::_postinitialize()
                  │
                  ├─ _uses_signal_mutex() チェック
                  │      └─ signal_mutex = memnew(Mutex) [条件付き]
                  │
                  └─ notification(NOTIFICATION_POSTINITIALIZE)
                         │
                         ├─ Object::_notification() [通常は空]
                         │
                         ├─ Node::_notification() [Nodeの場合]
                         │      └─ アクセシビリティ要素作成など
                         │
                         ├─ MyObject::_notification() [派生クラス]
                         │      └─ カスタム初期化
                         │
                         └─ スクリプト::_notification() [スクリプト添付時]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

memnew() ───────────────▶ コンストラクタチェーン ────────▶ オブジェクト構築
       │                       │
       │                       ▼
       │              postinitialize_handler
       │                       │
       │                       ▼
       │              _postinitialize()
       │                       │
       │                       ▼
       │              signal_mutex初期化 [条件付き]
       │                       │
       └───────────────────────┴───────────────────────▶ NOTIFICATION_POSTINITIALIZE
                                                              │
                                                              ▼
                                                        オブジェクト使用可能
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| object.h | `core/object/object.h` | ヘッダー | Object基底クラス定義、通知定数 |
| object.cpp | `core/object/object.cpp` | ソース | _postinitializeの実装 |
| object_db.h | `core/object/object_db.h` | ヘッダー | ObjectDB、postinitialize_handler宣言 |
| object_db.cpp | `core/object/object_db.cpp` | ソース | postinitialize_handlerの実装 |
| node.cpp | `scene/main/node.cpp` | ソース | NodeでのPOSTINITIALIZE処理 |
| control.cpp | `scene/gui/control.cpp` | ソース | ControlでのPOSTINITIALIZE処理 |
| class_db.cpp | `core/object/class_db.cpp` | ソース | クラス登録とインスタンス生成 |
