# 通知設計書 27-NOTIFICATION_EXTENSION_RELOADED

## 概要

本ドキュメントは、Godot EngineのObjectクラスにおける`NOTIFICATION_EXTENSION_RELOADED`通知の設計仕様を記載する。この通知はGDExtensionがリロードされた後に発火し、拡張機能の動的リロード機能をサポートするための通知である。

### 本通知の処理概要

NOTIFICATION_EXTENSION_RELOADEDは、GDExtension（ネイティブコード拡張）がエディタ実行中にリロードされた後、影響を受けるすべてのオブジェクトインスタンスに発行されるシステム通知である。この通知は主にエディタのホットリロード機能のために使用される。

**業務上の目的・背景**：GDExtensionを使用した開発において、開発者はC++やRustなどのネイティブコードで拡張を作成する。開発中にコードを変更するたびにエディタを再起動するのは非効率であるため、Godotはエディタ実行中にGDExtensionをリロードする機能を提供している。NOTIFICATION_EXTENSION_RELOADEDは、リロードが完了し、オブジェクトの状態が復元された後に送信され、オブジェクトがリロード後の追加初期化を行う機会を提供する。

**通知の送信タイミング**：GDExtensionのリロードプロセスが完了した後。具体的には以下の順序で処理が行われる：
1. GDExtensionのアンロード（既存インスタンスの状態保存）
2. ネイティブライブラリのリロード
3. オブジェクトの再初期化（reset_internal_extension）
4. 保存された状態の復元（プロパティの再設定）
5. NOTIFICATION_EXTENSION_RELOADEDの送信

**通知の受信者**：リロードされたGDExtensionクラスのすべてのインスタンス。

**通知内容の概要**：通知IDは整数値2（NOTIFICATION_EXTENSION_RELOADED = 2）。追加のパラメータは含まない。

**期待されるアクション**：
- キャッシュされたデータの再構築
- 内部状態の検証と修正
- UIの更新
- リソースの再読み込み
- シグナル接続の再確立（必要な場合）

## 通知種別

エンジン内部通知（Engine Internal Notification）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 通常 |
| リトライ | 無し |
| 環境 | エディタ実行時のみ（TOOLS_ENABLED） |

### 送信先決定ロジック

1. GDExtensionManagerがextensionのリロードを開始
2. 既存インスタンスの状態（プロパティ値）が保存される
3. ネイティブライブラリがアンロード・リロードされる
4. 保存されたインスタンスに対してreset_internal_extensionが呼ばれる
5. 保存されたプロパティ値が復元される
6. 各インスタンスにNOTIFICATION_EXTENSION_RELOADEDが送信される

## 通知テンプレート

### システム通知の場合

| 項目 | 内容 |
|-----|------|
| 通知ID | 2 |
| 通知名 | NOTIFICATION_EXTENSION_RELOADED |
| 定義箇所 | core/object/object.h |

### 通知ハンドリング例

```cpp
void MyExtensionClass::_notification(int p_notification) {
    switch (p_notification) {
        case NOTIFICATION_EXTENSION_RELOADED: {
            // リロード後の初期化処理
            _rebuild_cached_data();
            _validate_internal_state();
        } break;
    }
}
```

```gdscript
# 注意：GDScriptからは通常使用しない
# この通知はGDExtensionクラス専用
func _notification(what):
    if what == NOTIFICATION_EXTENSION_RELOADED:
        # リロード後の処理
        pass
```

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| p_notification | 通知ID（2） | エンジン内部 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | GDExtension::_finish_reload() | リロード対象のインスタンスのみ | 拡張リロード完了時 |
| エディタ操作 | Build実行後のリロード | extension_reloading_enabled == true | ホットリロード有効時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| !TOOLS_ENABLED | エディタビルドでない場合は機能しない |
| !extension_reloading_enabled | 拡張リロードが無効な場合 |
| オブジェクトが削除済み | ObjectDB::get_instance()がnullを返す場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[GDExtensionリロード開始] --> B[既存インスタンスの状態保存]
    B --> C[instance_state に property 保存]
    C --> D[ネイティブライブラリアンロード]
    D --> E[ネイティブライブラリリロード]
    E --> F[クラス再登録]
    F --> G[各インスタンスへの処理ループ]
    G --> H[reset_internal_extension]
    H --> I[保存されたプロパティ復元]
    I --> J[notification\nNOTIFICATION_EXTENSION_RELOADED\]
    J --> K[instance_state クリア]
    K --> L[リロード完了]
```

## データベース参照・更新仕様

### 参照データ一覧

| データ | 用途 | 備考 |
|--------|------|------|
| Extension::instance_state | インスタンス状態の保存・復元 | HashMap<ObjectID, InstanceState> |
| Extension::instances | リロード対象インスタンスのID一覧 | HashSet<ObjectID> |
| ObjectDB | オブジェクト参照の取得 | ObjectID → Object* |

### 更新データ一覧

| データ | 操作 | 概要 |
|--------|------|------|
| Object::_extension | 再設定 | reset_internal_extensionで更新 |
| Object::_extension_instance | 再設定 | 新しい拡張インスタンスへのポインタ |
| Extension::instance_state | クリア | 通知送信後にクリア |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| インスタンス消失 | ObjectDB::get_instance()がnull | スキップ（continue） |
| 拡張クラス未登録 | リロード失敗 | プレースホルダー拡張を使用 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（エディタ実行中のリロード時のみ発生）

## セキュリティ考慮事項

- この通知はエディタビルド（TOOLS_ENABLED）でのみ有効
- ネイティブコードのリロードは信頼されたソースからのみ許可される
- 不正な拡張がロードされないよう、署名検証が行われる場合がある

## 備考

- 通知ID = 2 で、NOTIFICATION_PREDELETEの次の値
- エディタ開発時のホットリロード機能専用
- GDScriptクラスには影響しない（GDExtensionクラス専用）
- プレースホルダー拡張の場合も通知が送信される
- is_placeholder属性で実際の拡張とプレースホルダーを区別可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

GDExtensionのリロード関連データ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | object.h | `core/object/object.h` | NOTIFICATION_EXTENSION_RELOADED定数の定義（857行目） |
| 1-2 | gdextension.h | `core/extension/gdextension.h` | Extension構造体、InstanceState構造体 |

**読解のコツ**: Extension::instance_stateがリロード時の状態保存に使用されることを理解する。

#### Step 2: エントリーポイントを理解する

リロード処理の起点となる関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | gdextension.cpp | `core/extension/gdextension.cpp` | _finish_reload関数（1030-1074行目） |

**主要処理フロー**:
1. **1032-1043行目**: インスタンスへのreset_internal_extension呼び出し
2. **1047-1057行目**: 保存された状態（プロパティ）の復元
3. **1061-1073行目**: NOTIFICATION_EXTENSION_RELOADED送信とinstance_stateクリア

#### Step 3: 状態保存・復元を理解する

リロード時の状態保存メカニズムを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | gdextension.cpp | `core/extension/gdextension.cpp` | _start_reload関数（状態保存処理） |
| 3-2 | object.cpp | `core/object/object.cpp` | reset_internal_extension関数 |

### プログラム呼び出し階層図

```
GDExtensionManager::reload_extension()
    │
    └─ GDExtension::_start_reload()
           │
           ├─ 各インスタンスのプロパティを保存
           │      └─ instance_state[obj_id].properties.push_back({name, value})
           │
           └─ ネイティブライブラリアンロード

    │
    └─ ネイティブライブラリリロード
           │
           └─ クラス再登録

    │
    └─ GDExtension::_finish_reload()
           │
           ├─ reset_internal_extension() [各インスタンス]
           │      └─ Object::_extension再設定
           │
           ├─ プロパティ復元 [各インスタンス]
           │      └─ obj->set(name, value)
           │
           └─ notification(NOTIFICATION_EXTENSION_RELOADED) [各インスタンス]
                  │
                  ├─ Object::_notification()
                  └─ 派生クラス::_notification()
                         └─ ユーザー定義のリロード後処理
```

### データフロー図

```
[入力]                    [処理]                         [出力]

エディタからの ────────▶ GDExtensionManager ────────────▶ _start_reload()
リロード要求                    │                              │
       │                       ▼                              ▼
       │              instance_state保存           プロパティ値保存
       │                       │
       │                       ▼
       │              ライブラリリロード
       │                       │
       │                       ▼
       │              _finish_reload()
       │                       │
       └───────────────────────┴───────────────────────▶ NOTIFICATION_EXTENSION_RELOADED
                                                              │
                                                              ▼
                                                        リロード後処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| object.h | `core/object/object.h` | ヘッダー | Object基底クラス定義、通知定数 |
| object.cpp | `core/object/object.cpp` | ソース | reset_internal_extensionの実装 |
| gdextension.h | `core/extension/gdextension.h` | ヘッダー | GDExtensionクラス定義 |
| gdextension.cpp | `core/extension/gdextension.cpp` | ソース | _finish_reload、リロード処理の実装 |
| gdextension_manager.h | `core/extension/gdextension_manager.h` | ヘッダー | GDExtensionManager定義 |
| gdextension_manager.cpp | `core/extension/gdextension_manager.cpp` | ソース | reload_extensionの実装 |
