# 通知設計書 3-EditorToaster ERROR

## 概要

本ドキュメントは、Godotエンジンのエディタ内で表示されるERRORレベルのトースト通知（EditorToaster ERROR）の設計仕様を記述する。

### 本通知の処理概要

EditorToaster ERRORは、Godotエディタ内でユーザーに致命的なエラーレベルのメッセージを視覚的に通知するためのトースト通知機能である。エディタUI右下に一時的に表示されるポップアップ形式の通知で、左側にエラー色の境界線が表示され、5秒後に自動的にフェードアウトする。

**業務上の目的・背景**：ゲーム開発中に発生する重大なエラー（ファイル読み込み失敗、スクリプトエラー、リソース不足など）を開発者に即座に通知する必要がある。ERROR通知は最も目立つ赤色の境界線で表示され、重大な問題の発生を開発者に確実に伝達する。内部エラーの場合は「INTERNAL ERROR:」プレフィックスが付与される。

**通知の送信タイミング**：EditorToasterのpush_toastメソッドがSEVERITY_ERROR引数で呼び出されたとき、またはエラーハンドラからERR_HANDLER_ERROR型でp_editor_notify=trueが設定された場合に通知が送信される。ERR_PRINT_EDマクロや各種ERR_FAILマクロ経由でも通知される。

**通知の受信者**：Godotエディタを使用している開発者。通知はエディタウィンドウ内のUI要素として表示されるため、エディタを操作中のユーザーのみが受信者となる。

**通知内容の概要**：エラーメッセージ文字列（内部エラーの場合は「INTERNAL ERROR:」プレフィックス付き）、エラー色（error_color）の左境界線、オプションのツールチップ（ファイルパス:行番号の形式）、コピーボタン、閉じるボタンが含まれる。

**期待されるアクション**：ユーザーはエラー内容を確認し、原因となるコードやリソースを修正する。ツールチップに表示されるファイル位置情報を参考に問題箇所を特定し、即座に対処することが期待される。

## 通知種別

アプリ内通知（エディタUI内トースト通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（MessageQueue経由で遅延呼び出し） |
| 優先度 | 高（ERROR severity = 2） |
| リトライ | 無 |

### 送信先決定ロジック

EditorToasterはシングルトンパターンで実装されており、常にエディタの単一インスタンスに対して通知が送信される。送信先はエディタUIのHBoxContainer内に動的に追加されるVBoxContainerである。

## 通知テンプレート

### アプリ内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示位置 | エディタウィンドウ右下 |
| 背景色 | エディタテーマのbase_colorとmono_colorの補間色 |
| 境界線 | 左側にエラー色（error_color）のボーダー |
| 表示時間 | 5秒（default_message_duration） |

### 本文テンプレート

```
[INTERNAL ERROR: ][エラーメッセージテキスト] [コピーボタン] [閉じるボタン]
```

内部エラーの場合のみ「INTERNAL ERROR: 」プレフィックスが付与される。

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | エラーメッセージ | push_toast引数またはエラーハンドラ | Yes |
| tooltip | ツールチップテキスト（ファイル:行番号） | push_toast引数 | No |
| severity | 重要度レベル | SEVERITY_ERROR定数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | push_toast(message, SEVERITY_ERROR) | 常時 | GDScriptまたはC++からの直接呼び出し |
| エラーハンドラ | _error_handler | p_type=ERR_HANDLER_ERROR かつ p_editor_notify=true | エラーマクロからのエラー通知 |
| マクロ | ERR_PRINT_ED | 常時 | エディタ通知付きエラーマクロ |
| マクロ | ERR_FAIL_*_EDMSG | 条件不成立時 | エディタ通知付き失敗マクロ |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| is_processing_error | エラー処理中の再帰呼び出し防止 |
| vbox_container非表示 | 通知が無効化されている場合 |
| max_temporary_count超過 | 一時通知が5件を超える場合は古いものから非表示 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[エラー発生] --> B{p_editor_notify?}
    B -->|Yes| C[_error_handler呼び出し]
    B -->|No| Z[エディタ通知なし]
    C --> D{内部エラー?}
    D -->|Yes| E[INTERNAL ERROR: プレフィックス追加]
    D -->|No| F[メッセージそのまま]
    E --> G[popup_str呼び出し]
    F --> G
    G --> H{同一メッセージ存在?}
    H -->|Yes| I[既存トーストのカウント増加]
    H -->|No| J[新規PanelContainer作成]
    J --> K[error_panel_style_background適用]
    K --> L[左ボーダーにerror_color設定]
    L --> M[HBoxContainer内にLabel追加]
    M --> N[コピー/閉じるボタン追加]
    N --> O[VBoxContainerに追加]
    O --> P[_auto_hide_or_free_toasts実行]
    P --> Q[位置更新・描画]
    I --> P
    Q --> R[5秒後自動フェードアウト]
    R --> S[終了]
    Z --> S
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし（データベースは使用しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 再帰呼び出し | is_processing_errorがtrue | 処理をスキップ |
| シングルトン未初期化 | EditorToaster::get_singleton()がnull | 処理をスキップ |
| ツリー外 | is_inside_tree()がfalse | 処理をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 同時表示上限 | 5件（max_temporary_count） |
| 保持上限 | 10件（max_temporary_count * 2） |

### 配信時間帯

制限なし（エディタ動作中は常時）

## セキュリティ考慮事項

- 通知内容はエディタ内でのみ表示され、外部に送信されない
- メッセージ内容のサニタイズは呼び出し元の責任
- クリップボードへのコピー機能はユーザー操作が必要
- ファイルパス情報がツールチップに表示されるため、機密パスの露出に注意

## 備考

- ERRORはSEVERITY値2で、最も高い優先度を持つ
- 同一メッセージが連続する場合はカウント表示される
- マウスホバー中は自動消去タイマーが一時停止される
- メインボタンの通知インジケーターは最高severity（ERROR > WARNING > INFO）の色で表示される
- 内部エラー（p_editor_notify=false）は設定によってエディタ通知の有無が制御される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

EditorToasterの内部データ構造であるToast構造体とSeverity列挙型を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | editor_toaster.h | `editor/gui/editor_toaster.h` | Severity列挙型（43-47行目）でSEVERITY_ERROR=2を確認 |
| 1-2 | editor_toaster.h | `editor/gui/editor_toaster.h` | error_panel_style_background（56行目）の定義 |

**読解のコツ**: SEVERITY_ERRORは値2であり、最高の優先度を持つ。

#### Step 2: スタイル設定を理解する

ERRORレベル固有のスタイル設定を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | コンストラクタ（589-591行目）でerror_panel_style_background初期化 |
| 2-2 | editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | NOTIFICATION_THEME_CHANGED（128-130行目）でエラー色設定 |

**主要処理フロー**:
1. **589行目**: error_panel_style_background.instantiate()
2. **590行目**: set_border_width(border_side, stylebox_radius * EDSCALE) で左ボーダー設定
3. **129行目**: set_border_color(error_color)でエラー色適用

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | popup関数（383-385行目）でSEVERITY_ERRORのスタイル適用 |
| 3-2 | editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | _draw_button（300-301行目）でエラー色インジケーター描画 |

**主要処理フロー**:
- **383行目**: case SEVERITY_ERROR分岐
- **384行目**: panel->add_theme_style_override(error_panel_style_background)
- **300行目**: highest_severityに基づく色選択でerror_color使用

#### Step 4: エラーハンドラ連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | _error_handler_impl（169-184行目）でエラー処理 |
| 4-2 | editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | 176-178行目で内部エラープレフィックス追加 |
| 4-3 | error_macros.h | `core/error/error_macros.h` | ERR_PRINT_ED（677-678行目）マクロ定義 |

**主要処理フロー**:
- **169行目**: show_all_setting条件チェック
- **173行目**: p_editor_notifyがfalseの場合の内部エラー判定
- **177行目**: "INTERNAL ERROR: " + err_strの文字列連結
- **181行目**: severityをSEVERITY_ERRORに設定

### プログラム呼び出し階層図

```
ERR_PRINT_ED(message) / ERR_FAIL_*_EDMSG(...)
    │
    └─ _err_print_error(..., true, ERR_HANDLER_ERROR)
           │
           └─ ErrorHandlerList::errfunc (EditorToaster::_error_handler)
                  │
                  └─ _error_handler_impl(file, line, error, errorexp, notify, ERROR)
                         │
                         ├─ 内部エラー判定
                         │      └─ "INTERNAL ERROR: " プレフィックス追加
                         │
                         └─ EditorToaster::popup_str(err_str, SEVERITY_ERROR, tooltip_str)
                                │
                                └─ _popup_str(message, SEVERITY_ERROR, tooltip)
                                       │
                                       └─ popup(control, SEVERITY_ERROR, time, tooltip)
                                              │
                                              └─ error_panel_style_background適用
```

### データフロー図

```
[入力]                    [処理]                           [出力]

p_error(char*)   ───▶  _error_handler_impl()  ───▶  err_str
                              │                         │
p_errorexp(char*)───▶        │                         │
                              ├─ 内部エラー判定           ▼
p_editor_notify  ───▶        │                   "INTERNAL ERROR: "
                              │                   プレフィックス追加
p_file:p_line    ───▶        │                         │
                              ▼                         ▼
                       tooltip_str生成            popup_str()
                              │                         │
                              │                  Toast構造体
                              │                         │
                              │           error_panel_style適用
                              │                         │
                              ▼                         ▼
                       "file:line"           左ボーダー(error_color)
                                                       │
                                                       ▼
                                              エディタUI表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| editor_toaster.h | `editor/gui/editor_toaster.h` | ソース | EditorToasterクラス定義、SEVERITY_ERROR定義 |
| editor_toaster.cpp | `editor/gui/editor_toaster.cpp` | ソース | ERROR固有のスタイル設定、内部エラープレフィックス処理 |
| error_macros.h | `core/error/error_macros.h` | ソース | ERR_PRINT_ED、ERR_FAIL_*_EDMSGマクロ定義 |
| error_macros.cpp | `core/error/error_macros.cpp` | ソース | _err_print_error実装 |
| EditorToaster.xml | `doc/classes/EditorToaster.xml` | ドキュメント | SEVERITY_ERROR定数のドキュメント |
