# 通知設計書 35-NOTIFICATION_MOUSE_ENTER

## 概要

本ドキュメントは、GodotエンジンのControlクラスにおけるNOTIFICATION_MOUSE_ENTER通知の設計仕様を記載する。この通知はマウスカーソルがUIコントロールの領域に入った際に発火され、ホバー状態の視覚的フィードバックやインタラクション開始を可能にする重要なイベントである。

### 本通知の処理概要

NOTIFICATION_MOUSE_ENTERは、マウスカーソルがControlノードの境界内に入った際にViewportから発行される通知である。この通知により、ボタンのホバーハイライト、ツールチップの表示準備、カーソル形状の変更などのユーザーインタラクションを実装できる。

**業務上の目的・背景**：現代のGUIアプリケーションでは、マウスホバーによるフィードバックが重要なユーザビリティ要素である。ボタンの色変化、メニュー項目のハイライト、ツールチップ表示など、マウス位置に応じたインタラクティブな応答を実現するために、この通知が使用される。

**通知の送信タイミング**：Viewportがマウス位置を追跡し、カーソルが新しいControlの領域（has_point()がtrueを返す領域）に入った際に発火される。mouse_filterがMOUSE_FILTER_IGNORE以外の場合のみ通知を受け取る。

**通知の受信者**：mouse_filterがMOUSE_FILTER_STOPまたはMOUSE_FILTER_PASSに設定されたControlノード。BaseButton派生クラス（Button、CheckBox等）、Slider、ScrollBar、TreeなどのインタラクティブUI要素が主な受信者。

**通知内容の概要**：通知値は41（NOTIFICATION_MOUSE_ENTER = 41）として定義され、マウスカーソルがコントロール領域に入ったことを示す。

**期待されるアクション**：受信ノードはホバー状態を有効にし、視覚的なフィードバックを提供する。典型的な処理として、ホバーフラグの設定、ホバー用スタイルへの切り替え、queue_redraw()による再描画がある。通知後には「mouse_entered」シグナルも発行される。

## 通知種別

ゲームエンジン内部通知（Object._notificationで受信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（マウス移動イベント処理中に発行） |
| 優先度 | 中（視覚的フィードバックに使用） |
| リトライ | なし（一度のみ発行） |

### 送信先決定ロジック

1. マウスカーソルがControl領域に入る（has_point()がtrue）
2. mouse_filterがMOUSE_FILTER_IGNORE以外であること
3. 親コントロールのclip_contents設定に従いクリップ判定
4. Z-indexに基づく前面判定（最前面のコントロールのみ受信）

## 通知テンプレート

### 内部通知の場合

| 項目 | 内容 |
|-----|------|
| 通知定数名 | NOTIFICATION_MOUSE_ENTER |
| 通知値 | 41 |
| 逆順送信 | false（通常順） |
| 形式 | 整数値（int p_what） |

### 本文テンプレート

```cpp
// _notification()での受信例
void MyButton::_notification(int p_what) {
    switch (p_what) {
        case NOTIFICATION_MOUSE_ENTER: {
            // マウスが入った
            is_hovered = true;
            // ホバー状態の描画に切り替え
            queue_redraw();
        } break;
    }
}

// GDScriptでの例
func _notification(what):
    if what == NOTIFICATION_MOUSE_ENTER:
        # ホバー開始処理
        modulate = Color(1.2, 1.2, 1.2)  # 明るくする
```

### 添付ファイル

該当なし（内部通知のため）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| p_what | 通知種別 | notification()引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| マウス移動 | InputEventMouseMotion | カーソルがControl領域に入る | 通常のマウスホバー |
| 子から親へ | 子コントロールからの退出 | 親の領域内に留まる場合 | 階層的なホバー検出 |
| ドラッグ中 | ドラッグ操作中の移動 | can_drop_dataがtrueの場合 | ドロップターゲットのハイライト |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| mouse_filter=IGNORE | MOUSE_FILTER_IGNORE設定時は通知を受け取らない |
| 親がクリップ | 親のclip_contents領域外にある場合 |
| 非可視 | visible=falseの場合 |
| 他のコントロールが前面 | より高いZ-indexのコントロールに遮られている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[マウス移動イベント] --> B[Viewportがマウス位置を処理]
    B --> C[has_point判定]
    C --> D{コントロール領域内?}
    D -->|No| E[処理終了]
    D -->|Yes| F{mouse_filter確認}
    F -->|IGNORE| E
    F -->|STOP/PASS| G{前回と異なるコントロール?}
    G -->|No| E
    G -->|Yes| H[前のコントロールにMOUSE_EXIT通知]
    H --> I[新コントロールにMOUSE_ENTER通知]
    I --> J[派生クラス_notification処理]
    J --> K[mouse_enteredシグナル発行]
    K --> E
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（ゲームエンジン内部処理のためデータベースは使用しない）

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| イベント競合 | 複数コントロールの重なり | Z-index優先度で解決 |
| 高速移動 | マウスが高速で移動してコントロールをスキップ | フレーム間でのパス補間（オプション） |
| 非同期状態 | ノード削除中のイベント | 有効性チェック |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（マウス移動に依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

エンジン実行中、マウス入力処理時に発火。

## セキュリティ考慮事項

エンジン内部通知のため、外部からの直接的なセキュリティリスクはない。ただし、マウスイベントによるユーザー追跡（クリックジャッキング等）の可能性に注意が必要。

## 備考

- NOTIFICATION_MOUSE_EXIT（値42）とペアで使用される
- NOTIFICATION_MOUSE_ENTER_SELF（値60）との違い：MOUSE_ENTERは子からの伝播を含む、MOUSE_ENTER_SELFは自身の領域への直接進入のみ
- mouse_enteredシグナルはViewportから発行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Controlクラスの構造と通知定数の定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | control.h | `scene/gui/control.h` | NOTIFICATION_MOUSE_ENTER = 41定義（425行目）、MouseFilter enum（88-92行目） |

**読解のコツ**: 値41はControl固有の通知定数。mouse_filterの設定が通知受信に影響する。

#### Step 2: エントリーポイントを理解する

Viewportからの通知発行メカニズムを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | viewport.cpp | `scene/main/viewport.cpp` | マウス位置追跡とMOUSE_ENTER通知発行 |

#### Step 3: 派生クラスでの処理例を理解する

BaseButtonなどの派生クラスでの具体的な処理パターンを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | base_button.cpp | `scene/gui/base_button.cpp` | NOTIFICATION_MOUSE_ENTER処理（ホバー状態） |
| 3-2 | slider.cpp | `scene/gui/slider.cpp` | NOTIFICATION_MOUSE_ENTER処理 |
| 3-3 | tree.cpp | `scene/gui/tree.cpp` | NOTIFICATION_MOUSE_ENTER処理 |

### プログラム呼び出し階層図

```
Viewport::_gui_input_event(InputEventMouseMotion)
    │
    └─ _gui_find_control()
           │
           └─ has_point()判定
                  │
                  └─ 新しいコントロールにホバー
                         │
                         ├─ 前コントロール::notification(MOUSE_EXIT)
                         │
                         └─ 新コントロール::notification(MOUSE_ENTER)
                                │
                                └─ 派生クラス::_notification()
                                       │
                                       └─ ホバー状態更新・再描画
```

### データフロー図

```
[入力]               [処理]                    [出力]

マウス移動 ───▶ Viewport処理 ───▶ notification(41)
イベント            │                     │
                    ├─ has_point()        ├─▶ 派生クラス処理
                    │                     │    (ホバー状態)
                    └─ mouse_filter       └─▶ "mouse_entered"シグナル
                       チェック
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| control.h | `scene/gui/control.h` | ヘッダ | Controlクラス定義、NOTIFICATION定数 |
| control.cpp | `scene/gui/control.cpp` | ソース | _notification()、has_point()実装 |
| viewport.cpp | `scene/main/viewport.cpp` | ソース | マウスイベント処理、通知発行 |
| base_button.cpp | `scene/gui/base_button.cpp` | ソース | ボタンでの通知処理例 |
| slider.cpp | `scene/gui/slider.cpp` | ソース | スライダーでの通知処理例 |
| split_container.cpp | `scene/gui/split_container.cpp` | ソース | 分割コンテナでの通知処理例 |
| tree.cpp | `scene/gui/tree.cpp` | ソース | ツリーでの通知処理例 |
| Control.xml | `doc/classes/Control.xml` | ドキュメント | 公式APIドキュメント |
