# 通知設計書 41-NOTIFICATION_SCROLL_END

## 概要

本ドキュメントは、Godotエンジンにおける `NOTIFICATION_SCROLL_END` 通知の設計仕様を記述する。この通知はControl通知の一種であり、ScrollContainer内でタッチイベントによるスクロール操作が終了した際に送信される。

### 本通知の処理概要

`NOTIFICATION_SCROLL_END` は、ScrollContainer内の子Controlノードに対して、タッチスクロール操作の終了を通知するためのシステム通知である。

**業務上の目的・背景**：モバイルデバイスやタッチ対応デバイスにおいて、ユーザーがスクロール可能な領域をタッチでスクロールする際、スクロール操作の開始と終了を検知することで、UIの挙動を適切に制御する必要がある。例えば、スクロール中はボタンのハイライト状態を抑制し、スクロール終了後に通常の入力受付を再開するといった制御が可能になる。この通知により、スクロール操作中の誤タップ防止やスムーズなUI体験を実現できる。

**通知の送信タイミング**：タッチイベントによるスクロール操作が終了し、ユーザーの指が画面から離れた時、またはスクロールの慣性移動が完全に停止した時に送信される。具体的には、ScrollContainerの`_stop_scroll_drag()`メソッド内で、スクロールのデッドゾーンを超えていた場合（`beyond_deadzone`がtrueの場合）に`propagate_notification()`を通じて送信される。

**通知の受信者**：ScrollContainerの子孫として配置されているすべてのControlノード。`propagate_notification()`により、ノードツリーを下方向に伝播する。

**通知内容の概要**：整数値48（NOTIFICATION_SCROLL_END）が通知される。追加のパラメータは含まれない。

**期待されるアクション**：受信したControlノードは、スクロール終了に応じた処理を実行できる。例えば、スクロール中に抑制していた入力処理の再開、一時停止していたアニメーションの再開、視覚的なフィードバックの更新などが考えられる。

## 通知種別

Godotエンジン内部通知（Control通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 通知値 | 48 |
| 送信方式 | 同期（propagate_notification） |
| 伝播方向 | 親から子へ（下方向伝播） |
| 対象クラス | Controlおよびその派生クラス |

### 送信先決定ロジック

ScrollContainerの`propagate_notification()`メソッドにより、自身の子孫ノードすべてに通知が伝播する。Controlクラスを継承するノードのみが`_notification()`メソッドでこの通知を処理できる。

## 通知テンプレート

### 定数定義

| 項目 | 内容 |
|-----|------|
| 定義ファイル | scene/gui/control.h |
| 定義行 | 431行目 |
| 定数名 | NOTIFICATION_SCROLL_END |
| 値 | 48 |

### 使用例

```gdscript
func _notification(what):
    if what == NOTIFICATION_SCROLL_END:
        # スクロール終了時の処理
        _on_scroll_ended()
```

```cpp
void CustomControl::_notification(int p_what) {
    switch (p_what) {
        case NOTIFICATION_SCROLL_END: {
            // スクロール終了時の処理
            _on_scroll_ended();
        } break;
    }
}
```

## テンプレート変数

この通知には追加のパラメータは含まれない。

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| p_what | 通知種別（48） | 直接渡される | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| タッチイベント | タッチリリース | beyond_deadzone == true | タッチによるドラッグスクロールが終了した時 |
| 内部処理 | スクロール停止 | drag_touchingの解除時 | 慣性スクロールが完全に停止した時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| beyond_deadzone == false | デッドゾーンを超えていない場合は送信されない |
| マウスホイールスクロール | マウスホイールによるスクロールでは送信されない |
| スクロールバードラッグ | スクロールバーをドラッグしてのスクロールでは送信されない |
| キーボード/ゲームパッド操作 | キーボードやゲームパッドによるスクロールでは送信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[タッチリリースイベント] --> B[_stop_scroll_drag呼び出し]
    B --> C{beyond_deadzone?}
    C -->|true| D[scroll_endedシグナル発信]
    D --> E[propagate_notification<br/>NOTIFICATION_SCROLL_END]
    E --> F[beyond_deadzone = false]
    C -->|false| G[スキップ]
    F --> H[終了]
    G --> H
```

## データベース参照・更新仕様

本通知はGodotエンジンの内部通知であり、データベースへのアクセスは行わない。

### 内部状態参照

| 状態変数 | 用途 | 備考 |
|---------|------|------|
| beyond_deadzone | 送信判定 | デッドゾーンを超えたかどうか |
| drag_touching | ドラッグ状態 | タッチドラッグ中かどうか |
| drag_touching_deaccel | 慣性移動状態 | 慣性によるスクロール中かどうか |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 該当なし | - | この通知は単純な伝播処理のためエラーケースなし |

### 注意事項

| 項目 | 内容 |
|-----|------|
| プラットフォーム制限 | Android/iOSまたはタッチエミュレーション有効時のみ |
| 設定依存 | `ProjectSettings.input_devices/pointing/emulate_touch_from_mouse`が有効な場合、デスクトップでも動作 |

## 配信設定

### プラットフォーム対応

| プラットフォーム | 対応状況 | 備考 |
|----------------|---------|------|
| Android | 対応 | ネイティブタッチ対応 |
| iOS | 対応 | ネイティブタッチ対応 |
| デスクトップ | 条件付き | タッチエミュレーション有効時のみ |
| Web | 条件付き | タッチデバイスまたはエミュレーション時 |

## セキュリティ考慮事項

本通知はエンジン内部のUI制御に使用されるものであり、セキュリティ上の特別な考慮事項はない。

## 備考

- NOTIFICATION_SCROLL_BEGIN（値=47）と対になる通知
- `scroll_ended`シグナルと同時に発信される
- GDScriptからは`_notification()`メソッドをオーバーライドして処理する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Controlクラスの通知定数定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | control.h | `scene/gui/control.h` | 431行目: NOTIFICATION_SCROLL_END = 48 の定義を確認 |

**読解のコツ**: Control.hのenum定義部分を参照し、他のスクロール関連通知（NOTIFICATION_SCROLL_BEGIN = 47）との関係を把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるScrollContainerの実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | scroll_container.cpp | `scene/gui/scroll_container.cpp` | _stop_scroll_drag()メソッドの実装を理解 |

**主要処理フロー**:
1. **80-86行目**: _stop_scroll_drag()でドラッグ状態変数をリセット
2. **88-92行目**: beyond_deadzone判定と通知送信

#### Step 3: 通知伝播メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | node.cpp | `scene/main/node.cpp` | propagate_notification()の実装を理解 |

**主要処理フロー**:
- **propagate_notification()**: 子ノードへの再帰的な通知伝播処理

### プログラム呼び出し階層図

```
ScrollContainer::_stop_scroll_drag()
    │
    ├─ emit_signal(SNAME("scroll_ended"))
    │
    └─ propagate_notification(NOTIFICATION_SCROLL_END)
           │
           └─ 子Control::_notification(NOTIFICATION_SCROLL_END)
                  └─ 各Controlの処理
```

### データフロー図

```
[入力]                    [処理]                         [出力]

タッチリリース ───▶ ScrollContainer        ───▶ シグナル発信
イベント              ::_stop_scroll_drag()        + 通知伝播
                              │
                              ▼
                     beyond_deadzone判定
                              │
                              ▼
                     propagate_notification() ───▶ 子Controlノードへ
                                                   通知伝播
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| control.h | `scene/gui/control.h` | ヘッダー | NOTIFICATION_SCROLL_END定数定義（431行目） |
| control.cpp | `scene/gui/control.cpp` | ソース | BIND_CONSTANT定義（4336行目） |
| scroll_container.h | `scene/gui/scroll_container.h` | ヘッダー | ScrollContainerクラス定義 |
| scroll_container.cpp | `scene/gui/scroll_container.cpp` | ソース | _stop_scroll_drag()での通知送信（90行目） |
| Control.xml | `doc/classes/Control.xml` | ドキュメント | 通知の公式ドキュメント（1316-1319行目） |
