# 通知設計書 42-NOTIFICATION_ENTER_WORLD

## 概要

本ドキュメントは、Godotエンジンにおける `NOTIFICATION_ENTER_WORLD` 通知の設計仕様を記述する。この通知はNode3D通知の一種であり、3DノードがWorld3Dに登録された際に送信される。

### 本通知の処理概要

`NOTIFICATION_ENTER_WORLD` は、Node3Dおよびその派生クラスのノードが3Dワールドに入った（登録された）ことを通知するためのシステム通知である。

**業務上の目的・背景**：3Dゲームやアプリケーションにおいて、3Dオブジェクトがワールドに追加された際に初期化処理を行う必要がある。例えば、物理ボディのワールドへの登録、描画リソースのシナリオへのアタッチ、カメラやライトの有効化などが挙げられる。この通知により、ノードがレンダリング可能な状態になったことを検知し、必要な初期化処理を実行できる。NOTIFICATION_ENTER_TREEとは異なり、3Dワールドへの登録を明確に区別することで、2D/3D混在環境でも適切な処理が可能になる。

**通知の送信タイミング**：Node3DがSceneTreeに追加され、有効なWorld3Dが設定されたタイミングで送信される。具体的には、NOTIFICATION_ENTER_TREEの処理中に、node_3d.cppの175行目で`notification(NOTIFICATION_ENTER_WORLD)`が呼び出される。

**通知の受信者**：Node3Dクラスおよびそのすべての派生クラス（VisualInstance3D、CollisionObject3D、Camera3D、Light3Dなど）。

**通知内容の概要**：整数値41（NOTIFICATION_ENTER_WORLD）が通知される。追加のパラメータは含まれない。

**期待されるアクション**：受信したノードは、3Dワールドに必要なリソースの初期化・登録を行う。VisualInstance3Dではインスタンスをシナリオに登録し、CollisionObject3Dでは物理ワールドへの登録を行う。また、スクリプトで`_enter_world()`メソッドが定義されている場合、そのメソッドが呼び出される。

## 通知種別

Godotエンジン内部通知（Node3D通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 通知値 | 41 |
| 送信方式 | 同期（notification呼び出し） |
| 伝播方向 | 自ノードのみ（子ノードは個別にENTER_TREE時に受信） |
| 対象クラス | Node3Dおよびその派生クラス |

### 送信先決定ロジック

NOTIFICATION_ENTER_TREEの処理中に、自ノードに対してのみ送信される。子ノードは、それぞれのENTER_TREE処理時に個別にNOTIFICATION_ENTER_WORLDを受信する。

## 通知テンプレート

### 定数定義

| 項目 | 内容 |
|-----|------|
| 定義ファイル | scene/3d/node_3d.h |
| 定数名 | NOTIFICATION_ENTER_WORLD |
| 値 | 41 |

### 使用例

```gdscript
func _notification(what):
    if what == NOTIFICATION_ENTER_WORLD:
        # 3Dワールドに入った時の処理
        _setup_3d_resources()
```

```cpp
void Custom3DNode::_notification(int p_what) {
    switch (p_what) {
        case NOTIFICATION_ENTER_WORLD: {
            // 3Dワールドに入った時の処理
            _setup_3d_resources();
        } break;
    }
}
```

### スクリプトコールバック

```gdscript
# スクリプトで_enter_world()を定義すると自動的に呼び出される
func _enter_world():
    print("Entered 3D world")
```

## テンプレート変数

この通知には追加のパラメータは含まれない。

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| p_what | 通知種別（41） | 直接渡される | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ツリー追加 | NOTIFICATION_ENTER_TREE | Node3Dがツリーに追加された時 | ENTER_TREEの処理中に送信 |
| ワールド変更 | ワールドの切り替え | 新しいWorld3Dが設定された時 | Viewport移動時など |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ツリー外 | SceneTreeに追加されていない場合は送信されない |
| World3D未設定 | 有効なWorld3Dが存在しない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Node3D追加] --> B[NOTIFICATION_ENTER_TREE]
    B --> C[トランスフォーム初期化]
    C --> D[notification<br/>NOTIFICATION_ENTER_WORLD]
    D --> E[_update_visibility_parent]
    E --> F[物理補間セットアップ]
    F --> G[終了]
```

## データベース参照・更新仕様

本通知はGodotエンジンの内部通知であり、データベースへのアクセスは行わない。

### 内部状態更新

| 状態変数 | 操作 | 備考 |
|---------|------|------|
| data.inside_world | true設定 | 235-238行目 |
| data.viewport | 設定 | 親をたどってViewportを検索 |

### 派生クラスでの処理例

#### VisualInstance3D

| 処理 | 内容 |
|-----|------|
| シナリオ登録 | RenderingServer::instance_set_scenario() |
| スケルトンアタッチ | RenderingServer::instance_attach_skeleton() |
| 可視性更新 | _set_vi_visible(true) |

#### Camera3D

| 処理 | 内容 |
|-----|------|
| Viewportへのカメラ設定 | 現在のカメラとして設定 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| メインスレッド違反 | メインスレッド以外から呼び出し | ERR_MAIN_THREAD_GUARDマクロでエラー出力 |

### スレッド安全性

| 項目 | 内容 |
|-----|------|
| スレッド制限 | メインスレッドのみ |
| ガード | ERR_MAIN_THREAD_GUARD |

## 配信設定

### プラットフォーム対応

| プラットフォーム | 対応状況 | 備考 |
|----------------|---------|------|
| 全プラットフォーム | 対応 | 3D機能を持つすべてのプラットフォーム |

## セキュリティ考慮事項

本通知はエンジン内部の3Dノード管理に使用されるものであり、セキュリティ上の特別な考慮事項はない。

## 備考

- NOTIFICATION_EXIT_WORLD（値=42）と対になる通知
- Node3D.xmlのドキュメントで公式に記載されている
- VisualInstance3Dなど多くの3Dノードがこの通知を処理してリソースを初期化する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Node3Dクラスの通知定数定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | node_3d.h | `scene/3d/node_3d.h` | NOTIFICATION_ENTER_WORLD = 41 の定義を確認 |
| 1-2 | Node3D.xml | `doc/classes/Node3D.xml` | 378-380行目: 公式ドキュメントの記述を確認 |

**読解のコツ**: Node3D.hのenum定義部分を参照し、NOTIFICATION_EXIT_WORLD（42）との関係を把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるnode_3d.cppの_notification()を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | node_3d.cpp | `scene/3d/node_3d.cpp` | NOTIFICATION_ENTER_TREE caseの処理を理解 |

**主要処理フロー**:
1. **136-176行目**: NOTIFICATION_ENTER_TREEの処理
2. **172-175行目**: ダーティフラグ設定と通知送信
3. **175行目**: `notification(NOTIFICATION_ENTER_WORLD)` の呼び出し

#### Step 3: ENTER_WORLDハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | node_3d.cpp | `scene/3d/node_3d.cpp` | NOTIFICATION_ENTER_WORLD caseの処理（235-258行目） |

**主要処理フロー**:
- **235-238行目**: inside_world = true設定、viewport検索
- **245-250行目**: スクリプトの_enter_world()呼び出し
- **252-256行目**: エディタでのギズモリクエスト

#### Step 4: 派生クラスでの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | visual_instance_3d.cpp | `scene/3d/visual_instance_3d.cpp` | NOTIFICATION_ENTER_WORLDでのシナリオ登録処理 |

### プログラム呼び出し階層図

```
Node3D::_notification(NOTIFICATION_ENTER_TREE)
    │
    ├─ トランスフォーム初期化処理
    │
    ├─ notification(NOTIFICATION_ENTER_WORLD)
    │      │
    │      └─ Node3D::_notification(NOTIFICATION_ENTER_WORLD)
    │             │
    │             ├─ data.inside_world = true
    │             ├─ Viewport検索・設定
    │             └─ script->call("_enter_world")
    │
    └─ _update_visibility_parent(true)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

SceneTree追加 ───▶ Node3D                      ───▶ inside_world = true
                   ::ENTER_TREE処理                    + viewport設定
                          │
                          ▼
                   notification(ENTER_WORLD)
                          │
                          ▼
                   ENTER_WORLDハンドラ ───▶ _enter_world()
                          │                    コールバック
                          ▼
                   派生クラスの処理 ───▶ RenderingServerへの
                   (VisualInstance3D等)    リソース登録
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| node_3d.h | `scene/3d/node_3d.h` | ヘッダー | NOTIFICATION_ENTER_WORLD定数定義 |
| node_3d.cpp | `scene/3d/node_3d.cpp` | ソース | 通知送信（175行目）、ハンドラ（235-258行目） |
| visual_instance_3d.cpp | `scene/3d/visual_instance_3d.cpp` | ソース | シナリオ登録処理 |
| camera_3d.cpp | `scene/3d/camera_3d.cpp` | ソース | カメラのワールド登録処理 |
| Node3D.xml | `doc/classes/Node3D.xml` | ドキュメント | 通知の公式ドキュメント（378-380行目） |
