# 通知設計書 45-NOTIFICATION_WM_MOUSE_ENTER

## 概要

本ドキュメントは、Godotエンジンにおける `NOTIFICATION_WM_MOUSE_ENTER` 通知の設計仕様を記述する。この通知はWindow/MainLoop通知の一種であり、マウスカーソルがウィンドウ領域に入った際に送信される。

### 本通知の処理概要

`NOTIFICATION_WM_MOUSE_ENTER` は、マウスカーソルがゲームウィンドウの領域に入ったことを通知するためのシステム通知である。ウィンドウマネージャー（WM）レベルのイベントを検知する。

**業務上の目的・背景**：ゲームやアプリケーションにおいて、マウスカーソルがウィンドウ領域に入った/出たを検知することで、適切なUI応答やゲームロジックの制御が可能になる。例えば、マウスがウィンドウに入った時にカーソル形状を復元する、ゲームのポーズ状態を解除する、ツールチップを表示するなどの処理が考えられる。この通知はControl.NOTIFICATION_MOUSE_ENTERとは異なり、特定のControlノードではなくウィンドウ全体へのマウス進入を検知する。

**通知の送信タイミング**：DisplayServerからWINDOW_EVENT_MOUSE_ENTERイベントを受信した時に送信される。具体的には、window.cppの795行目で`_propagate_window_notification(this, NOTIFICATION_WM_MOUSE_ENTER)`が呼び出される。また、埋め込みウィンドウ（is_embedded() == true）の場合は、_update_mouse_over()メソッド内の3139行目でも送信される。

**通知の受信者**：Windowノードの子孫として存在するすべてのNodeノード。`_propagate_window_notification()`により、ウィンドウ内のノードツリー全体に伝播する。

**通知内容の概要**：整数値1002（NOTIFICATION_WM_MOUSE_ENTER）が通知される。追加のパラメータは含まれない。

**期待されるアクション**：受信したノードは、マウスがウィンドウに入ったことに応じた処理を実行できる。例えば、カーソル形状の設定、入力処理の有効化、視覚的フィードバックの開始などが考えられる。

## 通知種別

Godotエンジン内部通知（Window/MainLoop通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 通知値 | 1002 |
| 送信方式 | 同期（_propagate_window_notification） |
| 伝播方向 | ウィンドウ内の全ノードへ |
| 対象クラス | Nodeおよびその派生クラス |

### 送信先決定ロジック

`_propagate_window_notification()`メソッドにより、Windowノードの子孫すべてに通知が伝播する。すべてのNodeクラスが`_notification()`メソッドでこの通知を処理できる。

## 通知テンプレート

### 定数定義

| 項目 | 内容 |
|-----|------|
| 定義ファイル | scene/main/node.h |
| 定義行 | 477行目 |
| 定数名 | NOTIFICATION_WM_MOUSE_ENTER |
| 値 | 1002 |

### 使用例

```gdscript
func _notification(what):
    if what == NOTIFICATION_WM_MOUSE_ENTER:
        # マウスがウィンドウに入った時の処理
        _on_window_mouse_enter()
```

```cpp
void CustomNode::_notification(int p_what) {
    switch (p_what) {
        case NOTIFICATION_WM_MOUSE_ENTER: {
            // マウスがウィンドウに入った時の処理
            _on_window_mouse_enter();
        } break;
    }
}
```

## テンプレート変数

この通知には追加のパラメータは含まれない。

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| p_what | 通知種別（1002） | 直接渡される | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| DisplayServerイベント | WINDOW_EVENT_MOUSE_ENTER | マウスがウィンドウ領域に入った時 | OS/ウィンドウマネージャーからのイベント |
| 埋め込みウィンドウ | _update_mouse_over | 埋め込みウィンドウでマウスが入った時 | is_embedded() == true |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既にウィンドウ内 | mouse_in_window == true の場合はスキップ（重複防止） |
| 別ウィンドウがホバー中 | 他のウィンドウがホバー状態の場合は先にEXIT処理 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[DisplayServer<br/>WINDOW_EVENT_MOUSE_ENTER] --> B[Window::_event_callback]
    B --> C{他ウィンドウが<br/>ホバー中?}
    C -->|Yes| D[他ウィンドウに<br/>MOUSE_EXIT送信]
    C -->|No| E[_propagate_window_notification<br/>WM_MOUSE_ENTER]
    D --> E
    E --> F[windowmanager_window_over設定]
    F --> G[mouse_in_window = true]
    G --> H[カーソル形状復元]
    H --> I[終了]
```

## データベース参照・更新仕様

本通知はGodotエンジンの内部通知であり、データベースへのアクセスは行わない。

### 内部状態更新

| 状態変数 | 操作 | 備考 |
|---------|------|------|
| mouse_in_window | true設定 | 797行目 |
| root->gui.windowmanager_window_over | 自ウィンドウ設定 | 796行目 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 警告出力 | 別ウィンドウホバー中に新たなENTER | DEV_ENABLED時にWARN_PRINT_ONCE |

### デバッグ出力

| 項目 | 内容 |
|-----|------|
| 警告 | "Entering a window while a window is hovered should never happen in DisplayServer." |
| 条件 | DEV_ENABLED && root->gui.windowmanager_window_over != nullptr |

## 配信設定

### プラットフォーム対応

| プラットフォーム | 対応状況 | 備考 |
|----------------|---------|------|
| Windows | 対応 | ネイティブウィンドウイベント |
| macOS | 対応 | ネイティブウィンドウイベント |
| Linux | 対応 | X11/Wayland対応 |
| Web | 条件付き | ブラウザイベントに依存 |
| Android | 限定的 | タッチ入力が主 |
| iOS | 限定的 | タッチ入力が主 |

## セキュリティ考慮事項

本通知はエンジン内部のマウスイベント管理に使用されるものであり、セキュリティ上の特別な考慮事項はない。

## 備考

- NOTIFICATION_WM_MOUSE_EXIT（値=1003）と対になる通知
- Control.NOTIFICATION_MOUSE_ENTER（値=41）とは異なる通知
- カーソル形状がDisplayServer::CURSOR_ARROWに復元される
- 埋め込みウィンドウとネイティブウィンドウで処理パスが異なる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Nodeクラスの通知定数定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | node.h | `scene/main/node.h` | 477行目: NOTIFICATION_WM_MOUSE_ENTER = 1002 の定義を確認 |

**読解のコツ**: Node.hのenum定義部分を参照し、他のWM系通知との関係を把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるWindow::_event_callback()を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | window.cpp | `scene/main/window.cpp` | _event_callback()のWINDOW_EVENT_MOUSE_ENTER処理（785-800行目） |

**主要処理フロー**:
1. **786-794行目**: 他ウィンドウがホバー中の場合の処理
2. **795行目**: `_propagate_window_notification(this, NOTIFICATION_WM_MOUSE_ENTER)` の呼び出し
3. **796-799行目**: 状態変数の更新とカーソル復元

#### Step 3: 埋め込みウィンドウの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | window.cpp | `scene/main/window.cpp` | _update_mouse_over()の処理（3135-3141行目） |

**主要処理フロー**:
- **3136-3140行目**: 埋め込みウィンドウでのmouse_in_window判定と通知送信

### プログラム呼び出し階層図

```
DisplayServer
    │
    └─ Window::_event_callback(WINDOW_EVENT_MOUSE_ENTER)
           │
           ├─ [前ウィンドウへMOUSE_EXIT送信] (条件付き)
           │
           ├─ _propagate_window_notification(NOTIFICATION_WM_MOUSE_ENTER)
           │      │
           │      └─ 全子孫Node::_notification(NOTIFICATION_WM_MOUSE_ENTER)
           │
           ├─ windowmanager_window_over = this
           │
           ├─ mouse_in_window = true
           │
           └─ cursor_set_shape(CURSOR_ARROW)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

DisplayServer ───▶ Window                      ───▶ 通知伝播
WINDOW_EVENT         ::_event_callback()              + 状態更新
                            │
                            ▼
                    _propagate_window_notification()
                            │
                            ▼
                    全子孫Nodeへ通知 ───▶ 各ノードの処理
                            │
                            ▼
                    状態更新 ───▶ mouse_in_window = true
                    + カーソル復元
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| node.h | `scene/main/node.h` | ヘッダー | NOTIFICATION_WM_MOUSE_ENTER定数定義（477行目） |
| window.cpp | `scene/main/window.cpp` | ソース | _event_callback()での通知送信（795行目） |
| window.cpp | `scene/main/window.cpp` | ソース | _update_mouse_over()での埋め込み処理（3139行目） |
| display_server.h | `servers/display_server.h` | ヘッダー | WINDOW_EVENT_MOUSE_ENTERイベント定義 |
