# 通知設計書 46-NOTIFICATION_WM_MOUSE_EXIT

## 概要

本ドキュメントは、Godotエンジンにおける `NOTIFICATION_WM_MOUSE_EXIT` 通知の設計仕様を記述する。この通知はWindow/MainLoop通知の一種であり、マウスカーソルがウィンドウ領域から出た際に送信される。

### 本通知の処理概要

`NOTIFICATION_WM_MOUSE_EXIT` は、マウスカーソルがゲームウィンドウの領域から出たことを通知するためのシステム通知である。ウィンドウマネージャー（WM）レベルのイベントを検知する。

**業務上の目的・背景**：ゲームやアプリケーションにおいて、マウスカーソルがウィンドウ領域から出たことを検知することで、適切なUI応答やゲームロジックの制御が可能になる。例えば、マウスがウィンドウから出た時にゲームをポーズする、ドラッグ操作をキャンセルする、ホバー状態のUIをリセットするなどの処理が考えられる。この通知はControl.NOTIFICATION_MOUSE_EXITとは異なり、特定のControlノードではなくウィンドウ全体からのマウス退出を検知する。

**通知の送信タイミング**：DisplayServerからWINDOW_EVENT_MOUSE_EXITイベントを受信した時に送信される。具体的には、window.cppの819行目で`_propagate_window_notification(this, NOTIFICATION_WM_MOUSE_EXIT)`が呼び出される。また、埋め込みウィンドウ（is_embedded() == true）の場合は、_mouse_leave_viewport()メソッド内の3163行目でも送信される。

**通知の受信者**：Windowノードの子孫として存在するすべてのNodeノード。`_propagate_window_notification()`により、ウィンドウ内のノードツリー全体に伝播する。

**通知内容の概要**：整数値1003（NOTIFICATION_WM_MOUSE_EXIT）が通知される。追加のパラメータは含まれない。

**期待されるアクション**：受信したノードは、マウスがウィンドウから出たことに応じた処理を実行できる。例えば、ホバー状態のリセット、ドラッグ操作のキャンセル、視覚的フィードバックの終了などが考えられる。

## 通知種別

Godotエンジン内部通知（Window/MainLoop通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 通知値 | 1003 |
| 送信方式 | 同期（_propagate_window_notification） |
| 伝播方向 | ウィンドウ内の全ノードへ |
| 対象クラス | Nodeおよびその派生クラス |

### 送信先決定ロジック

`_propagate_window_notification()`メソッドにより、Windowノードの子孫すべてに通知が伝播する。すべてのNodeクラスが`_notification()`メソッドでこの通知を処理できる。

## 通知テンプレート

### 定数定義

| 項目 | 内容 |
|-----|------|
| 定義ファイル | scene/main/node.h |
| 定義行 | 478行目 |
| 定数名 | NOTIFICATION_WM_MOUSE_EXIT |
| 値 | 1003 |

### 使用例

```gdscript
func _notification(what):
    if what == NOTIFICATION_WM_MOUSE_EXIT:
        # マウスがウィンドウから出た時の処理
        _on_window_mouse_exit()
```

```cpp
void CustomNode::_notification(int p_what) {
    switch (p_what) {
        case NOTIFICATION_WM_MOUSE_EXIT: {
            // マウスがウィンドウから出た時の処理
            _on_window_mouse_exit();
        } break;
    }
}
```

## テンプレート変数

この通知には追加のパラメータは含まれない。

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| p_what | 通知種別（1003） | 直接渡される | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| DisplayServerイベント | WINDOW_EVENT_MOUSE_EXIT | マウスがウィンドウ領域から出た時 | OS/ウィンドウマネージャーからのイベント |
| 埋め込みウィンドウ | _mouse_leave_viewport | 埋め込みウィンドウからマウスが出た時 | is_embedded() == true |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既にウィンドウ外 | mouse_in_window == false の場合はスキップ（重複防止） |
| 別ウィンドウがホバー | windowmanager_window_over != this の場合はreturn |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[DisplayServer<br/>WINDOW_EVENT_MOUSE_EXIT] --> B[Window::_event_callback]
    B --> C{windowmanager_window_over<br/>== this?}
    C -->|No| D[return]
    C -->|Yes| E[mouse_in_window = false]
    E --> F[_mouse_leave_viewport]
    F --> G[windowmanager_window_over = nullptr]
    G --> H[_propagate_window_notification<br/>WM_MOUSE_EXIT]
    H --> I[終了]
```

## データベース参照・更新仕様

本通知はGodotエンジンの内部通知であり、データベースへのアクセスは行わない。

### 内部状態更新

| 状態変数 | 操作 | 備考 |
|---------|------|------|
| mouse_in_window | false設定 | 816行目 |
| root->gui.windowmanager_window_over | nullptr設定 | 818行目 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 該当なし | - | 条件チェックにより不正な呼び出しを防止 |

## 配信設定

### プラットフォーム対応

| プラットフォーム | 対応状況 | 備考 |
|----------------|---------|------|
| Windows | 対応 | ネイティブウィンドウイベント |
| macOS | 対応 | ネイティブウィンドウイベント |
| Linux | 対応 | X11/Wayland対応 |
| Web | 条件付き | ブラウザイベントに依存 |
| Android | 限定的 | タッチ入力が主 |
| iOS | 限定的 | タッチ入力が主 |

## セキュリティ考慮事項

本通知はエンジン内部のマウスイベント管理に使用されるものであり、セキュリティ上の特別な考慮事項はない。

## 備考

- NOTIFICATION_WM_MOUSE_ENTER（値=1002）と対になる通知
- Control.NOTIFICATION_MOUSE_EXIT（値=42）とは異なる通知
- _mouse_leave_viewport()が先に呼ばれ、その後に通知が送信される
- 埋め込みウィンドウとネイティブウィンドウで処理パスが異なる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Nodeクラスの通知定数定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | node.h | `scene/main/node.h` | 478行目: NOTIFICATION_WM_MOUSE_EXIT = 1003 の定義を確認 |

**読解のコツ**: Node.hのenum定義部分を参照し、NOTIFICATION_WM_MOUSE_ENTER（1002）との関係を把握する。

#### Step 2: エントリーポイントを理解する

処理の起点となるWindow::_event_callback()を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | window.cpp | `scene/main/window.cpp` | _event_callback()のWINDOW_EVENT_MOUSE_EXIT処理（801-820行目） |

**主要処理フロー**:
1. **808-814行目**: windowmanager_window_overのチェック
2. **816行目**: mouse_in_window = false
3. **817行目**: _mouse_leave_viewport()呼び出し
4. **818行目**: windowmanager_window_over = nullptr
5. **819行目**: `_propagate_window_notification(this, NOTIFICATION_WM_MOUSE_EXIT)` の呼び出し

#### Step 3: 埋め込みウィンドウの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | window.cpp | `scene/main/window.cpp` | _mouse_leave_viewport()の処理（3159-3165行目） |

**主要処理フロー**:
- **3160行目**: Viewport::_mouse_leave_viewport()呼び出し
- **3161-3164行目**: 埋め込みウィンドウでの通知送信

### プログラム呼び出し階層図

```
DisplayServer
    │
    └─ Window::_event_callback(WINDOW_EVENT_MOUSE_EXIT)
           │
           ├─ mouse_in_window = false
           │
           ├─ _mouse_leave_viewport()
           │      └─ Viewport::_mouse_leave_viewport()
           │
           ├─ windowmanager_window_over = nullptr
           │
           └─ _propagate_window_notification(NOTIFICATION_WM_MOUSE_EXIT)
                  │
                  └─ 全子孫Node::_notification(NOTIFICATION_WM_MOUSE_EXIT)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

DisplayServer ───▶ Window                      ───▶ 状態更新
WINDOW_EVENT         ::_event_callback()              + 通知伝播
                            │
                            ▼
                    状態更新 ───▶ mouse_in_window = false
                            │
                            ▼
                    _mouse_leave_viewport()
                            │
                            ▼
                    _propagate_window_notification()
                            │
                            ▼
                    全子孫Nodeへ通知 ───▶ 各ノードの処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| node.h | `scene/main/node.h` | ヘッダー | NOTIFICATION_WM_MOUSE_EXIT定数定義（478行目） |
| window.cpp | `scene/main/window.cpp` | ソース | _event_callback()での通知送信（819行目） |
| window.cpp | `scene/main/window.cpp` | ソース | _mouse_leave_viewport()での埋め込み処理（3163行目） |
| display_server.h | `servers/display_server.h` | ヘッダー | WINDOW_EVENT_MOUSE_EXITイベント定義 |
